/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import com.BreadRes.desertstormwarming.logic.SandstormPhase;
import com.BreadRes.desertstormwarming.sounds.SandstormSounds;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.event.BiomeChangeManager;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.manager.ForecastPointerRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.sandStorm.SandStormAPI;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import org.apache.commons.lang3.tuple.Pair;

public class SandStormManager {
    private static final float SANDSTORM_WIND_THRESHOLD_BASE = 10.0f;
    private static final float SANDSTORM_WIND_THRESHOLD_MIN = 6.0f;
    private static final float SANDSTORM_HUMIDITY_THRESHOLD_BASE = 20.0f;
    private static final float SANDSTORM_HUMIDITY_THRESHOLD_MAX = 35.0f;
    private static final float SANDSTORM_PRESSURE_THRESHOLD_BASE = 1005.0f;
    private static final float SANDSTORM_PRESSURE_THRESHOLD_MAX = 1015.0f;
    static BiomeInstanceKey scheduledStormBiome = null;
    static SandstormPhase scheduledStormPhase = null;
    static long scheduledStormTime = -1L;
    public static final Set<ResourceLocation> SANDSTORM_BIOMES = Set.of(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"desert"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"badlands"));
    private static final Set<BiomeInstanceKey> SANDSTORM_FORECASTS = ConcurrentHashMap.newKeySet();
    private static int tickCounter = 0;

    public static BiomeInstanceKey getScheduledSandstormBiome() {
        return scheduledStormBiome;
    }

    public static Set<BiomeInstanceKey> getSandstormForecasts() {
        return Collections.unmodifiableSet(SANDSTORM_FORECASTS);
    }

    static void clearSandstormForecasts() {
        SANDSTORM_FORECASTS.clear();
        scheduledStormBiome = null;
        scheduledStormPhase = null;
        scheduledStormTime = -1L;
        tickCounter = 0;
    }

    static void dailyAndSand(ServerLevel level) {
        BiomeForecast forecast;
        BiomeInstanceKey selected;
        SandStormManager.clearSandstormForecasts();
        ForecastGenerator.FORECAST_MAP.entrySet().stream().filter(entry -> SANDSTORM_BIOMES.contains(((BiomeInstanceKey)entry.getKey()).biomeType())).filter(entry -> {
            BiomeForecast f = (BiomeForecast)entry.getValue();
            return f.getHumidity() != null && f.getHumidity().length > 0 && f.getPressure() != null && f.getPressure().length > 0 && f.getWind() != null && f.getWind().length > 0;
        }).filter(entry -> SandStormManager.shouldTriggerSandstorm((BiomeInstanceKey)entry.getKey(), ((BiomeForecast)entry.getValue()).getHumidity(), ((BiomeForecast)entry.getValue()).getPressure(), ((BiomeForecast)entry.getValue()).getWind()[0])).forEach(entry -> {
            BiomeInstanceKey key = (BiomeInstanceKey)entry.getKey();
            ((BiomeForecast)entry.getValue()).setSandstormExpected(true);
            SANDSTORM_FORECASTS.add(key);
        });
        ForecastGenerator.REGION_FORECASTS.forEach(AtmosphericStateRegistry::initializeState);
        ForecastGenerator.computeAverageForecastsByBiomeType();
        ForecastGenerator.FORECAST_MAP.forEach(ForecastPointerRegistry::setPointer);
        if (!ForecastGenerator.sandStormLoaded) {
            return;
        }
        if (!SandStormAPI.isSandstormActive() && scheduledStormBiome == null && !SANDSTORM_FORECASTS.isEmpty() && (selected = (BiomeInstanceKey)SANDSTORM_FORECASTS.stream().skip(level.f_46441_.m_188503_(SANDSTORM_FORECASTS.size())).findFirst().orElse(null)) != null && (forecast = ForecastGenerator.FORECAST_MAP.get(selected)) != null) {
            long baseTime = level.m_46468_() / 24000L * 24000L;
            long randomOffset = 1000 + level.f_46441_.m_188503_(9000);
            scheduledStormBiome = selected;
            scheduledStormPhase = SandStormManager.computeStormPhase(forecast);
            scheduledStormTime = baseTime + randomOffset;
            if (ProjectAtmosphere.DEBUG_MODE) {
                ProjectAtmosphere.LOGGER.info("[Atmosphere] Scheduled sandstorm at tick {} in biome {} (phase: {})", (Object)scheduledStormTime, (Object)selected.biomeType(), (Object)scheduledStormPhase);
            }
            for (ServerPlayer player : level.m_6907_()) {
                boolean lastBiomeFlag = (Boolean)BiomeChangeManager.getLastBiome().getOrDefault(player.m_20148_(), (Pair<ResourceLocation, Boolean>)Pair.of(null, (Object)false)).getValue();
                if (lastBiomeFlag) continue;
                for (SoundEvent soundEvent : SandstormSounds.getSoundsForPhase((SandstormPhase)SandStormAPI.getSandstormPhase())) {
                    Minecraft.m_91087_().m_91106_().m_120386_(soundEvent.m_11660_(), null);
                }
            }
        }
    }

    static void tickSandstormScheduler(ServerLevel level) {
        if (scheduledStormBiome != null && level.m_46468_() >= scheduledStormTime) {
            SandStormAPI.startSandstorm(scheduledStormPhase, scheduledStormBiome);
            if (ProjectAtmosphere.DEBUG_MODE) {
                ProjectAtmosphere.LOGGER.info("[Atmosphere] Triggered sandstorm in biome {} with phase {}", (Object)scheduledStormBiome.biomeType(), (Object)scheduledStormPhase);
            }
            scheduledStormBiome = null;
            scheduledStormTime = -1L;
            scheduledStormPhase = null;
        }
        if (SandStormAPI.isSandstormActive() && tickCounter % 50 == 0) {
            List<BiomeInstanceKey> sandStorms = SandStormAPI.getScheduledStormBiome();
            if (sandStorms.isEmpty()) {
                ProjectAtmosphere.LOGGER.warn("[Atmosphere] No sandstorm biomes found, but storm is active!");
                return;
            }
            if (ProjectAtmosphere.DEBUG_MODE) {
                ProjectAtmosphere.LOGGER.info("[Atmosphere] Sandstorm active in {} biomes: {}", (Object)sandStorms.size(), sandStorms);
            }
            AsyncAtmosphereService.runStorm(() -> {
                for (BiomeInstanceKey biome : sandStorms) {
                    SandStormAPI.blowSandInBiome(level, biome, ForecastGenerator.getWindValue(biome, level.m_46468_()));
                }
            });
            tickCounter = 0;
        }
        ++tickCounter;
    }

    static boolean shouldTriggerSandstorm(BiomeInstanceKey key, float[][] humidity, float[][] pressure, WindVector wind) {
        if (!SANDSTORM_BIOMES.contains(key.biomeType())) {
            return false;
        }
        if (humidity == null || humidity.length == 0 || humidity[0].length == 0) {
            return false;
        }
        if (pressure == null || pressure.length == 0 || pressure[0].length == 0) {
            return false;
        }
        if (wind == null) {
            return false;
        }
        float todayHumidityMin = humidity[0][0];
        float todayPressureMin = pressure[0][0];
        float windSpeed = wind.gustSpeed();
        float dryness = Math.max(0.0f, 1.0f - todayHumidityMin / 35.0f);
        float gustiness = Math.max(0.0f, (windSpeed - 6.0f) / Math.max(1.0f, 4.0f));
        float pressureDrop = Math.max(0.0f, (1005.0f - todayPressureMin) / 20.0f);
        float severity = dryness * 0.5f + gustiness * 0.3f + pressureDrop * 0.2f;
        boolean dryEnough = todayHumidityMin < 20.0f || dryness > 0.6f;
        boolean windyEnough = windSpeed > 8.5f;
        boolean unstablePressure = todayPressureMin < 1007.0f;
        return dryEnough && windyEnough && unstablePressure && severity > 0.55f;
    }

    static SandstormPhase computeStormPhase(BiomeForecast forecast) {
        float wind = forecast.getWind()[0].baseSpeed();
        float pressure = forecast.getPressure()[0][0];
        float humidity = forecast.getHumidity()[0][0];
        if (wind > 35.0f && pressure < 980.0f && humidity < 0.15f) {
            return SandstormPhase.PHASE_5;
        }
        if (wind > 30.0f) {
            return SandstormPhase.PHASE_4;
        }
        if (wind > 25.0f) {
            return SandstormPhase.PHASE_3;
        }
        if (wind > 20.0f) {
            return SandstormPhase.PHASE_2;
        }
        return SandstormPhase.PHASE_1;
    }
}

