/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.mixin;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import java.util.ArrayList;
import java.util.List;
import net.Gabou.projectatmosphere.api.common.cloud.region.ITornadoRegion;
import net.Gabou.projectatmosphere.api.common.cloud.region.ScAPICloudRegionTornadoAccess;
import net.Gabou.projectatmosphere.api.common.cloud.region.TornadoDescriptor;
import net.Gabou.projectatmosphere.util.ICloudRegionId;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec2;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CloudRegion.class}, remap=false)
public abstract class CloudRegionMixin
implements ICloudRegionId,
ITornadoRegion,
ScAPICloudRegionTornadoAccess {
    @Unique
    private int projectatmosphere$id;
    @Unique
    private static final RandomSource PROJECTATMOSPHERE$RANDOM = RandomSource.m_216327_();
    @Unique
    private List<TornadoDescriptor> projectatmosphere$tornadoes = new ArrayList<TornadoDescriptor>();
    @Unique
    private float projectatmosphere$prevTickX;
    @Unique
    private float projectatmosphere$prevTickZ;
    @Shadow
    private float radius;
    @Shadow
    private float radiusO;
    @Shadow
    private float initialRadius;
    @Shadow
    private int existsForTicks;
    @Shadow
    private int growTicks;
    @Shadow
    private float posX;
    @Shadow
    private float posZ;
    @Shadow
    protected ResourceLocation cloudTypeId;
    @Unique
    private static final float MAX_RADIUS_MULTIPLIER = 1.3f;
    @Unique
    private static final float MIN_RADIUS_MULTIPLIER = 0.7f;
    @Unique
    private static final float RADIUS_ADJUST_RATE = 0.0025f;
    @Unique
    private static final int LIFETIME_ADJUST_STEP = 1;
    @Unique
    private static final float MINUTES_PER_GAME_TICK = 8.3333335E-4f;
    @Unique
    private static final float MIN_MINUTES_FOR_ADJUSTMENT = 2.0f;
    @Unique
    private static final float MAX_MINUTES_FOR_ADJUSTMENT = 6.0f;
    @Unique
    private int projectatmosphere$initialExistsForTicks;
    @Unique
    private float projectatmosphere$radiusMultiplier = 1.0f;
    @Unique
    private float projectatmosphere$radiusMultiplierO = 1.0f;
    @Unique
    private int projectatmosphere$lifetimeAdjustment;
    @Unique
    private BlockPos projectatmosphere$biomeFocusPos;
    @Unique
    private float projectatmosphere$focusMinutes;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void projectatmosphere$init(ResourceLocation cloudTypeId, Vec2 movementDirection, float maxSpeed, float accelerationFactor, float posX, float posZ, float radius, float rotation, float stretchFactor, int existsForTicks, int growTicks, int orderWeight, CallbackInfo ci) {
        this.projectatmosphere$id = PROJECTATMOSPHERE$RANDOM.m_188502_();
        this.projectatmosphere$initialExistsForTicks = existsForTicks;
        this.projectatmosphere$initTornadoContainer(posX, posZ);
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void projectatmosphere$loadId(CompoundTag tag, CallbackInfo ci) {
        this.projectatmosphere$id = tag.m_128441_("projectatmosphere_id") ? tag.m_128451_("projectatmosphere_id") : PROJECTATMOSPHERE$RANDOM.m_188502_();
        this.projectatmosphere$initialExistsForTicks = tag.m_128441_("projectatmosphere_initial_exists_for_ticks") ? tag.m_128451_("projectatmosphere_initial_exists_for_ticks") : this.existsForTicks;
        this.projectatmosphere$lifetimeAdjustment = tag.m_128451_("projectatmosphere_lifetime_adjustment");
        this.projectatmosphere$radiusMultiplier = tag.m_128441_("projectatmosphere_radius_multiplier") ? tag.m_128457_("projectatmosphere_radius_multiplier") : 1.0f;
        this.projectatmosphere$readTornadoesFromTag(tag);
    }

    @Inject(method={"toTag"}, at={@At(value="RETURN")})
    private void projectatmosphere$saveId(CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        tag.m_128405_("projectatmosphere_id", this.projectatmosphere$id);
        tag.m_128405_("projectatmosphere_initial_exists_for_ticks", this.projectatmosphere$initialExistsForTicks);
        tag.m_128405_("projectatmosphere_lifetime_adjustment", this.projectatmosphere$lifetimeAdjustment);
        tag.m_128350_("projectatmosphere_radius_multiplier", this.projectatmosphere$radiusMultiplier);
        this.projectatmosphere$writeTornadoesToTag(tag);
    }

    @Override
    public int projectatmosphere$getId() {
        return this.projectatmosphere$id;
    }

    @Override
    public List<TornadoDescriptor> getTornadoes() {
        return this.projectatmosphere$tornadoes;
    }

    @Override
    public void setTornadoes(List<TornadoDescriptor> descriptors) {
        this.projectatmosphere$tornadoes = descriptors == null ? new ArrayList<TornadoDescriptor>() : descriptors;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void projectatmosphere$applyBiomeGrowth(RandomSource random, Level level, boolean isVisible, float speed, CallbackInfo ci) {
        if (level == null || !isVisible) {
            return;
        }
        this.projectatmosphere$applyBiomeDynamics(level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void projectatmosphere$cachePrevPositions(RandomSource random, Level level, boolean isVisible, float speed, CallbackInfo ci) {
        this.projectatmosphere$prevTickX = this.posX;
        this.projectatmosphere$prevTickZ = this.posZ;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, cancellable=false)
    private void projectatmosphere$advanceTornadoes(RandomSource random, Level level, boolean isVisible, float speed, CallbackInfo ci) {
        float deltaX = this.posX - this.projectatmosphere$prevTickX;
        float deltaZ = this.posZ - this.projectatmosphere$prevTickZ;
        for (TornadoDescriptor descriptor : this.projectatmosphere$tornadoes) {
            descriptor.tick(deltaX, deltaZ);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")})
    private void projectatmosphere$readTornadoesFromPacket(FriendlyByteBuf buf, CallbackInfo ci) {
        this.projectatmosphere$tornadoes = this.projectatmosphere$readTornadoes(buf);
        this.projectatmosphere$initTornadoContainer(this.posX, this.posZ);
    }

    @Inject(method={"toPacket(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="TAIL")})
    private void projectatmosphere$writeTornadoesToPacket(FriendlyByteBuf buf, CallbackInfo ci) {
        this.projectatmosphere$writeTornadoes(buf);
    }

    @Inject(method={"setRadius"}, at={@At(value="TAIL")})
    private void projectatmosphere$resetMultiplier(float radius, CallbackInfo ci) {
        this.projectatmosphere$radiusMultiplier = 1.0f;
        this.projectatmosphere$radiusMultiplierO = 1.0f;
    }

    @Unique
    private void projectatmosphere$applyBiomeDynamics(Level level) {
        boolean isArid;
        BlockPos pos = BlockPos.m_274561_((double)this.getWorldX(), (double)level.m_5736_(), (double)this.getWorldZ());
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        float humidity = biome.getModifiedClimateSettings().f_47683_();
        float temperature = Mth.m_14036_((float)(biome.m_47554_() * 50.0f), (float)-20.0f, (float)50.0f);
        if (!this.projectatmosphere$hasAccumulatedBiomeMinutes(pos, humidity)) {
            return;
        }
        boolean isHumid = humidity > 0.75f && temperature >= 0.0f && temperature <= 35.0f;
        boolean bl = isArid = humidity < 0.25f || temperature > 35.0f;
        if (isHumid) {
            this.projectatmosphere$radiusMultiplier = Mth.m_14036_((float)(this.projectatmosphere$radiusMultiplier + 0.0025f), (float)0.7f, (float)1.3f);
            this.projectatmosphere$adjustLifetime(1);
        } else if (isArid) {
            this.projectatmosphere$radiusMultiplier = Mth.m_14036_((float)(this.projectatmosphere$radiusMultiplier - 0.0025f), (float)0.7f, (float)1.3f);
            this.projectatmosphere$adjustLifetime(-1);
        } else {
            this.projectatmosphere$radiusMultiplier = CloudRegionMixin.projectatmosphere$approach(this.projectatmosphere$radiusMultiplier, 1.0f, 0.0025f);
            this.projectatmosphere$relaxLifetime();
        }
        this.projectatmosphere$applyLifetimeBounds();
        this.radiusO = this.radius;
        this.radius *= this.projectatmosphere$radiusMultiplier;
    }

    @Unique
    private boolean projectatmosphere$hasAccumulatedBiomeMinutes(BlockPos pos, float humidity) {
        if (this.projectatmosphere$biomeFocusPos == null || !this.projectatmosphere$biomeFocusPos.equals((Object)pos)) {
            this.projectatmosphere$biomeFocusPos = pos;
            this.projectatmosphere$focusMinutes = 0.0f;
            return false;
        }
        this.projectatmosphere$focusMinutes += 8.3333335E-4f;
        float requiredMinutes = this.projectatmosphere$getMinutesForHumidity(humidity);
        if (this.projectatmosphere$focusMinutes < requiredMinutes) {
            return false;
        }
        this.projectatmosphere$focusMinutes -= requiredMinutes;
        return true;
    }

    @Unique
    private float projectatmosphere$getMinutesForHumidity(float humidity) {
        float humidityFactor = Mth.m_14036_((float)humidity, (float)0.0f, (float)1.0f);
        float inverted = 1.0f - humidityFactor;
        return 2.0f + inverted * 4.0f;
    }

    @Unique
    private void projectatmosphere$adjustLifetime(int delta) {
        int limit = this.projectatmosphere$getLifetimeLimit();
        this.projectatmosphere$lifetimeAdjustment = Mth.m_14045_((int)(this.projectatmosphere$lifetimeAdjustment + delta), (int)(-limit), (int)limit);
    }

    @Unique
    private void projectatmosphere$relaxLifetime() {
        if (this.projectatmosphere$lifetimeAdjustment > 0) {
            this.projectatmosphere$lifetimeAdjustment = Math.max(0, this.projectatmosphere$lifetimeAdjustment - 1);
        } else if (this.projectatmosphere$lifetimeAdjustment < 0) {
            this.projectatmosphere$lifetimeAdjustment = Math.min(0, this.projectatmosphere$lifetimeAdjustment + 1);
        }
    }

    @Unique
    private void projectatmosphere$applyLifetimeBounds() {
        int limit = this.projectatmosphere$getLifetimeLimit();
        this.projectatmosphere$lifetimeAdjustment = Mth.m_14045_((int)this.projectatmosphere$lifetimeAdjustment, (int)(-limit), (int)limit);
        int adjusted = this.projectatmosphere$initialExistsForTicks + this.projectatmosphere$lifetimeAdjustment;
        this.existsForTicks = Math.max(this.growTicks + 1, Math.max(1, adjusted));
    }

    @Unique
    private int projectatmosphere$getLifetimeLimit() {
        return Math.max(20, (int)((float)this.projectatmosphere$initialExistsForTicks * 0.3f));
    }

    @Unique
    private static float projectatmosphere$approach(float current, float target, float step) {
        if (current < target) {
            return Math.min(target, current + step);
        }
        if (current > target) {
            return Math.max(target, current - step);
        }
        return current;
    }

    @Unique
    private List<TornadoDescriptor> projectatmosphere$readTornadoes(FriendlyByteBuf buf) {
        int count = buf.m_130242_();
        ArrayList<TornadoDescriptor> descriptors = new ArrayList<TornadoDescriptor>(count);
        for (int i = 0; i < count; ++i) {
            descriptors.add(TornadoDescriptor.read(buf));
        }
        return descriptors;
    }

    @Unique
    private void projectatmosphere$writeTornadoes(FriendlyByteBuf buf) {
        buf.m_130130_(this.projectatmosphere$tornadoes.size());
        for (TornadoDescriptor descriptor : this.projectatmosphere$tornadoes) {
            descriptor.write(buf);
        }
    }

    @Unique
    private void projectatmosphere$writeTornadoesToTag(CompoundTag tag) {
        ListTag listTag = new ListTag();
        for (TornadoDescriptor descriptor : this.projectatmosphere$tornadoes) {
            listTag.add((Object)descriptor.toTag());
        }
        tag.m_128365_("projectatmosphere_tornadoes", (Tag)listTag);
    }

    @Unique
    private void projectatmosphere$readTornadoesFromTag(CompoundTag tag) {
        this.projectatmosphere$tornadoes = new ArrayList<TornadoDescriptor>();
        if (tag.m_128425_("projectatmosphere_tornadoes", 9)) {
            ListTag listTag = tag.m_128437_("projectatmosphere_tornadoes", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                this.projectatmosphere$tornadoes.add(TornadoDescriptor.fromTag(listTag.m_128728_(i)));
            }
        }
        this.projectatmosphere$initTornadoContainer(this.posX, this.posZ);
    }

    @Unique
    private void projectatmosphere$initTornadoContainer(float posX, float posZ) {
        if (this.projectatmosphere$tornadoes == null) {
            this.projectatmosphere$tornadoes = new ArrayList<TornadoDescriptor>();
        }
        this.projectatmosphere$prevTickX = posX;
        this.projectatmosphere$prevTickZ = posZ;
    }

    @Shadow
    public abstract float getWorldX();

    @Shadow
    public abstract float getWorldZ();
}

