/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.mixin;

import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class PAMixinPlugin
implements IMixinConfigPlugin {
    private static Boolean SANDSTORMLOADED = null;
    private static Boolean AURORASLOADED = null;
    private static Boolean RAINBOWSLOADED = null;

    private boolean isSandStormLoaded() {
        if (SANDSTORMLOADED != null) {
            return SANDSTORMLOADED;
        }
        try {
            Class.forName("com.BreadRes.desertstormwarming.BurymodMain", false, this.getClass().getClassLoader());
            SANDSTORMLOADED = true;
        }
        catch (ClassNotFoundException e) {
            SANDSTORMLOADED = false;
        }
        System.out.println("[Project Atmosphere] SandStorms detected: " + SANDSTORMLOADED);
        return SANDSTORMLOADED;
    }

    private boolean isAurorasLoaded() {
        if (AURORASLOADED != null) {
            return AURORASLOADED;
        }
        AURORASLOADED = this.isClassPresent("auroras.Auroras");
        System.out.println("[Project Atmosphere] Auroras detected: " + AURORASLOADED);
        return AURORASLOADED;
    }

    private boolean isRainbowsLoaded() {
        if (RAINBOWSLOADED != null) {
            return RAINBOWSLOADED;
        }
        RAINBOWSLOADED = this.isClassPresent("rainbows.Rainbows");
        System.out.println("[Project Atmosphere] Rainbows detected: " + RAINBOWSLOADED);
        return RAINBOWSLOADED;
    }

    private boolean isClassPresent(String className) {
        try {
            Class.forName(className, false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void onLoad(String s) {
    }

    public String getRefMapperConfig() {
        return "projectatmosphere.refmap.json";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.endsWith("OverwriteDesertSound") && !this.isSandStormLoaded()) {
            return false;
        }
        if (mixinClassName.endsWith("MixinSandstormDebugBlocker") && !this.isSandStormLoaded()) {
            return false;
        }
        if (mixinClassName.contains("compat.auroras") && !this.isAurorasLoaded()) {
            return false;
        }
        return !mixinClassName.contains("compat.rainbows") || this.isRainbowsLoaded();
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }
}

