/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.mixin;

import net.Gabou.projectatmosphere.client.BiomeClientTemperatureCache;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sereneseasons.season.SeasonHooks;

@Mixin(value={SeasonHooks.class}, remap=false)
public class SeasonHooksMixin {
    @Inject(method={"warmEnoughToRainSeasonal(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void redirectTemperatureToAtmosphere(LevelReader level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.m_46472_() != Level.f_46428_) {
                return;
            }
            BiomeInstanceKey key = new BiomeInstanceKey(((ResourceKey)serverLevel.m_204166_(pos).m_203543_().orElseThrow()).m_135782_(), pos);
            float temperature = ForecastOrchestrator.getCurrentTemperature(key, serverLevel.m_46468_());
            if (temperature < 0.0f) {
                cir.setReturnValue((Object)false);
                cir.cancel();
            }
        } else if (level.getClass().getName().equals("net.minecraft.client.multiplayer.ClientLevel")) {
            try {
                ResourceKey biomeKey = level.m_204166_(pos).m_203543_().orElse(null);
                if (biomeKey != null) {
                    boolean freezing = BiomeClientTemperatureCache.isFreezing(biomeKey.m_135782_(), null);
                    cir.setReturnValue((Object)(!freezing ? 1 : 0));
                    cir.cancel();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

