/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.atmosphere;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.core.ForecastRegion;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Unmodifiable;

public final class AtmosphericStateRegistry {
    private static final Map<RegionInstanceKey, RegionAtmosphereState> STATES = new ConcurrentHashMap<RegionInstanceKey, RegionAtmosphereState>();
    private static final Map<RegionInstanceKey, List<RegionInstanceKey>> NEIGHBORS = new ConcurrentHashMap<RegionInstanceKey, List<RegionInstanceKey>>();
    private static final Map<BiomeInstanceKey, RegionInstanceKey> LEGACY_INDEX = new ConcurrentHashMap<BiomeInstanceKey, RegionInstanceKey>();
    private static final Set<RegionInstanceKey> ACTIVE = ConcurrentHashMap.newKeySet();

    private AtmosphericStateRegistry() {
    }

    public static Set<RegionInstanceKey> getActiveStates() {
        return ACTIVE;
    }

    public static void rebuildActiveStates(ServerLevel level) {
        ACTIVE.clear();
        int radius = 1000;
        int r2 = radius * radius;
        for (ServerPlayer player : level.m_6907_()) {
            BlockPos p = player.m_20183_();
            for (RegionAtmosphereState state : STATES.values()) {
                double dz;
                double dx;
                BlockPos anchor = state.getPosition();
                if (anchor == null || !((dx = (double)(anchor.m_123341_() - p.m_123341_())) * dx + (dz = (double)(anchor.m_123343_() - p.m_123343_())) * dz <= (double)r2)) continue;
                ACTIVE.add(state.getRegionId());
            }
        }
    }

    public static void replaceActiveStates(Set<RegionInstanceKey> next) {
        ACTIVE.clear();
        if (next != null) {
            ACTIVE.addAll(next);
        }
    }

    public static RegionAtmosphereState initializeState(RegionInstanceKey id, ForecastRegion forecast) {
        forecast.finalizeAggregation();
        RegionAtmosphereState state = RegionAtmosphereState.fromForecast(id, forecast);
        STATES.put(id, state);
        AtmosphericStateRegistry.indexLegacyKeys(forecast);
        return state;
    }

    public static RegionAtmosphereState initializeState(BiomeInstanceKey key, ForecastRegion forecast) {
        RegionInstanceKey regionId = forecast.getKey();
        AtmosphericStateRegistry.indexLegacyKeys(forecast);
        return AtmosphericStateRegistry.initializeState(regionId, forecast);
    }

    private static void indexLegacyKeys(ForecastRegion region) {
        RegionInstanceKey regionId = region.getKey();
        for (BiomeInstanceKey sample : region.getSamples()) {
            if (sample == null) continue;
            LEGACY_INDEX.put(sample, regionId);
        }
    }

    public static RegionAtmosphereState getState(RegionInstanceKey key) {
        if (key == null) {
            return null;
        }
        return STATES.get(key);
    }

    public static RegionAtmosphereState getState(BiomeInstanceKey biomeKey) {
        RegionInstanceKey key = AtmosphericStateRegistry.resolveRegionKey(biomeKey);
        if (key == null) {
            return null;
        }
        return STATES.get(key);
    }

    public static Collection<RegionAtmosphereState> getStates() {
        return STATES.values();
    }

    public static Map<RegionInstanceKey, RegionAtmosphereState> getStatesAsMap() {
        return STATES;
    }

    public static Map<RegionInstanceKey, List<RegionInstanceKey>> getNeighborsAsMap() {
        return NEIGHBORS;
    }

    public static Map<BiomeInstanceKey, RegionAtmosphereState> getLegacyBiomeStateIndex() {
        HashMap<BiomeInstanceKey, RegionAtmosphereState> map = new HashMap<BiomeInstanceKey, RegionAtmosphereState>(LEGACY_INDEX.size());
        LEGACY_INDEX.forEach((biomeKey, regionKey) -> {
            RegionAtmosphereState state = STATES.get(regionKey);
            if (state != null) {
                map.put((BiomeInstanceKey)biomeKey, state);
            }
        });
        return map;
    }

    public static boolean isEmpty() {
        return STATES.isEmpty();
    }

    public static void clear() {
        STATES.clear();
        NEIGHBORS.clear();
        LEGACY_INDEX.clear();
        ACTIVE.clear();
    }

    public static void rebuildNeighbors() {
        HashMap rebuilt = new HashMap(STATES.size());
        for (RegionInstanceKey key : STATES.keySet()) {
            ArrayList<RegionInstanceKey> neighbors = new ArrayList<RegionInstanceKey>(8);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    RegionInstanceKey neighbor;
                    if (dx == 0 && dz == 0 || !STATES.containsKey(neighbor = new RegionInstanceKey(key.regionX() + dx, key.regionZ() + dz, key.regionSize()))) continue;
                    neighbors.add(neighbor);
                }
            }
            if (neighbors.isEmpty()) continue;
            rebuilt.put(key, List.copyOf(neighbors));
        }
        NEIGHBORS.clear();
        NEIGHBORS.putAll(rebuilt);
    }

    public static List<RegionInstanceKey> getNeighbors(RegionInstanceKey key) {
        return NEIGHBORS.getOrDefault(key, List.of());
    }

    public static List<BiomeInstanceKey> getBiomeNeighbors(BiomeInstanceKey biomeKey) {
        RegionInstanceKey regionKey = AtmosphericStateRegistry.resolveRegionKey(biomeKey);
        if (regionKey == null) {
            return List.of();
        }
        List<RegionInstanceKey> regionNeighbors = AtmosphericStateRegistry.getNeighbors(regionKey);
        if (regionNeighbors.isEmpty()) {
            return List.of();
        }
        ArrayList<BiomeInstanceKey> result = new ArrayList<BiomeInstanceKey>();
        LEGACY_INDEX.forEach((legacyKey, region) -> {
            if (regionNeighbors.contains(region)) {
                result.add((BiomeInstanceKey)legacyKey);
            }
        });
        return result;
    }

    public static Optional<RegionAtmosphereState> getRandomState(RandomSource random) {
        if (STATES.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<RegionAtmosphereState> list = new ArrayList<RegionAtmosphereState>(STATES.values());
        return Optional.of((RegionAtmosphereState)list.get(random.m_188503_(list.size())));
    }

    public static Set<BiomeInstanceKey> getActiveBiomeKeys() {
        HashSet<BiomeInstanceKey> activeBiomes = new HashSet<BiomeInstanceKey>();
        LEGACY_INDEX.forEach((biomeKey, regionKey) -> {
            if (ACTIVE.contains(regionKey)) {
                activeBiomes.add((BiomeInstanceKey)biomeKey);
            }
        });
        return activeBiomes;
    }

    public static RegionAtmosphereState findNearest(double x, double z) {
        RegionAtmosphereState nearest = null;
        double best = Double.MAX_VALUE;
        for (RegionAtmosphereState state : STATES.values()) {
            double dist = state.distanceTo(x, z);
            if (!(dist < best)) continue;
            best = dist;
            nearest = state;
        }
        return nearest;
    }

    public static @Unmodifiable List<RegionAtmosphereState> snapshot() {
        return Collections.unmodifiableList(new ArrayList<RegionAtmosphereState>(STATES.values()));
    }

    public static RegionInstanceKey resolveRegionKey(BiomeInstanceKey biomeKey) {
        if (biomeKey == null) {
            return null;
        }
        RegionInstanceKey mapped = LEGACY_INDEX.get(biomeKey);
        if (mapped != null) {
            return mapped;
        }
        if (biomeKey.samplePos() == null) {
            return null;
        }
        return RegionInstanceKey.from(biomeKey.samplePos());
    }
}

