/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.atmosphere;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.Gabou.projectatmosphere.async.PoolType;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;

public final class AtmosphericUpdateScheduler {
    private static final int ACTIVE_INTERVAL_TICKS = 20;
    private static final int PASSIVE_INTERVAL_TICKS = 100;
    private static final int PASSIVE_BATCH_SIZE = 1000;
    private static final float COOLING_SCALE = 3.0f;
    private static final float HUMIDITY_DRAIN = 0.2f;
    private static final float PRESSURE_RESTORE = 1.5f;
    private static final float RAIN_FADE = 0.01f;
    private static final AtomicBoolean ACTIVE_IN_FLIGHT = new AtomicBoolean();
    private static final AtomicBoolean PASSIVE_IN_FLIGHT = new AtomicBoolean();
    private static final ArrayDeque<RegionInstanceKey> PASSIVE_QUEUE = new ArrayDeque();
    private static long lastActiveTick = -20L;
    private static long lastPassiveTick = 0L;

    private AtmosphericUpdateScheduler() {
    }

    public static void tick(ServerLevel level) {
        long now = level.m_46467_();
        if (now - lastActiveTick >= 20L) {
            lastActiveTick = now;
            AtmosphericUpdateScheduler.rebuildActiveAsync(level, active -> AtmosphericUpdateScheduler.scheduleActive(level, active));
        }
        if (now - lastPassiveTick >= 100L) {
            lastPassiveTick = now;
            AtmosphericUpdateScheduler.schedulePassive(level);
        }
    }

    private static void scheduleActive(ServerLevel level, Set<RegionInstanceKey> activeKeys) {
        if (!ACTIVE_IN_FLIGHT.compareAndSet(false, true)) {
            return;
        }
        if (activeKeys.isEmpty()) {
            ACTIVE_IN_FLIGHT.set(false);
            return;
        }
        List<StateView> snapshot = AtmosphericUpdateScheduler.snapshotStates(activeKeys);
        if (snapshot.isEmpty()) {
            ACTIVE_IN_FLIGHT.set(false);
            return;
        }
        float daylight = AtmosphericUpdateScheduler.baseDaylightCurve(level.m_46490_(1.0f));
        float seasonal = AtmosphericUpdateScheduler.seasonalTilt(level);
        long dayTime = level.m_46468_();
        AsyncAtmosphereService.runWithCallback(PoolType.WEATHER, () -> AtmosphericUpdateScheduler.computeDeltas(snapshot, daylight, seasonal, UpdateMode.ACTIVE), deltas -> {
            try {
                AtmosphericUpdateScheduler.applyDeltas(deltas, dayTime, UpdateMode.ACTIVE);
            }
            finally {
                ACTIVE_IN_FLIGHT.set(false);
            }
        });
    }

    private static void rebuildActiveAsync(ServerLevel level, Consumer<Set<RegionInstanceKey>> consumer) {
        ArrayList<BlockPos> players = new ArrayList<BlockPos>();
        for (ServerPlayer player : level.m_6907_()) {
            players.add(player.m_20183_());
        }
        Map<RegionInstanceKey, RegionAtmosphereState> states = AtmosphericStateRegistry.getStatesAsMap();
        AsyncAtmosphereService.runWithCallback(PoolType.WEATHER, () -> AtmosphericUpdateScheduler.computeActiveStates(players, states.keySet()), active -> {
            AtmosphericStateRegistry.replaceActiveStates(active);
            if (consumer != null) {
                consumer.accept(new HashSet(active));
            }
        });
    }

    private static Set<RegionInstanceKey> computeActiveStates(List<BlockPos> players, Set<RegionInstanceKey> keys) {
        if (players.isEmpty() || keys.isEmpty()) {
            return Set.of();
        }
        int radius = 1000;
        int r2 = radius * radius;
        HashSet<RegionInstanceKey> active = new HashSet<RegionInstanceKey>();
        Map<RegionInstanceKey, RegionAtmosphereState> states = AtmosphericStateRegistry.getStatesAsMap();
        block0: for (RegionInstanceKey key : keys) {
            RegionAtmosphereState state = states.get(key);
            if (state == null || state.getPosition() == null) continue;
            BlockPos sample = state.getPosition();
            for (BlockPos playerPos : players) {
                double dz;
                double dx = sample.m_123341_() - playerPos.m_123341_();
                if (!(dx * dx + (dz = (double)(sample.m_123343_() - playerPos.m_123343_())) * dz <= (double)r2)) continue;
                active.add(key);
                continue block0;
            }
        }
        return active;
    }

    private static void schedulePassive(ServerLevel level) {
        if (!PASSIVE_IN_FLIGHT.compareAndSet(false, true)) {
            return;
        }
        HashSet<RegionInstanceKey> activeKeys = new HashSet<RegionInstanceKey>(AtmosphericStateRegistry.getActiveStates());
        AtmosphericUpdateScheduler.refillQueue(activeKeys);
        List<RegionInstanceKey> batchKeys = AtmosphericUpdateScheduler.pollBatch(activeKeys);
        if (batchKeys.isEmpty()) {
            PASSIVE_IN_FLIGHT.set(false);
            return;
        }
        List<StateView> snapshot = AtmosphericUpdateScheduler.snapshotStates(batchKeys);
        if (snapshot.isEmpty()) {
            PASSIVE_IN_FLIGHT.set(false);
            return;
        }
        float daylight = AtmosphericUpdateScheduler.baseDaylightCurve(level.m_46490_(1.0f));
        float seasonal = AtmosphericUpdateScheduler.seasonalTilt(level);
        long dayTime = level.m_46468_();
        AsyncAtmosphereService.runWithCallback(PoolType.WEATHER, () -> AtmosphericUpdateScheduler.computeDeltas(snapshot, daylight, seasonal, UpdateMode.PASSIVE), deltas -> {
            try {
                AtmosphericUpdateScheduler.applyDeltas(deltas, dayTime, UpdateMode.PASSIVE);
            }
            finally {
                PASSIVE_IN_FLIGHT.set(false);
            }
        });
    }

    private static void refillQueue(Set<RegionInstanceKey> activeKeys) {
        if (!PASSIVE_QUEUE.isEmpty()) {
            return;
        }
        Map<RegionInstanceKey, RegionAtmosphereState> states = AtmosphericStateRegistry.getStatesAsMap();
        for (RegionInstanceKey key : states.keySet()) {
            if (key == null || activeKeys.contains(key)) continue;
            PASSIVE_QUEUE.addLast(key);
        }
    }

    private static List<RegionInstanceKey> pollBatch(Set<RegionInstanceKey> activeKeys) {
        ArrayList<RegionInstanceKey> batch = new ArrayList<RegionInstanceKey>(1000);
        while (!PASSIVE_QUEUE.isEmpty() && batch.size() < 1000) {
            RegionInstanceKey key = PASSIVE_QUEUE.pollFirst();
            if (key == null || activeKeys.contains(key)) continue;
            batch.add(key);
        }
        return batch;
    }

    private static List<StateView> snapshotStates(Collection<RegionInstanceKey> keys) {
        Map<RegionInstanceKey, RegionAtmosphereState> states = AtmosphericStateRegistry.getStatesAsMap();
        ArrayList<StateView> views = new ArrayList<StateView>(keys.size());
        for (RegionInstanceKey key : keys) {
            RegionAtmosphereState state = states.get(key);
            if (state == null || state.getPosition() == null) continue;
            views.add(new StateView(key, state.getTemperature(), state.getHumidity(), state.getPressure(), state.getCloudCover(), state.getSunlight(), state.getRainIntensity(), state.getBiomeSunlightMultiplier(), state.getBaselineMinTemperature(), state.getBaselineMaxTemperature()));
        }
        return views;
    }

    private static List<StateDelta> computeDeltas(List<StateView> snapshot, float daylight, float seasonal, UpdateMode mode) {
        ArrayList<StateDelta> deltas = new ArrayList<StateDelta>(snapshot.size());
        for (StateView view : snapshot) {
            float sunlightFactor = daylight * seasonal * view.sunlightMultiplier();
            sunlightFactor *= Math.max(0.0f, 1.0f - view.cloudCover());
            sunlightFactor = Mth.m_14036_((float)sunlightFactor, (float)0.0f, (float)1.0f);
            float baselineSpan = Math.max(0.001f, view.baselineMax() - view.baselineMin());
            float baseTarget = Mth.m_14179_((float)sunlightFactor, (float)view.baselineMin(), (float)view.baselineMax());
            float rainPenalty = view.rainIntensity() * baselineSpan * 0.15f;
            float adjustedTarget = baseTarget - rainPenalty;
            float blendedTarget = Mth.m_14179_((float)mode.blend(), (float)view.temperature(), (float)adjustedTarget);
            float sunlightTemperatureDelta = (blendedTarget - view.temperature()) * mode.scale();
            float clampedRain = Math.min(1.0f, view.rainIntensity());
            float rainTemperatureDelta = -clampedRain * 3.0f * mode.scale();
            float rainHumidityDelta = -clampedRain * 0.2f * mode.scale();
            float rainPressureDelta = clampedRain * 1.5f * mode.scale();
            float humidityDelta = (view.rainIntensity() * 0.02f - sunlightFactor * 0.01f) * mode.scale();
            humidityDelta += rainHumidityDelta;
            float temperatureDelta = AtmosphericUpdateScheduler.clampDelta(sunlightTemperatureDelta + rainTemperatureDelta, -20.0f, 20.0f);
            humidityDelta = AtmosphericUpdateScheduler.clampDelta(humidityDelta, -0.35f, 0.35f);
            float pressureDelta = AtmosphericUpdateScheduler.clampDelta(rainPressureDelta, -15.0f, 15.0f);
            float rainFade = 0.01f * mode.rainFadeScale();
            deltas.add(new StateDelta(view.key(), temperatureDelta, humidityDelta, pressureDelta, sunlightFactor, rainFade, mode.relaxFactor()));
        }
        return deltas;
    }

    private static void applyDeltas(List<StateDelta> deltas, long dayTime, UpdateMode mode) {
        for (StateDelta delta : deltas) {
            RegionAtmosphereState state = AtmosphericStateRegistry.getState(delta.key());
            if (state == null) continue;
            state.setSunlight(delta.sunlight());
            state.adjustTemperature(delta.temperatureDelta());
            state.adjustHumidity(delta.humidityDelta());
            state.adjustPressure(delta.pressureDelta());
            if (delta.rainFade() > 0.0f) {
                state.dampenRain(delta.rainFade());
            }
            if (delta.relaxFactor() > 0.0f) {
                state.relaxTowardBase(delta.relaxFactor());
            }
            if (mode != UpdateMode.ACTIVE) continue;
            state.recordDailySnapshot(dayTime);
        }
    }

    private static float baseDaylightCurve(float sunAngle) {
        float cosine = (float)Math.cos(sunAngle);
        float daylight = Mth.m_14036_((float)cosine, (float)0.0f, (float)1.0f);
        return daylight * daylight;
    }

    private static float seasonalTilt(ServerLevel level) {
        long day = level.m_46468_() / 24000L;
        float seasonProgress = (float)(day % 96L) / 96.0f;
        return 0.85f + 0.15f * Mth.m_14089_((float)(seasonProgress * ((float)Math.PI * 2)));
    }

    private static float clampDelta(float value, float min, float max) {
        return Mth.m_14036_((float)value, (float)min, (float)max);
    }

    private record StateView(RegionInstanceKey key, float temperature, float humidity, float pressure, float cloudCover, float sunlight, float rainIntensity, float sunlightMultiplier, float baselineMin, float baselineMax) {
    }

    private static enum UpdateMode {
        ACTIVE(1.0f, 5.0E-4f, 0.6f, 1.0f),
        PASSIVE(0.35f, 2.0E-4f, 0.45f, 0.5f);

        private final float scale;
        private final float relaxFactor;
        private final float blend;
        private final float rainFadeScale;

        private UpdateMode(float scale, float relaxFactor, float blend, float rainFadeScale) {
            this.scale = scale;
            this.relaxFactor = relaxFactor;
            this.blend = blend;
            this.rainFadeScale = rainFadeScale;
        }

        float scale() {
            return this.scale;
        }

        float relaxFactor() {
            return this.relaxFactor;
        }

        float blend() {
            return this.blend;
        }

        float rainFadeScale() {
            return this.rainFadeScale;
        }
    }

    private record StateDelta(RegionInstanceKey key, float temperatureDelta, float humidityDelta, float pressureDelta, float sunlight, float rainFade, float relaxFactor) {
    }
}

