/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.atmosphere;

import dev.nonamecrackers2.simpleclouds.api.common.cloud.spawning.SpawnInfo;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudGenerator;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudSpawningConfig;
import dev.nonamecrackers2.simpleclouds.common.world.SpawnRegion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.async.PoolType;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.manager.SimpleCloudSpawner;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.ICloudRegionId;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.Gabou.projectatmosphere.util.WeatherSampler;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.world.entity.Entity;
import org.joml.Vector2i;

public final class CloudManager {
    private static final Map<Integer, RegionCloudData> REGION_DATA = new ConcurrentHashMap<Integer, RegionCloudData>();
    private static final Set<RegionInstanceKey> ACTIVE_REGIONS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final AtomicBoolean REGION_SCAN_IN_FLIGHT = new AtomicBoolean();
    private static final AtomicBoolean SPAWN_SCAN_IN_FLIGHT = new AtomicBoolean();
    private static final int REGION_SAMPLE_INTERVAL_TICKS = 40;
    private static final int SPAWN_ATTEMPT_INTERVAL_TICKS = 200;
    private static final int MAX_SPAWN_SCAN_ATTEMPTS = 6;
    private static final float HUMIDITY_MIN_FOR_THICKNESS = 0.35f;
    private static final float HUMIDITY_MAX_FOR_THICKNESS = 0.85f;
    private static final float RAIN_BIRTH_THRESHOLD = 0.55f;
    private static final float THICKNESS_GROWTH_RATE = 0.25f;
    private static final float THICKNESS_DECAY_RATE = 0.08f;
    private static final float RAIN_GROW_RATE = 0.04f;
    private static final float RAIN_DECAY_RATE = 0.02f;
    private static final float REGION_GROWTH_RATE = 0.0125f;
    private static final float REGION_SHRINK_RATE = 0.02f;
    private static final float PASSIVE_CLOUD_DECAY = 0.03f;
    private static final float PASSIVE_RAIN_DECAY = 0.02f;
    private static final float IDEAL_TEMPERATURE_C = 18.0f;
    private static final float TEMPERATURE_RANGE = 28.0f;
    private static final float HUMIDITY_SPAWN_THRESHOLD_PERCENT = 82.0f;
    private static final RandomSource SPAWN_RANDOM = RandomSource.m_216327_();
    private static long lastRegionSampleTick = 0L;
    private static long lastSpawnTick = 0L;

    private CloudManager() {
    }

    public static void initialize(ServerLevel level) {
        REGION_DATA.clear();
        ACTIVE_REGIONS.clear();
        lastRegionSampleTick = 0L;
        lastSpawnTick = 0L;
        REGION_SCAN_IN_FLIGHT.set(false);
        SPAWN_SCAN_IN_FLIGHT.set(false);
    }

    public static void update(ServerLevel level) {
        if (!SimpleCloudsCompat.getIsInit()) {
            CloudManager.fadeInactiveRegions(Collections.emptySet());
            return;
        }
        CloudGenerator generator = SimpleCloudsCompat.generator;
        if (generator == null) {
            CloudManager.fadeInactiveRegions(Collections.emptySet());
            return;
        }
        long tick = level.m_46467_();
        if (tick - lastRegionSampleTick >= 40L) {
            lastRegionSampleTick = tick;
            if (generator.getClouds().isEmpty()) {
                REGION_DATA.clear();
                CloudManager.applyBiomeContributions(Collections.emptyMap());
            } else {
                CloudManager.startRegionScan(level, generator);
            }
        }
        if (tick - lastSpawnTick >= 200L) {
            lastSpawnTick = tick;
            CloudManager.scheduleSpawnAttempt(level, generator);
        }
    }

    private static void startRegionScan(ServerLevel level, CloudGenerator generator) {
        if (!REGION_SCAN_IN_FLIGHT.compareAndSet(false, true)) {
            return;
        }
        List<RegionDescriptor> descriptors = CloudManager.snapshotRegions(generator);
        if (descriptors.isEmpty()) {
            REGION_SCAN_IN_FLIGHT.set(false);
            CloudManager.applyBiomeContributions(Collections.emptyMap());
            return;
        }
        List<BlockPos> players = level.m_6907_().stream().map(Entity::m_20183_).toList();
        if (players.isEmpty()) {
            REGION_SCAN_IN_FLIGHT.set(false);
            return;
        }
        AsyncAtmosphereService.runWithCallback(PoolType.WEATHER, () -> CloudManager.computeSamples(descriptors, players), samples -> {
            try {
                CloudManager.applySamples(level, samples);
            }
            finally {
                REGION_SCAN_IN_FLIGHT.set(false);
            }
        });
    }

    private static List<RegionDescriptor> snapshotRegions(CloudGenerator generator) {
        List clouds = generator.getClouds();
        ArrayList<RegionDescriptor> descriptors = new ArrayList<RegionDescriptor>(clouds.size());
        for (CloudRegion region : clouds) {
            if (region == null) continue;
            int id = CloudManager.extractId(region);
            descriptors.add(new RegionDescriptor(id, region.getCloudTypeId(), region.getWorldX(), region.getWorldZ(), region.getRadius()));
        }
        return descriptors;
    }

    private static List<RegionSample> computeSamples(List<RegionDescriptor> descriptors, List<BlockPos> players) {
        List<RegionAtmosphereState> states = AtmosphericStateRegistry.snapshot();
        ArrayList<RegionSample> samples = new ArrayList<RegionSample>(descriptors.size());
        for (RegionDescriptor descriptor : descriptors) {
            boolean nearAnyPlayer = false;
            for (BlockPos p : players) {
                double dz;
                double dx = descriptor.worldX() - (double)p.m_123341_();
                if (!(dx * dx + (dz = descriptor.worldZ() - (double)p.m_123343_()) * dz <= 3.6E7)) continue;
                nearAnyPlayer = true;
                break;
            }
            if (!nearAnyPlayer) continue;
            samples.add(CloudManager.sampleRegion(descriptor, states));
        }
        return samples;
    }

    private static RegionSample sampleRegion(RegionDescriptor descriptor, List<RegionAtmosphereState> states) {
        double regionRadius = 2000.0;
        double radius = Math.max(16.0, (double)descriptor.radius());
        double radiusSq = radius * radius;
        double regionRadiusSq = regionRadius * regionRadius;
        double centerX = descriptor.worldX();
        double centerZ = descriptor.worldZ();
        float humiditySum = 0.0f;
        float temperatureSum = 0.0f;
        float pressureSum = 0.0f;
        float rainSum = 0.0f;
        float weightSum = 0.0f;
        ArrayList<RegionSample.Footprint> footprint = new ArrayList<RegionSample.Footprint>();
        for (RegionAtmosphereState state : states) {
            BlockPos anchor = state.getPosition();
            if (anchor == null) continue;
            double dx = (double)anchor.m_123341_() - centerX;
            double dz = (double)anchor.m_123343_() - centerZ;
            double dist = Math.sqrt(dx * dx + dz * dz);
            if (Objects.equals(state.getRegionId(), new RegionInstanceKey(-2, -2))) {
                ProjectAtmosphere.LOGGER.info("CloudManager: Sampling region {}, distance to center: {}", (Object)state.getRegionId(), (Object)dist);
            }
            if (dist > radius + regionRadius) continue;
            float weight = 1.0f - (float)(dist * dist / regionRadiusSq);
            weight = Mth.m_14036_((float)weight, (float)0.05f, (float)1.0f);
            humiditySum += state.getHumidity() * weight;
            temperatureSum += state.getTemperature() * weight;
            pressureSum += state.getPressure() * weight;
            rainSum += state.getRainIntensity() * weight;
            weightSum += weight;
            footprint.add(new RegionSample.Footprint(state.getKey(), weight));
        }
        if (weightSum <= 0.0f) {
            return new RegionSample(descriptor.id(), descriptor.cloudType(), descriptor.worldX(), descriptor.worldZ(), descriptor.radius(), 0.0f, 0.0f, 0.0f, 1013.25f, 0.0f, 0.0f, List.of());
        }
        float humidityAvg = humiditySum / weightSum;
        float humidityPercent = humidityAvg * 100.0f;
        float temperatureAvg = temperatureSum / weightSum;
        float pressureAvg = pressureSum / weightSum;
        float rainAvg = rainSum / weightSum;
        float dewPoint = SimpleCloudSpawner.calculateDewPoint(temperatureAvg, humidityPercent);
        return new RegionSample(descriptor.id(), descriptor.cloudType(), descriptor.worldX(), descriptor.worldZ(), descriptor.radius(), humidityAvg, humidityPercent, temperatureAvg, pressureAvg, rainAvg, dewPoint, footprint);
    }

    private static void applySamples(ServerLevel level, List<RegionSample> samples) {
        CloudGenerator generator = SimpleCloudsCompat.generator;
        if (generator == null) {
            REGION_DATA.clear();
            CloudManager.fadeInactiveRegions(Collections.emptySet());
            return;
        }
        Map<Integer, CloudRegion> regionIndex = CloudManager.indexCloudRegions(generator);
        HashMap<RegionInstanceKey, BiomeContribution> contributions = new HashMap<RegionInstanceKey, BiomeContribution>();
        HashSet<Integer> observed = new HashSet<Integer>();
        for (RegionSample sample : samples) {
            CloudRegion region = regionIndex.get(sample.id());
            if (region == null) continue;
            observed.add(sample.id());
            RegionCloudData data = REGION_DATA.computeIfAbsent(sample.id(), ignored -> new RegionCloudData());
            data.updateFromSample(sample, region);
            for (RegionSample.Footprint footprint : sample.footprint()) {
                if (footprint.weight() <= 0.0f) continue;
                contributions.computeIfAbsent(footprint.key(), key -> new BiomeContribution()).add(footprint.weight(), data.getThickness(), data.getRainIntensity());
            }
        }
        CloudManager.pruneMissingRegions(observed);
        CloudManager.applyBiomeContributions(contributions);
    }

    private static Map<Integer, CloudRegion> indexCloudRegions(CloudGenerator generator) {
        HashMap<Integer, CloudRegion> index = new HashMap<Integer, CloudRegion>();
        for (CloudRegion region : generator.getClouds()) {
            if (region == null) continue;
            index.put(CloudManager.extractId(region), region);
        }
        return index;
    }

    private static void pruneMissingRegions(Set<Integer> observed) {
        if (observed.isEmpty()) {
            REGION_DATA.clear();
            return;
        }
        REGION_DATA.keySet().removeIf(id -> !observed.contains(id));
    }

    private static void applyBiomeContributions(Map<RegionInstanceKey, BiomeContribution> contributions) {
        if (contributions.isEmpty()) {
            CloudManager.fadeInactiveRegions(Collections.emptySet());
            return;
        }
        HashSet<RegionInstanceKey> touched = new HashSet<RegionInstanceKey>();
        contributions.forEach((key, value) -> {
            RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
            if (state == null) {
                return;
            }
            float cover = Mth.m_14036_((float)value.cloudCover, (float)0.0f, (float)1.0f);
            float rain = Mth.m_14036_((float)value.rainIntensity, (float)0.0f, (float)1.0f);
            state.setCloudCover(cover);
            state.setRainIntensity(rain);
            if (ProjectAtmosphere.DEBUG_MODE && key.regionX() == -2 && key.regionZ() == -2 && key.regionSize() == 2000) {
                ProjectAtmosphere.LOGGER.info("[CloudManager] Region {} cover={} rain={} (thicknessSum={}, contributions={})", key, (Object)Float.valueOf(cover), (Object)Float.valueOf(rain), (Object)Float.valueOf(value.cloudCover), (Object)Float.valueOf(value.rainIntensity));
            }
            touched.add((RegionInstanceKey)key);
            ACTIVE_REGIONS.add((RegionInstanceKey)key);
        });
        CloudManager.fadeInactiveRegions(touched);
    }

    private static void fadeInactiveRegions(Set<RegionInstanceKey> refreshed) {
        if (ACTIVE_REGIONS.isEmpty()) {
            return;
        }
        ArrayList<RegionInstanceKey> toRemove = new ArrayList<RegionInstanceKey>();
        for (RegionInstanceKey key : ACTIVE_REGIONS) {
            if (refreshed.contains(key)) continue;
            RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
            if (state == null) {
                toRemove.add(key);
                continue;
            }
            float newCover = Math.max(0.0f, state.getCloudCover() - 0.03f);
            float newRain = Math.max(0.0f, state.getRainIntensity() - 0.02f);
            state.setCloudCover(newCover);
            state.setRainIntensity(newRain);
            if (!(newCover <= 0.001f) || !(newRain <= 0.001f)) continue;
            toRemove.add(key);
        }
        toRemove.forEach(ACTIVE_REGIONS::remove);
    }

    private static void scheduleSpawnAttempt(ServerLevel level, CloudGenerator generator) {
        if (!SimpleCloudsCompat.getIsInit() || SPAWN_SCAN_IN_FLIGHT.get()) {
            return;
        }
        CloudSpawningConfig config = SimpleCloudsCompat.spawnConfig;
        if (config == null) {
            return;
        }
        int remaining = config.getMaxInitialRegions() - generator.getClouds().size();
        if (remaining <= 0) {
            return;
        }
        List regions = List.copyOf(generator.getSpawnRegions());
        if (regions.isEmpty()) {
            return;
        }
        if (!SPAWN_SCAN_IN_FLIGHT.compareAndSet(false, true)) {
            return;
        }
        AsyncAtmosphereService.runWithCallback(PoolType.WEATHER, () -> new SpawnSearchResult(CloudManager.findSpawnCandidate(level, generator.getClouds().size(), regions, config, remaining)), result -> {
            try {
                if (result.candidate() != null) {
                    CloudManager.spawnCandidate(level, generator, result.candidate());
                }
            }
            finally {
                SPAWN_SCAN_IN_FLIGHT.set(false);
            }
        });
    }

    private static SpawnCandidate findSpawnCandidate(ServerLevel level, int currentCloudRegions, List<SpawnRegion> regions, CloudSpawningConfig config, int remaining) {
        if (regions.isEmpty()) {
            return null;
        }
        List<BlockPos> players = level.m_6907_().stream().map(Entity::m_20183_).toList();
        if (players.isEmpty()) {
            return null;
        }
        double HARD_MAX_DIST_SQ = 1.0E8;
        double MAX_SPAWN_DIST_SQ = (currentCloudRegions < 3 ? 3000.0 : 5000.0) * (currentCloudRegions < 3 ? 3000.0 : 5000.0);
        double PREFERRED_DIST_SQ = 9000000.0;
        long tick = level.m_46467_();
        SpawnCandidate best = null;
        float bestScore = 0.0f;
        int attempts = Math.min(6, Math.max(1, remaining));
        for (int i = 0; i < attempts; ++i) {
            float humidityPercent;
            Set<BiomeInstanceKey> keys;
            WeatherSampler.WeatherStats stats;
            SpawnRegion region = regions.get(SPAWN_RANDOM.m_188503_(regions.size()));
            Vector2i point = SpawnRegion.getRandomPointInRegion((SpawnRegion)region, (RandomSource)SPAWN_RANDOM);
            int radius = BiasedToBottomInt.m_146367_((int)SimpleCloudsCompat.MIN_RADIUS, (int)SimpleCloudsCompat.MAX_RADIUS).m_214085_(SPAWN_RANDOM);
            boolean tooFar = true;
            for (BlockPos playerPos : players) {
                double dz;
                double dx = point.x - playerPos.m_123341_();
                double distSq = dx * dx + (dz = (double)(point.y - playerPos.m_123343_())) * dz;
                if (!(distSq <= 1.0E8) || !(distSq <= MAX_SPAWN_DIST_SQ)) continue;
                tooFar = false;
                break;
            }
            if (tooFar || (stats = WeatherSampler.computeWeatherStats(keys = WeatherSampler.sampleBiomesInArea(point.x, point.y, radius, level), level, tick)) == null || (humidityPercent = stats.humidity()) < 82.0f) continue;
            float dewPoint = SimpleCloudSpawner.calculateDewPoint(stats.temperature(), humidityPercent);
            int severity = SimpleCloudSpawner.determineCloudSeverity(stats.temperature(), humidityPercent, stats.pressure(), dewPoint, stats.stormFactor(), level);
            if (severity <= 0) continue;
            boolean freezing = stats.temperature() <= 0.0f;
            String cloudId = CloudManager.selectCloudId(severity, freezing);
            float humidityNorm = humidityPercent / 100.0f;
            float score = humidityNorm * 0.6f + (float)severity / 7.0f * 0.4f;
            for (BlockPos playerPos : players) {
                double dz;
                double dx = point.x - playerPos.m_123341_();
                double distSq = dx * dx + (dz = (double)(point.y - playerPos.m_123343_())) * dz;
                if (!(distSq <= 9000000.0)) continue;
                score += 0.2f;
                break;
            }
            if (freezing && severity >= 6) {
                score += 0.15f;
            }
            if (best != null && !(score > bestScore)) continue;
            bestScore = score;
            best = new SpawnCandidate(stats, radius, cloudId);
        }
        return best;
    }

    private static void spawnCandidate(ServerLevel level, CloudGenerator generator, SpawnCandidate candidate) {
        if (candidate == null || SimpleCloudsCompat.spawnConfig == null) {
            return;
        }
        BiomeInstanceKey key = new BiomeInstanceKey(candidate.stats().dominantBiome(), candidate.stats().pos());
        if (generator.getCloudAtWorldPosition((float)key.samplePos().m_123341_(), (float)key.samplePos().m_123343_()) != null) {
            return;
        }
        ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"simpleclouds", (String)candidate.cloudId());
        CloudSpawningConfig.Info info = SimpleCloudsCompat.spawnConfig.getWeightInfo(rl);
        if (info == null) {
            ProjectAtmosphere.LOGGER.warn("[Atmosphere] Unknown cloud type: {}", (Object)candidate.cloudId());
            return;
        }
        Optional<CloudRegion> dummy = SimpleCloudsCompat.createRegion((SpawnInfo)info, key, level, level.f_46441_, candidate.stats().windVector(), generator);
        if (dummy.isEmpty()) {
            return;
        }
        CloudRegion region = dummy.get();
        region.setRadius((float)candidate.radius());
        SimpleCloudsCompat.spawnCloudInBiome(candidate.cloudId(), key, level, region, candidate.stats().windVector());
    }

    private static String selectCloudId(int severity, boolean freezing) {
        if (severity > 5 && freezing) {
            return CloudLibrary.getSnowstormCloudId();
        }
        String cloudId = CloudLibrary.getCloudIdFromSeverity(severity);
        if (CloudLibrary.isThunderCloud(cloudId) && freezing) {
            return CloudLibrary.getCloudIdFromSeverity(5);
        }
        return cloudId;
    }

    private static int extractId(CloudRegion region) {
        if (region instanceof ICloudRegionId) {
            ICloudRegionId accessor = (ICloudRegionId)region;
            return accessor.projectatmosphere$getId();
        }
        return System.identityHashCode(region);
    }

    private record RegionDescriptor(int id, ResourceLocation cloudType, double worldX, double worldZ, float radius) {
    }

    private record RegionSample(int id, ResourceLocation cloudType, double worldX, double worldZ, float radius, float avgHumidityNorm, float avgHumidityPercent, float avgTemperature, float avgPressure, float avgRainIntensity, float dewPoint, List<Footprint> footprint) {

        record Footprint(RegionInstanceKey key, float weight) {
        }
    }

    private static final class RegionCloudData {
        private float thickness;
        private float rainIntensity;
        private float lastHumidity;
        private int dryTicks;

        private RegionCloudData() {
        }

        void updateFromSample(RegionSample sample, CloudRegion region) {
            this.lastHumidity = sample.avgHumidityNorm();
            this.dryTicks = this.lastHumidity < 0.35f ? ++this.dryTicks : Math.max(0, this.dryTicks - 1);
            this.updateThickness(sample.avgHumidityNorm());
            this.updateRainIntensity(sample.avgHumidityNorm());
            this.adjustRadius(sample, region);
        }

        float getThickness() {
            return this.thickness;
        }

        float getRainIntensity() {
            return this.rainIntensity;
        }

        private void updateThickness(float humidity) {
            float normalized = (humidity - 0.35f) / 0.5f;
            float target = Mth.m_14036_((float)normalized, (float)0.0f, (float)1.0f);
            float delta = target - this.thickness;
            if (Math.abs(delta) < 0.001f) {
                return;
            }
            if (delta > 0.0f) {
                this.thickness = Mth.m_14036_((float)(this.thickness + delta * 0.25f), (float)0.0f, (float)1.0f);
            } else {
                float drynessFactor = Math.min(1.0f, (float)this.dryTicks / 200.0f);
                float rate = 0.08f + drynessFactor * 0.08f;
                this.thickness = Mth.m_14036_((float)(this.thickness + delta * rate), (float)0.0f, (float)1.0f);
            }
        }

        private void updateRainIntensity(float humidity) {
            float desired;
            if (humidity >= 0.55f && this.thickness > 0.35f) {
                float humidityFactor = (humidity - 0.55f) / 0.45f;
                desired = Mth.m_14036_((float)(humidityFactor * this.thickness), (float)0.0f, (float)1.0f);
            } else {
                desired = 0.0f;
            }
            float delta = desired - this.rainIntensity;
            if (Math.abs(delta) < 0.001f) {
                this.rainIntensity = desired;
                return;
            }
            float step = delta > 0.0f ? 0.04f : 0.02f;
            float adjustment = Mth.m_14036_((float)delta, (float)(-step), (float)step);
            this.rainIntensity = Mth.m_14036_((float)(this.rainIntensity + adjustment), (float)0.0f, (float)1.0f);
        }

        private void adjustRadius(RegionSample sample, CloudRegion region) {
            float severityBias = (float)CloudLibrary.getSeverityFromRessourceLocation(sample.cloudType()) / 7.0f;
            float humidityScore = (sample.avgHumidityNorm() - 0.35f) / 0.5f;
            float temperaturePenalty = 1.0f - Mth.m_14036_((float)((sample.avgTemperature() - 18.0f) / 28.0f), (float)0.0f, (float)1.0f);
            float growthScore = humidityScore * 0.7f + temperaturePenalty * 0.3f;
            float radius = region.getRadius();
            float delta = growthScore >= 0.5f ? (growthScore - 0.5f) * 0.0125f * Math.max(radius, (float)SimpleCloudsCompat.MIN_RADIUS) : ((growthScore += (severityBias - 0.5f) * 0.15f) - 0.5f) * 0.02f * Math.max(radius, (float)SimpleCloudsCompat.MIN_RADIUS);
            float newRadius = Mth.m_14036_((float)(radius + delta), (float)SimpleCloudsCompat.MIN_RADIUS, (float)SimpleCloudsCompat.MAX_RADIUS);
            if (this.dryTicks > 400 && this.thickness < 0.25f) {
                newRadius = Math.max((float)SimpleCloudsCompat.MIN_RADIUS, newRadius - 0.02f * radius);
            }
            region.setRadius(newRadius);
        }
    }

    private static final class BiomeContribution {
        float cloudCover;
        float rainIntensity;

        private BiomeContribution() {
        }

        void add(float weight, float regionThickness, float regionRain) {
            this.cloudCover += weight * regionThickness;
            this.rainIntensity += weight * regionRain;
        }
    }

    private record SpawnCandidate(WeatherSampler.WeatherStats stats, int radius, String cloudId) {
    }

    private record SpawnSearchResult(SpawnCandidate candidate) {
    }
}

