/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.atmosphere;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.Gabou.projectatmosphere.async.PoolType;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;

public final class CycloneManager {
    private static final List<Cyclone> ACTIVE_CYCLONES = new CopyOnWriteArrayList<Cyclone>();
    private static final long COOLDOWN_TICKS = 48000L;
    private static long lastSpawnTick = -48000L;
    private static long lastMidnightTick = -1L;

    private CycloneManager() {
    }

    public static void initialize(ServerLevel level) {
        ACTIVE_CYCLONES.clear();
        lastSpawnTick = level.m_46468_();
        lastMidnightTick = -1L;
        CycloneManager.spawnInitialCyclones(level);
    }

    public static void update(ServerLevel level) {
        if (AtmosphericStateRegistry.isEmpty()) {
            return;
        }
        long dayTime = level.m_46468_();
        if (dayTime % 24000L == 0L && lastMidnightTick != dayTime) {
            CycloneManager.onMidnight(level);
            lastMidnightTick = dayTime;
        }
        List<RegionAtmosphereState> snapshot = AtmosphericStateRegistry.snapshot();
        for (Cyclone cyclone : new ArrayList<Cyclone>(ACTIVE_CYCLONES)) {
            AsyncAtmosphereService.runWithCallback(PoolType.WEATHER, () -> cyclone.tick(snapshot), result -> {
                if (result == null) {
                    return;
                }
                CycloneManager.applyCyclone(result);
                if (result.remove()) {
                    ACTIVE_CYCLONES.remove(cyclone);
                }
            });
        }
    }

    public static void onMidnight(ServerLevel level) {
        if (ACTIVE_CYCLONES.size() >= 4) {
            return;
        }
        long now = level.m_46468_();
        if (!CycloneManager.cooldownPassed(now)) {
            return;
        }
        List<RegionAtmosphereState> candidates = CycloneManager.findNearbyStates(level);
        if (candidates.isEmpty()) {
            return;
        }
        CycloneManager.spawnCyclone(level, candidates);
    }

    private static boolean cooldownPassed(long now) {
        return now - lastSpawnTick >= 48000L;
    }

    private static void spawnInitialCyclones(ServerLevel level) {
        RandomSource random = level.f_46441_;
        int count = 3 + random.m_188503_(6);
        List<RegionAtmosphereState> candidates = CycloneManager.findNearbyStates(level);
        if (candidates.isEmpty()) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            CycloneManager.spawnCyclone(level, candidates);
        }
    }

    private static void spawnCyclone(ServerLevel level, List<RegionAtmosphereState> candidates) {
        RandomSource random = level.f_46441_;
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        RegionAtmosphereState state = candidates.get(random.m_188503_(candidates.size()));
        float radius = 180.0f + random.m_188501_() * 140.0f;
        float intensity = 0.4f + random.m_188501_() * 0.4f;
        float pressureDrop = 5.0f + random.m_188501_() * 10.0f;
        long lifetime = 24000L + (long)random.m_188503_(24000);
        ACTIVE_CYCLONES.add(new Cyclone(new Vec2((float)state.getPosition().m_123341_(), (float)state.getPosition().m_123343_()), radius, intensity, pressureDrop, lifetime));
        lastSpawnTick = level.m_46468_();
    }

    private static List<RegionAtmosphereState> findNearbyStates(ServerLevel level) {
        List<BlockPos> players = level.m_6907_().stream().map(Entity::m_20183_).toList();
        if (players.isEmpty()) {
            return List.of();
        }
        double MAX_DIST_SQ = 2.5E7;
        return AtmosphericStateRegistry.snapshot().stream().filter(state -> {
            BlockPos pos = state.getPosition();
            if (pos == null) {
                return false;
            }
            for (BlockPos player : players) {
                double dz;
                double dx = pos.m_123341_() - player.m_123341_();
                if (!(dx * dx + (dz = (double)(pos.m_123343_() - player.m_123343_())) * dz <= 2.5E7)) continue;
                return true;
            }
            return false;
        }).toList();
    }

    private static void applyCyclone(CycloneStep step) {
        if (step.deltas().isEmpty()) {
            return;
        }
        for (CycloneDelta delta : step.deltas()) {
            RegionAtmosphereState state = AtmosphericStateRegistry.getState(delta.key());
            if (state == null) continue;
            state.adjustTemperature(delta.temperatureDelta());
            state.adjustHumidity(delta.humidityDelta());
            state.adjustPressure(delta.pressureDelta());
            state.setRainIntensity(Math.min(1.0f, Math.max(state.getRainIntensity(), delta.rainCeil())));
            state.setCloudCover(Math.min(1.0f, Math.max(state.getCloudCover(), delta.cloudCeil())));
        }
    }

    private static final class Cyclone {
        private Vec2 center;
        private float radius;
        private float intensity;
        private final float corePressureDrop;
        private long lifetimeTicks;
        private int counter = 0;

        private Cyclone(Vec2 center, float radius, float intensity, float corePressureDrop, long lifetimeTicks) {
            this.center = center;
            this.radius = radius;
            this.intensity = intensity;
            this.corePressureDrop = corePressureDrop;
            this.lifetimeTicks = lifetimeTicks;
        }

        private CycloneStep tick(List<RegionAtmosphereState> snapshot) {
            List<CycloneDelta> deltas = List.of();
            if (this.counter++ % 20 == 0) {
                deltas = this.applyEffects(snapshot);
            }
            this.drift(snapshot);
            --this.lifetimeTicks;
            this.intensity *= 0.9995f;
            if (this.lifetimeTicks <= 0L || this.intensity < 0.05f) {
                return new CycloneStep(true, deltas);
            }
            this.radius = Mth.m_14036_((float)(this.radius + (this.intensity - 0.5f) * 0.8f), (float)120.0f, (float)420.0f);
            return new CycloneStep(false, deltas);
        }

        private List<CycloneDelta> applyEffects(List<RegionAtmosphereState> states) {
            ArrayList<CycloneDelta> deltas = new ArrayList<CycloneDelta>();
            if (states.isEmpty()) {
                return deltas;
            }
            float maxPressureDrop = Math.min(12.0f, this.corePressureDrop);
            for (RegionAtmosphereState state : states) {
                double dz;
                double dx = (float)state.getPosition().m_123341_() - this.center.f_82470_;
                double distance = Math.sqrt(dx * dx + (dz = (double)((float)state.getPosition().m_123343_() - this.center.f_82471_)) * dz);
                float influence = (float)(1.0 - distance / (double)this.radius);
                if (influence <= 0.0f) {
                    influence = 0.0f;
                }
                float scaledInfluence = influence * this.intensity;
                float pressureDelta = Mth.m_14036_((float)(-maxPressureDrop * scaledInfluence), (float)-20.0f, (float)0.0f);
                float humidityDelta = Mth.m_14036_((float)scaledInfluence, (float)0.0f, (float)0.6f);
                float temperatureDelta = Mth.m_14036_((float)(-scaledInfluence * 2.0f), (float)-8.0f, (float)0.0f);
                float rainCeil = Mth.m_14036_((float)scaledInfluence, (float)0.0f, (float)1.0f);
                float cloudCeil = Mth.m_14036_((float)(state.getCloudCover() + scaledInfluence * 0.25f), (float)0.0f, (float)1.0f);
                deltas.add(new CycloneDelta(state.getKey(), temperatureDelta, humidityDelta, pressureDelta, rainCeil, cloudCeil));
            }
            return deltas;
        }

        private void drift(List<RegionAtmosphereState> states) {
            RegionAtmosphereState nearest = this.findNearest(states, this.center.f_82470_, this.center.f_82471_);
            if (nearest == null) {
                return;
            }
            WindVector wind = nearest.getWind();
            if (wind == null) {
                return;
            }
            float speed = Math.max(0.05f, wind.baseSpeed() * 0.02f);
            float angle = wind.angleRadians();
            float dx = (float)Math.sin(angle) * speed;
            float dz = (float)Math.cos(angle) * speed;
            this.center = this.center.m_165910_(new Vec2(dx, dz));
        }

        private RegionAtmosphereState findNearest(List<RegionAtmosphereState> states, double x, double z) {
            RegionAtmosphereState nearest = null;
            double best = Double.MAX_VALUE;
            for (RegionAtmosphereState state : states) {
                double dist = state.distanceTo(x, z);
                if (!(dist < best)) continue;
                best = dist;
                nearest = state;
            }
            return nearest;
        }
    }

    private record CycloneStep(boolean remove, List<CycloneDelta> deltas) {
    }

    private record CycloneDelta(RegionInstanceKey key, float temperatureDelta, float humidityDelta, float pressureDelta, float rainCeil, float cloudCeil) {
    }
}

