/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.atmosphere;

import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.minecraft.server.level.ServerLevel;

public final class RainSystem {
    private static final float COOLING_SCALE = 3.0f;
    private static final float HUMIDITY_DRAIN = 0.2f;
    private static final float PRESSURE_RESTORE = 1.5f;
    private static final float RAIN_FADE = 0.01f;

    private RainSystem() {
    }

    public static void update(ServerLevel level) {
        if (AtmosphericStateRegistry.isEmpty()) {
            return;
        }
        for (RegionAtmosphereState state : AtmosphericStateRegistry.getStates()) {
            float intensity = state.getRainIntensity();
            if (intensity <= 0.0f) {
                state.dampenRain(0.01f);
                continue;
            }
            float clamped = Math.min(1.0f, intensity);
            state.adjustTemperature(-clamped * 3.0f);
            state.adjustHumidity(-clamped * 0.2f);
            state.adjustPressure(clamped * 1.5f);
            state.dampenRain(0.01f);
        }
    }
}

