/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ForecastRegion {
    private static final float MIN_TEMPERATURE_C = -90.0f;
    private static final float MAX_TEMPERATURE_C = 70.0f;
    private static final float MIN_PRESSURE_HPA = 880.0f;
    private static final float MAX_PRESSURE_HPA = 1085.0f;
    private static final float MIN_HUMIDITY = 0.0f;
    private static final float MAX_HUMIDITY = 100.0f;
    private final RegionInstanceKey key;
    private final BlockPos anchor;
    private final List<BiomeInstanceKey> samples = new ArrayList<BiomeInstanceKey>();
    private final List<BiomeForecast> biomeForecasts = new ArrayList<BiomeForecast>();
    private final Map<ResourceLocation, Integer> biomeWeights = new HashMap<ResourceLocation, Integer>();
    private float[][] temperature;
    private float[][] humidity;
    private float[][] pressure;
    private WindVector[] wind;
    private WindVector windDay;

    public ForecastRegion(RegionInstanceKey key) {
        this(key, key.center());
    }

    public ForecastRegion(RegionInstanceKey key, BlockPos anchor) {
        this.key = key;
        this.anchor = anchor == null ? key.center() : anchor;
    }

    public RegionInstanceKey getKey() {
        return this.key;
    }

    public BlockPos getAnchor() {
        return this.anchor;
    }

    public Map<ResourceLocation, Integer> getBiomeWeights() {
        return this.biomeWeights;
    }

    public List<BiomeInstanceKey> getSamples() {
        return this.samples;
    }

    public float[][] getTemperature() {
        return this.temperature;
    }

    public float[][] getHumidity() {
        return this.humidity;
    }

    public float[][] getPressure() {
        return this.pressure;
    }

    public WindVector[] getWind() {
        return this.wind;
    }

    public WindVector getWindDay() {
        return this.windDay;
    }

    public void addBiomeForecast(BiomeInstanceKey biomeKey, BiomeForecast forecast) {
        this.addBiomeForecast(biomeKey, forecast, 1);
    }

    public void addBiomeForecast(BiomeInstanceKey biomeKey, BiomeForecast forecast, int weight) {
        if (biomeKey == null || forecast == null) {
            return;
        }
        this.samples.add(biomeKey);
        this.biomeForecasts.add(forecast);
        this.biomeWeights.merge(biomeKey.biomeType(), Math.max(1, weight), Integer::sum);
    }

    public void finalizeAggregation() {
        if (this.biomeForecasts.isEmpty()) {
            this.buildFallback();
            return;
        }
        this.temperature = ForecastRegion.clampWeek(ForecastRegion.averageWeek(this.biomeForecasts, BiomeForecast::getTemperature), -90.0f, 70.0f);
        this.humidity = ForecastRegion.clampWeek(ForecastRegion.averageWeek(this.biomeForecasts, BiomeForecast::getHumidity), 0.0f, 100.0f);
        this.pressure = ForecastRegion.clampWeek(ForecastRegion.averageWeek(this.biomeForecasts, BiomeForecast::getPressure), 880.0f, 1085.0f);
        this.wind = ForecastRegion.averageWindWeek(this.biomeForecasts, BiomeForecast::getWind);
        this.windDay = this.wind.length > 0 ? this.wind[0] : WindVector.fromBase(0.0f, 0.0f);
    }

    private void buildFallback() {
        this.temperature = ForecastRegion.flatWeek(12.0f);
        this.humidity = ForecastRegion.flatWeek(65.0f);
        this.pressure = ForecastRegion.flatWeek(1013.25f);
        this.wind = new WindVector[7];
        for (int i = 0; i < this.wind.length; ++i) {
            this.wind[i] = WindVector.fromBase(1.2f, 0.0f);
        }
        this.windDay = this.wind[0];
    }

    private static float[][] flatWeek(float value) {
        float[][] arr = new float[7][2];
        for (int d = 0; d < 7; ++d) {
            arr[d][0] = value;
            arr[d][1] = value;
        }
        return arr;
    }

    private static float[][] averageWeek(List<BiomeForecast> forecasts, Function<BiomeForecast, float[][]> extractor) {
        int days = 7;
        int cols = 2;
        float[][] result = new float[days][cols];
        int count = forecasts.size();
        for (BiomeForecast forecast : forecasts) {
            float[][] data = extractor.apply(forecast);
            if (data == null) continue;
            for (int d = 0; d < days; ++d) {
                for (int c = 0; c < cols; ++c) {
                    float[] fArray = result[d];
                    int n = c;
                    fArray[n] = fArray[n] + data[d][c];
                }
            }
        }
        if (count == 0) {
            return result;
        }
        for (int d = 0; d < days; ++d) {
            int c = 0;
            while (c < cols) {
                float[] fArray = result[d];
                int n = c++;
                fArray[n] = fArray[n] / (float)count;
            }
        }
        return result;
    }

    private static float[][] clampWeek(float[][] week, float min, float max) {
        if (week == null) {
            return ForecastRegion.flatWeek(Mth.m_14036_((float)0.0f, (float)min, (float)max));
        }
        for (int d = 0; d < week.length; ++d) {
            for (int c = 0; c < week[d].length; ++c) {
                week[d][c] = Mth.m_14036_((float)week[d][c], (float)min, (float)max);
            }
        }
        return week;
    }

    private static WindVector[] averageWindWeek(List<BiomeForecast> forecasts, Function<BiomeForecast, WindVector[]> extractor) {
        WindVector[] result = new WindVector[7];
        for (int d = 0; d < result.length; ++d) {
            float sumX = 0.0f;
            float sumZ = 0.0f;
            float sumGust = 0.0f;
            int count = 0;
            for (BiomeForecast forecast : forecasts) {
                WindVector[] week = extractor.apply(forecast);
                if (week == null || week.length <= d || week[d] == null) continue;
                WindVector wind = week[d];
                float angle = wind.angleRadians();
                float speed = wind.baseSpeed();
                sumX += speed * (float)Math.cos(angle);
                sumZ += speed * (float)Math.sin(angle);
                sumGust += wind.gustSpeed();
                ++count;
            }
            if (count == 0) {
                result[d] = WindVector.fromBase(0.5f, 0.0f);
                continue;
            }
            float avgX = sumX / (float)count;
            float avgZ = sumZ / (float)count;
            float avgSpeed = (float)Math.sqrt(avgX * avgX + avgZ * avgZ);
            float avgAngle = (float)Math.atan2(avgZ, avgX);
            float avgGust = sumGust / (float)count;
            result[d] = new WindVector(avgSpeed, avgAngle, avgGust);
        }
        return result;
    }
}

