/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.server.level.ServerLevel;

public record WindVector(float baseSpeed, float angleRadians, float gustSpeed) {
    private static final Map<RegionInstanceKey, WindSample> CURRENT = new HashMap<RegionInstanceKey, WindSample>();

    public WindVector add(WindVector other) {
        return new WindVector(this.baseSpeed + other.baseSpeed, this.angleRadians + other.angleRadians, this.gustSpeed + other.gustSpeed);
    }

    public WindVector subtract(WindVector other) {
        return new WindVector(this.baseSpeed - other.baseSpeed, this.angleRadians - other.angleRadians, this.gustSpeed - other.gustSpeed);
    }

    public WindVector divide(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be greater than zero");
        }
        return new WindVector(this.baseSpeed / (float)count, this.angleRadians / (float)count, this.gustSpeed / (float)count);
    }

    public static WindVector fromBase(float baseSpeed, float angleRadians) {
        return new WindVector(baseSpeed, angleRadians, baseSpeed);
    }

    public static void update(ServerLevel level) {
        RegionAtmosphereState state;
        if (AtmosphericStateRegistry.getActiveStates().isEmpty()) {
            return;
        }
        Map<RegionInstanceKey, RegionAtmosphereState> states = AtmosphericStateRegistry.getStatesAsMap();
        Set<RegionInstanceKey> activeKeys = AtmosphericStateRegistry.getActiveStates();
        Map<RegionInstanceKey, List<RegionInstanceKey>> neighborsMap = AtmosphericStateRegistry.getNeighborsAsMap();
        HashMap<RegionInstanceKey, Delta> deltas = new HashMap<RegionInstanceKey, Delta>();
        for (RegionInstanceKey regionInstanceKey : activeKeys) {
            List neighbors;
            float strength;
            state = states.get(regionInstanceKey);
            if (state == null || (strength = state.getWindStrength()) <= 0.01f || (neighbors = neighborsMap.getOrDefault(regionInstanceKey, List.of())).isEmpty()) continue;
            Delta delta = deltas.computeIfAbsent(regionInstanceKey, k -> new Delta());
            for (RegionInstanceKey neighborKey : neighbors) {
                RegionAtmosphereState neighbor = states.get(neighborKey);
                if (neighbor == null) continue;
                float mixingFactor = 0.02f * strength;
                delta.temperature += (neighbor.getTemperature() - state.getTemperature()) * mixingFactor;
                delta.humidity += (neighbor.getHumidity() - state.getHumidity()) * (0.03f * strength);
                delta.pressure += (neighbor.getPressure() - state.getPressure()) * (0.05f * strength);
            }
        }
        for (Map.Entry entry : deltas.entrySet()) {
            RegionInstanceKey key = (RegionInstanceKey)entry.getKey();
            RegionAtmosphereState state2 = states.get(key);
            if (state2 == null) continue;
            Delta d = (Delta)entry.getValue();
            state2.adjustTemperature(d.temperature);
            state2.adjustHumidity(d.humidity);
            state2.adjustPressure(d.pressure);
        }
        for (RegionInstanceKey regionInstanceKey : activeKeys) {
            WindVector wind;
            state = states.get(regionInstanceKey);
            if (state == null || (wind = state.getWind()) == null) continue;
            float jitter = (level.f_46441_.m_188501_() - 0.5f) * 0.02f;
            float speed = Math.max(0.0f, wind.baseSpeed() + jitter);
            float angle = wind.angleRadians() + (level.f_46441_.m_188501_() - 0.5f) * 0.01f;
            state.setWind(new WindVector(speed, angle, Math.max(speed, wind.gustSpeed())));
        }
    }

    public static void set(RegionInstanceKey key, float effectiveSpeed, float directionDeg) {
        CURRENT.put(key, new WindSample(effectiveSpeed, directionDeg));
    }

    public static WindSample getOrFallback(RegionInstanceKey key) {
        return CURRENT.computeIfAbsent(key, k -> WindVector.randomSample(new Random()));
    }

    private static WindSample randomSample(Random rng) {
        float speed = rng.nextFloat();
        float dir = rng.nextFloat() * 360.0f;
        return new WindSample(speed, dir);
    }

    private static final class Delta {
        private float temperature;
        private float humidity;
        private float pressure;

        private Delta() {
        }
    }

    public record WindSample(float speedMps, float directionDeg) {
    }
}

