/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.hurricane;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneCategory;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneInstance;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneManager;
import net.Gabou.projectatmosphere.seasons.SeasonStage;
import net.Gabou.projectatmosphere.seasons.SeasonTimeHelper;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HurricaneCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnHurricane").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"category", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerLevel level = player.m_284548_();
            if (!level.m_46472_().equals((Object)Level.f_46428_)) {
                return 0;
            }
            BlockPos pos = player.m_20183_();
            Holder biome = level.m_204166_(pos);
            if (!biome.m_203656_(BiomeTags.f_207603_)) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Hurricanes can only spawn in warm oceans."));
                return 0;
            }
            SeasonStage stage = SeasonTimeHelper.stage((Level)level);
            if (stage == SeasonStage.WINTER) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Hurricanes only spawn between spring and autumn."));
                return 0;
            }
            int catInt = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"category");
            HurricaneCategory cat = HurricaneCategory.fromId(catInt);
            BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, (Level)level), pos);
            WindVector wind = ForecastOrchestrator.getCurrentWind(key, level.m_46467_());
            SimpleCloudsCompat.spawnCloudInBiome("custom_cumulonimbus", key, level, null, wind);
            Vec3 spawnPos = new Vec3(player.m_20185_(), (double)level.m_5736_(), player.m_20189_());
            HurricaneManager.spawnServer(level, spawnPos, 40.0f, wind, cat);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\ud83c\udf00 Hurricane category " + catInt + " spawned.")), true);
            return 1;
        }));
        event.getDispatcher().register(base);
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clearhurricanes").requires(source -> source.m_6761_(2))).executes(ctx -> {
            HurricaneManager.clearHurricanes();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83c\udf00 All hurricanes cleared."), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"removehurricane").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            Vec3 playerPos = player.m_20182_();
            HurricaneInstance hurricane = HurricaneManager.getActiveHurricanes().stream().filter(h -> h.position.m_82557_(playerPos) < 400.0).findFirst().orElse(null);
            if (hurricane != null) {
                HurricaneManager.removeHurricane(hurricane);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83c\udf00 Hurricane removed."), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No hurricane found near you."));
            }
            return 1;
        }));
    }
}

