/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.ocean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.ocean.AtmosVolumeInfluence;
import net.Gabou.projectatmosphere.modules.ocean.AtmosphericVolume;
import net.Gabou.projectatmosphere.modules.ocean.OceanInfluence;
import net.Gabou.projectatmosphere.modules.ocean.OceanUpdateContext;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.util.Mth;

public final class OceanBasin {
    private final int id;
    private final Set<RegionInstanceKey> oceanCells;
    private final Map<RegionInstanceKey, Float> influenceWeights;
    private final List<OceanInfluence> basinInfluences = new ArrayList<OceanInfluence>();
    private final List<AtmosVolumeInfluence> atmosphereInfluences = new ArrayList<AtmosVolumeInfluence>();
    private final float baseSurfaceTemperature;
    private final float baseHumidity;
    private final float basePressure;
    private float surfaceTemperature;
    private float deepTemperature;
    private float humidityReservoir;
    private float thermalMemory;
    private float multiDayAnomaly;
    private float pressureOffset;
    private WindVector windBias;

    OceanBasin(int id, Set<RegionInstanceKey> oceanCells, Map<RegionInstanceKey, Float> influenceWeights, float baseSurfaceTemperature, float baseHumidity, float basePressure, float deepTemperature, WindVector windBias) {
        this.id = id;
        this.oceanCells = Collections.unmodifiableSet(oceanCells);
        this.influenceWeights = new ConcurrentHashMap<RegionInstanceKey, Float>(influenceWeights);
        this.baseSurfaceTemperature = baseSurfaceTemperature;
        this.baseHumidity = baseHumidity;
        this.basePressure = basePressure;
        this.surfaceTemperature = baseSurfaceTemperature;
        this.deepTemperature = deepTemperature;
        this.humidityReservoir = baseHumidity;
        this.thermalMemory = baseSurfaceTemperature;
        this.multiDayAnomaly = 0.0f;
        this.pressureOffset = basePressure - 1013.25f;
        this.windBias = Objects.requireNonNullElse(windBias, WindVector.fromBase(0.0f, 0.0f));
    }

    public int getId() {
        return this.id;
    }

    public float getSurfaceTemperature() {
        return this.surfaceTemperature;
    }

    public void setSurfaceTemperature(float value) {
        this.surfaceTemperature = value;
    }

    public float getDeepTemperature() {
        return this.deepTemperature;
    }

    public void setDeepTemperature(float value) {
        this.deepTemperature = value;
    }

    public float getBaseSurfaceTemperature() {
        return this.baseSurfaceTemperature;
    }

    public float getBaseHumidity() {
        return this.baseHumidity;
    }

    public float getHumidityReservoir() {
        return this.humidityReservoir;
    }

    public void setHumidityReservoir(float value) {
        this.humidityReservoir = Mth.m_14036_((float)value, (float)0.0f, (float)1.5f);
    }

    public float getThermalMemory() {
        return this.thermalMemory;
    }

    public void setThermalMemory(float value) {
        this.thermalMemory = value;
    }

    public float getMultiDayAnomaly() {
        return this.multiDayAnomaly;
    }

    public void setMultiDayAnomaly(float value) {
        this.multiDayAnomaly = value;
    }

    public float getPressureOffset() {
        return this.pressureOffset;
    }

    public void setPressureOffset(float value) {
        this.pressureOffset = Mth.m_14036_((float)value, (float)-35.0f, (float)35.0f);
    }

    public float getBasePressure() {
        return this.basePressure;
    }

    public WindVector getWindBias() {
        return this.windBias;
    }

    public void setWindBias(WindVector windBias) {
        this.windBias = Objects.requireNonNullElse(windBias, WindVector.fromBase(0.0f, 0.0f));
    }

    public Set<RegionInstanceKey> getOceanCells() {
        return this.oceanCells;
    }

    public Map<RegionInstanceKey, Float> getInfluenceWeights() {
        return this.influenceWeights;
    }

    public void addOceanInfluence(OceanInfluence influence) {
        this.basinInfluences.add(influence);
    }

    public void addAtmosphereInfluence(AtmosVolumeInfluence influence) {
        this.atmosphereInfluences.add(influence);
    }

    public void tick(OceanUpdateContext context, Set<RegionInstanceKey> activeKeys) {
        for (OceanInfluence oceanInfluence : this.basinInfluences) {
            oceanInfluence.applyTo(this, context);
        }
        if (this.atmosphereInfluences.isEmpty() || activeKeys.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.influenceWeights.entrySet()) {
            RegionAtmosphereState state;
            RegionInstanceKey key = (RegionInstanceKey)entry.getKey();
            if (!activeKeys.contains(key) || (state = AtmosphericStateRegistry.getState(key)) == null) continue;
            float weight = Mth.m_14036_((float)((Float)entry.getValue()).floatValue(), (float)0.0f, (float)1.5f);
            AtmosphericVolume volume = new AtmosphericVolume(this, state, weight, this.oceanCells.contains(key));
            for (AtmosVolumeInfluence influence : this.atmosphereInfluences) {
                influence.applyTo(volume, context);
            }
        }
    }

    public boolean intersects(Set<RegionInstanceKey> activeKeys) {
        if (activeKeys.isEmpty()) {
            return false;
        }
        for (RegionInstanceKey key : activeKeys) {
            if (!this.influenceWeights.containsKey(key)) continue;
            return true;
        }
        return false;
    }
}

