/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.ocean;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.ocean.OceanBasin;
import net.Gabou.projectatmosphere.modules.ocean.OceanBiomeClassifier;
import net.Gabou.projectatmosphere.modules.ocean.OceanUpdateContext;
import net.Gabou.projectatmosphere.modules.ocean.influence.AtmosphereFluxInfluence;
import net.Gabou.projectatmosphere.modules.ocean.influence.BasinPressureMemoryInfluence;
import net.Gabou.projectatmosphere.modules.ocean.influence.BasinThermalMemoryInfluence;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;

public final class OceanBasinManager {
    private static final Map<Integer, OceanBasin> BASINS = new ConcurrentHashMap<Integer, OceanBasin>();
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    private static volatile CompletableFuture<Void> detectionTask = CompletableFuture.completedFuture(null);
    private static final AtomicBoolean READY = new AtomicBoolean(false);

    private OceanBasinManager() {
    }

    public static void initialize(ServerLevel level) {
        READY.set(false);
        BASINS.clear();
        NEXT_ID.set(0);
        detectionTask.cancel(true);
        detectionTask = ((CompletableFuture)CompletableFuture.supplyAsync(OceanBasinManager::detectBasins, AsyncAtmosphereService.getWeatherExecutor()).thenAccept(basins -> {
            BASINS.clear();
            for (OceanBasin basin : basins) {
                BASINS.put(basin.getId(), basin);
            }
            READY.set(true);
            if (ProjectAtmosphere.DEBUG_MODE) {
                ProjectAtmosphere.LOGGER.info("[Ocean] Detected {} basins", (Object)basins.size());
            }
        })).exceptionally(ex -> {
            ProjectAtmosphere.LOGGER.error("[Ocean] Failed to detect basins", ex);
            READY.set(false);
            return null;
        });
    }

    public static void update(ServerLevel level, Set<BiomeInstanceKey> activeKeys) {
        if (!READY.get() || AtmosphericStateRegistry.isEmpty()) {
            return;
        }
        if (activeKeys.isEmpty()) {
            return;
        }
        HashSet<RegionInstanceKey> activeRegions = new HashSet<RegionInstanceKey>();
        for (BiomeInstanceKey key : activeKeys) {
            RegionInstanceKey regionKey = AtmosphericStateRegistry.resolveRegionKey(key);
            if (regionKey == null) continue;
            activeRegions.add(regionKey);
        }
        if (activeRegions.isEmpty()) {
            return;
        }
        OceanUpdateContext context = new OceanUpdateContext(level, level.m_46467_(), 1.3888889E-5f);
        for (OceanBasin basin : BASINS.values()) {
            if (!basin.intersects(activeRegions)) {
                basin.tick(context, Collections.emptySet());
                continue;
            }
            basin.tick(context, activeRegions);
        }
    }

    private static List<OceanBasin> detectBasins() {
        List<RegionAtmosphereState> states = AtmosphericStateRegistry.snapshot();
        if (states.isEmpty()) {
            return List.of();
        }
        HashMap<RegionInstanceKey, RegionAtmosphereState> oceanStates = new HashMap<RegionInstanceKey, RegionAtmosphereState>();
        for (RegionAtmosphereState state : states) {
            if (state.getDominantBiome() == null || !OceanBiomeClassifier.isOcean(state.getDominantBiome())) continue;
            oceanStates.put(state.getKey(), state);
        }
        if (oceanStates.isEmpty()) {
            return List.of();
        }
        HashSet<RegionInstanceKey> visited = new HashSet<RegionInstanceKey>();
        ArrayList<OceanBasin> basins = new ArrayList<OceanBasin>();
        for (RegionAtmosphereState state : oceanStates.values()) {
            if (visited.contains(state.getKey())) continue;
            basins.add(OceanBasinManager.buildBasin(state.getKey(), oceanStates, visited));
        }
        return basins;
    }

    private static OceanBasin buildBasin(RegionInstanceKey seed, Map<RegionInstanceKey, RegionAtmosphereState> oceanStates, Set<RegionInstanceKey> visited) {
        ArrayDeque<RegionInstanceKey> queue = new ArrayDeque<RegionInstanceKey>();
        queue.add(seed);
        HashSet<RegionInstanceKey> basinCells = new HashSet<RegionInstanceKey>();
        HashMap<RegionInstanceKey, Float> influenceWeights = new HashMap<RegionInstanceKey, Float>();
        float sumTemp = 0.0f;
        float sumHumidity = 0.0f;
        float sumPressure = 0.0f;
        float sumWindX = 0.0f;
        float sumWindZ = 0.0f;
        float sumGust = 0.0f;
        int count = 0;
        while (!queue.isEmpty()) {
            RegionAtmosphereState state;
            RegionInstanceKey key = (RegionInstanceKey)queue.remove();
            if (!visited.add(key) || (state = oceanStates.get(key)) == null) continue;
            basinCells.add(key);
            influenceWeights.put(key, Float.valueOf(1.0f));
            sumTemp += state.getTemperature();
            sumHumidity += state.getHumidity();
            sumPressure += state.getPressure();
            WindVector wind = state.getWind();
            if (wind != null) {
                sumWindX = (float)((double)sumWindX + Math.sin(wind.angleRadians()) * (double)wind.baseSpeed());
                sumWindZ = (float)((double)sumWindZ + Math.cos(wind.angleRadians()) * (double)wind.baseSpeed());
                sumGust += wind.gustSpeed();
            }
            ++count;
            for (RegionInstanceKey neighbor : AtmosphericStateRegistry.getNeighbors(key)) {
                if (oceanStates.containsKey(neighbor) && !visited.contains(neighbor)) {
                    queue.add(neighbor);
                    continue;
                }
                if (oceanStates.containsKey(neighbor)) continue;
                float weight = influenceWeights.getOrDefault(neighbor, Float.valueOf(0.0f)).floatValue();
                influenceWeights.put(neighbor, Float.valueOf(Math.max(weight, 0.55f)));
            }
        }
        float baseTemp = count == 0 ? 15.0f : sumTemp / (float)count;
        float baseHumidity = count == 0 ? 0.9f : sumHumidity / (float)count;
        float basePressure = count == 0 ? 1013.25f : sumPressure / (float)count;
        float deepTemp = baseTemp - 2.5f;
        WindVector windBias = null;
        if (count > 0) {
            float avgX = sumWindX / (float)count;
            float avgZ = sumWindZ / (float)count;
            float speed = Mth.m_14116_((float)(avgX * avgX + avgZ * avgZ)) * 0.35f;
            float angle = (float)Math.atan2(avgX, avgZ);
            float gust = sumGust / (float)Math.max(1, count) * 0.3f;
            windBias = new WindVector(speed, angle, Math.max(speed, gust));
        }
        OceanBasin basin = new OceanBasin(NEXT_ID.getAndIncrement(), basinCells, influenceWeights, baseTemp, baseHumidity, basePressure, deepTemp, windBias);
        basin.addOceanInfluence(new BasinThermalMemoryInfluence());
        basin.addOceanInfluence(new BasinPressureMemoryInfluence());
        basin.addAtmosphereInfluence(new AtmosphereFluxInfluence());
        return basin;
    }
}

