/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.ocean;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.minecraft.resources.ResourceLocation;

final class OceanBiomeClassifier {
    private static final Set<String> BASE_KEYWORDS = Set.of("ocean", "sea", "abyss", "lagoon", "gulf", "sound", "bay");
    private static final Set<String> MOD_KEYWORDS = new HashSet<String>();

    private OceanBiomeClassifier() {
    }

    static boolean isOcean(ResourceLocation biomeId) {
        if (biomeId == null) {
            return false;
        }
        String path = biomeId.m_135815_().toLowerCase(Locale.ROOT);
        if (path.contains("river") || path.contains("lake") || path.contains("swamp")) {
            return false;
        }
        for (String keyword : BASE_KEYWORDS) {
            if (!path.contains(keyword)) continue;
            return true;
        }
        for (String keyword : MOD_KEYWORDS) {
            if (!path.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    static {
        if (CompatHandler.isTectonicLoaded() || CompatHandler.isContinentsLoaded()) {
            MOD_KEYWORDS.add("shelf");
            MOD_KEYWORDS.add("trench");
            MOD_KEYWORDS.add("shoal");
            MOD_KEYWORDS.add("pelagic");
        }
    }
}

