/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.ocean.influence;

import net.Gabou.projectatmosphere.modules.ocean.OceanBasin;
import net.Gabou.projectatmosphere.modules.ocean.OceanInfluence;
import net.Gabou.projectatmosphere.modules.ocean.OceanUpdateContext;
import net.minecraft.util.Mth;

public final class BasinPressureMemoryInfluence
implements OceanInfluence {
    private final float pressureRelaxation;
    private final float deepRelaxation;

    public BasinPressureMemoryInfluence(float pressureRelaxation, float deepRelaxation) {
        this.pressureRelaxation = pressureRelaxation;
        this.deepRelaxation = deepRelaxation;
    }

    public BasinPressureMemoryInfluence() {
        this(7.0E-4f, 2.0E-4f);
    }

    @Override
    public void applyTo(OceanBasin basin, OceanUpdateContext context) {
        float targetPressure = basin.getBasePressure() - 1013.25f;
        float pressure = Mth.m_14179_((float)this.pressureRelaxation, (float)basin.getPressureOffset(), (float)targetPressure);
        basin.setPressureOffset(pressure);
        float targetDeep = Mth.m_14179_((float)0.5f, (float)basin.getBaseSurfaceTemperature(), (float)basin.getDeepTemperature());
        float deepTemp = Mth.m_14179_((float)this.deepRelaxation, (float)basin.getDeepTemperature(), (float)targetDeep);
        basin.setDeepTemperature(deepTemp);
    }
}

