/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.ocean.influence;

import net.Gabou.projectatmosphere.modules.ocean.OceanBasin;
import net.Gabou.projectatmosphere.modules.ocean.OceanInfluence;
import net.Gabou.projectatmosphere.modules.ocean.OceanUpdateContext;
import net.minecraft.util.Mth;

public final class BasinThermalMemoryInfluence
implements OceanInfluence {
    private final float surfaceRelaxation;
    private final float memoryRelaxation;
    private final float humidityRecovery;
    private final float anomalyDecay;

    public BasinThermalMemoryInfluence(float surfaceRelaxation, float memoryRelaxation, float humidityRecovery, float anomalyDecay) {
        this.surfaceRelaxation = surfaceRelaxation;
        this.memoryRelaxation = memoryRelaxation;
        this.humidityRecovery = humidityRecovery;
        this.anomalyDecay = anomalyDecay;
    }

    public BasinThermalMemoryInfluence() {
        this(9.0E-4f, 1.5E-4f, 6.0E-4f, 4.0E-4f);
    }

    @Override
    public void applyTo(OceanBasin basin, OceanUpdateContext context) {
        float targetSurface = basin.getThermalMemory() + basin.getMultiDayAnomaly();
        float surface = Mth.m_14179_((float)this.surfaceRelaxation, (float)basin.getSurfaceTemperature(), (float)targetSurface);
        basin.setSurfaceTemperature(surface);
        float memory = Mth.m_14179_((float)this.memoryRelaxation, (float)basin.getThermalMemory(), (float)basin.getBaseSurfaceTemperature());
        basin.setThermalMemory(memory);
        float humidity = Mth.m_14179_((float)this.humidityRecovery, (float)basin.getHumidityReservoir(), (float)basin.getBaseHumidity());
        basin.setHumidityReservoir(humidity);
        float anomaly = basin.getMultiDayAnomaly() * (1.0f - this.anomalyDecay);
        basin.setMultiDayAnomaly(anomaly);
    }
}

