/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.region;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;

public final class BiomeForecastSnapshot {
    private final BiomeInstanceKey biomeKey;
    private final float[][] temperature;
    private final float[][] humidity;
    private final float[][] pressure;
    private final WindVector[] wind;

    public BiomeForecastSnapshot(BiomeInstanceKey biomeKey, @Nullable float[][] temperature, @Nullable float[][] humidity, @Nullable float[][] pressure, @Nullable WindVector[] wind) {
        this.biomeKey = biomeKey;
        this.temperature = BiomeForecastSnapshot.copy2d(temperature);
        this.humidity = BiomeForecastSnapshot.copy2d(humidity);
        this.pressure = BiomeForecastSnapshot.copy2d(pressure);
        this.wind = BiomeForecastSnapshot.copyWind(wind);
    }

    public BiomeInstanceKey biomeKey() {
        return this.biomeKey;
    }

    @Nullable
    public float[][] temperatureCurve() {
        return BiomeForecastSnapshot.copy2d(this.temperature);
    }

    @Nullable
    public float[][] humidityCurve() {
        return BiomeForecastSnapshot.copy2d(this.humidity);
    }

    @Nullable
    public float[][] pressureCurve() {
        return BiomeForecastSnapshot.copy2d(this.pressure);
    }

    @Nullable
    public WindVector[] windCurve() {
        return BiomeForecastSnapshot.copyWind(this.wind);
    }

    public static BiomeForecastSnapshot from(BiomeForecast forecast) {
        if (forecast == null || forecast.getBiomeKey() == null) {
            throw new IllegalArgumentException("BiomeForecastSnapshot requires a forecast with a biome key");
        }
        return new BiomeForecastSnapshot(forecast.getBiomeKey(), forecast.getTemperature(), forecast.getHumidity(), forecast.getPressure(), forecast.getWind());
    }

    private static float[][] copy2d(@Nullable float[][] src) {
        if (src == null) {
            return null;
        }
        float[][] copy = new float[src.length][];
        for (int i = 0; i < src.length; ++i) {
            copy[i] = src[i] == null ? null : Arrays.copyOf(src[i], src[i].length);
        }
        return copy;
    }

    private static WindVector[] copyWind(@Nullable WindVector[] src) {
        if (src == null) {
            return null;
        }
        return Arrays.copyOf(src, src.length);
    }
}

