/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.region;

import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.region.ForecastRegion;
import net.Gabou.projectatmosphere.modules.region.RegionCurves;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public final class DefaultRegionCurves
implements RegionCurves {
    private final float[][] temperatureWeek;
    private final float[][] humidityWeek;
    private final float[][] pressureWeek;
    private final WindVector[] windWeek;
    private final float[] stormWeek;

    public DefaultRegionCurves(float[][] temperatureWeek, float[][] humidityWeek, float[][] pressureWeek, WindVector[] windWeek, float[] stormWeek) {
        this.temperatureWeek = temperatureWeek;
        this.humidityWeek = humidityWeek;
        this.pressureWeek = pressureWeek;
        this.windWeek = windWeek;
        this.stormWeek = stormWeek;
    }

    @Override
    public float[][] temperatureWeek() {
        return this.temperatureWeek;
    }

    @Override
    public float[][] humidityWeek() {
        return this.humidityWeek;
    }

    @Override
    public float[][] pressureWeek() {
        return this.pressureWeek;
    }

    @Override
    public WindVector[] windWeek() {
        return this.windWeek;
    }

    @Override
    public float[] stormWeek() {
        return this.stormWeek;
    }

    @Override
    public float sampleTemperature(Vec3 inRegionPos, long gameTime, ForecastRegion.Section[] sections) {
        return DefaultRegionCurves.sampleTwoColumn(this.temperatureWeek, gameTime);
    }

    @Override
    public float sampleHumidity(Vec3 inRegionPos, long gameTime, ForecastRegion.Section[] sections) {
        return DefaultRegionCurves.sampleTwoColumn(this.humidityWeek, gameTime);
    }

    @Override
    public float samplePressure(long gameTime, ForecastRegion.Section[] sections) {
        return DefaultRegionCurves.sampleTwoColumn(this.pressureWeek, gameTime);
    }

    @Override
    public WindVector sampleWind(long gameTime, ForecastRegion.Section[] sections) {
        if (this.windWeek == null || this.windWeek.length == 0) {
            return WindVector.fromBase(0.0f, 0.0f);
        }
        int day = DefaultRegionCurves.currentDay(gameTime, this.windWeek.length);
        return this.windWeek[day] == null ? WindVector.fromBase(0.0f, 0.0f) : this.windWeek[day];
    }

    @Override
    public float sampleStorm(long gameTime, ForecastRegion.Section[] sections) {
        if (this.stormWeek == null || this.stormWeek.length == 0) {
            return 0.0f;
        }
        return this.stormWeek[DefaultRegionCurves.currentDay(gameTime, this.stormWeek.length)];
    }

    private static float sampleTwoColumn(float[][] week, long gameTime) {
        if (week == null || week.length == 0) {
            return 0.0f;
        }
        int day = DefaultRegionCurves.currentDay(gameTime, week.length);
        float[] dayProfile = week[day];
        if (dayProfile == null || dayProfile.length < 2) {
            return 0.0f;
        }
        float dayTimeFraction = DefaultRegionCurves.fractionOfDay(gameTime);
        return Mth.m_14179_((float)dayTimeFraction, (float)dayProfile[0], (float)dayProfile[1]);
    }

    private static int currentDay(long gameTime, int length) {
        long day = gameTime / 24000L % (long)length;
        return (int)day;
    }

    private static float fractionOfDay(long gameTime) {
        long ticksInDay = gameTime % 24000L;
        return (float)ticksInDay / 24000.0f;
    }
}

