/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.region;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.region.BiomeFallbackSnapshot;
import net.Gabou.projectatmosphere.modules.region.BiomeForecastSnapshot;
import net.Gabou.projectatmosphere.modules.region.ForecastRegion;
import net.Gabou.projectatmosphere.modules.region.RegionPersistence;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.Gabou.projectatmosphere.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public final class FileRegionPersistence
implements RegionPersistence {
    private static final String FOLDER = "region_fallbacks";
    private final ServerLevel level;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public FileRegionPersistence(ServerLevel level) {
        this.level = level;
    }

    @Override
    public Optional<BiomeFallbackSnapshot> loadFallback(RegionInstanceKey id) {
        Optional<BiomeFallbackSnapshot> optional;
        block14: {
            Path path = this.pathFor(id);
            if (!Files.exists(path, new LinkOption[0])) {
                return Optional.empty();
            }
            BufferedReader r = Files.newBufferedReader(path);
            try {
                JsonObject root = (JsonObject)this.gson.fromJson((Reader)r, JsonObject.class);
                ArrayList<BiomeInstanceKey> sourceBiomes = new ArrayList<BiomeInstanceKey>();
                JsonArray biomesArr = root.getAsJsonArray("biomes");
                if (biomesArr != null) {
                    for (JsonElement el : biomesArr) {
                        JsonObject obj = el.getAsJsonObject();
                        ResourceLocation biome = ResourceLocation.parse((String)obj.get("id").getAsString());
                        BlockPos pos = AtmosphereUtils.deserializeBlockPos(obj.get("pos").getAsJsonObject());
                        sourceBiomes.add(new BiomeInstanceKey(biome, pos));
                    }
                }
                ForecastRegion.Section[] sections = new ForecastRegion.Section[8];
                JsonArray sectionsArr = root.getAsJsonArray("sections");
                for (int i = 0; i < sections.length; ++i) {
                    if (sectionsArr == null || i >= sectionsArr.size()) {
                        sections[i] = new ForecastRegion.Section(0.0f, null);
                        continue;
                    }
                    JsonObject obj = sectionsArr.get(i).getAsJsonObject();
                    float factor = obj.get("factor").getAsFloat();
                    BiomeForecastSnapshot snapshot = null;
                    if (obj.has("biome")) {
                        JsonObject biomeObj = obj.getAsJsonObject("biome");
                        ResourceLocation biome = ResourceLocation.parse((String)biomeObj.get("id").getAsString());
                        BlockPos pos = AtmosphereUtils.deserializeBlockPos(biomeObj.get("pos").getAsJsonObject());
                        BiomeInstanceKey key = new BiomeInstanceKey(biome, pos);
                        float[][] temp = FileRegionPersistence.deserialize2d(obj.getAsJsonArray("temperature"));
                        float[][] hum = FileRegionPersistence.deserialize2d(obj.getAsJsonArray("humidity"));
                        float[][] pressure = FileRegionPersistence.deserialize2d(obj.getAsJsonArray("pressure"));
                        WindVector[] wind = FileRegionPersistence.deserializeWindWeek(obj.getAsJsonArray("wind"));
                        snapshot = new BiomeForecastSnapshot(key, temp, hum, pressure, wind);
                    }
                    sections[i] = new ForecastRegion.Section(factor, snapshot);
                }
                BiomeFallbackSnapshot fb = new BiomeFallbackSnapshot(id, sourceBiomes, sections);
                optional = Optional.of(fb);
                if (r == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            ((Reader)r).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            ((Reader)r).close();
        }
        return optional;
    }

    @Override
    public BiomeFallbackSnapshot saveFallback(RegionInstanceKey id, ForecastRegion.Section[] sections, List<BiomeInstanceKey> sourceBiomes) {
        JsonObject root = new JsonObject();
        root.addProperty("rx", (Number)id.regionX());
        root.addProperty("rz", (Number)id.regionZ());
        JsonArray biomesArr = new JsonArray();
        for (BiomeInstanceKey biomeInstanceKey : sourceBiomes) {
            JsonObject obj = new JsonObject();
            obj.addProperty("id", biomeInstanceKey.biomeType().toString());
            obj.add("pos", (JsonElement)AtmosphereUtils.serializeBlockPos(biomeInstanceKey.samplePos()));
            biomesArr.add((JsonElement)obj);
        }
        root.add("biomes", (JsonElement)biomesArr);
        JsonArray sectionsArr = new JsonArray();
        for (ForecastRegion.Section section : sections) {
            JsonObject obj = new JsonObject();
            obj.addProperty("factor", (Number)Float.valueOf(section.factor()));
            BiomeForecastSnapshot snap = section.snapshot();
            if (snap != null) {
                JsonObject biomeObj = new JsonObject();
                biomeObj.addProperty("id", snap.biomeKey().biomeType().toString());
                biomeObj.add("pos", (JsonElement)AtmosphereUtils.serializeBlockPos(snap.biomeKey().samplePos()));
                obj.add("biome", (JsonElement)biomeObj);
                obj.add("temperature", (JsonElement)FileRegionPersistence.serialize2d(snap.temperatureCurve()));
                obj.add("humidity", (JsonElement)FileRegionPersistence.serialize2d(snap.humidityCurve()));
                obj.add("pressure", (JsonElement)FileRegionPersistence.serialize2d(snap.pressureCurve()));
                obj.add("wind", (JsonElement)FileRegionPersistence.serializeWindWeek(snap.windCurve()));
            }
            sectionsArr.add((JsonElement)obj);
        }
        root.add("sections", (JsonElement)sectionsArr);
        Path path = this.pathFor(id);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
                this.gson.toJson((JsonElement)root, (Appendable)w);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new BiomeFallbackSnapshot(id, Collections.unmodifiableList(sourceBiomes), sections);
    }

    private Path pathFor(RegionInstanceKey id) {
        String fileName = "region_fallbacks/" + id.regionX() + "_" + id.regionZ() + "_" + id.regionSize() + ".json";
        return StorageUtils.getPerWorldSavePath(this.level, fileName);
    }

    private static JsonArray serialize2d(float[][] data) {
        JsonArray arr = new JsonArray();
        if (data == null) {
            return arr;
        }
        for (float[] row : data) {
            JsonArray rowArr = new JsonArray();
            if (row != null) {
                for (float v : row) {
                    rowArr.add((Number)Float.valueOf(v));
                }
            }
            arr.add((JsonElement)rowArr);
        }
        return arr;
    }

    private static float[][] deserialize2d(JsonArray arr) {
        if (arr == null) {
            return null;
        }
        float[][] out = new float[arr.size()][];
        for (int i = 0; i < arr.size(); ++i) {
            JsonArray rowArr = arr.get(i).getAsJsonArray();
            float[] row = new float[rowArr.size()];
            for (int j = 0; j < rowArr.size(); ++j) {
                row[j] = rowArr.get(j).getAsFloat();
            }
            out[i] = row;
        }
        return out;
    }

    private static JsonArray serializeWindWeek(WindVector[] week) {
        JsonArray arr = new JsonArray();
        if (week == null) {
            return arr;
        }
        for (WindVector w : week) {
            JsonObject obj = new JsonObject();
            if (w != null) {
                obj.addProperty("base", (Number)Float.valueOf(w.baseSpeed()));
                obj.addProperty("angle", (Number)Float.valueOf(w.angleRadians()));
                obj.addProperty("gust", (Number)Float.valueOf(w.gustSpeed()));
            } else {
                obj.addProperty("base", (Number)Float.valueOf(0.0f));
                obj.addProperty("angle", (Number)Float.valueOf(0.0f));
                obj.addProperty("gust", (Number)Float.valueOf(0.0f));
            }
            arr.add((JsonElement)obj);
        }
        return arr;
    }

    private static WindVector[] deserializeWindWeek(JsonArray arr) {
        if (arr == null) {
            return null;
        }
        WindVector[] week = new WindVector[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            JsonObject obj = arr.get(i).getAsJsonObject();
            float base = obj.has("base") ? obj.get("base").getAsFloat() : 0.0f;
            float angle = obj.has("angle") ? obj.get("angle").getAsFloat() : 0.0f;
            float gust = obj.has("gust") ? obj.get("gust").getAsFloat() : base;
            week[i] = new WindVector(base, angle, gust);
        }
        return week;
    }
}

