/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.region;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.region.BiomeFallbackSnapshot;
import net.Gabou.projectatmosphere.modules.region.BiomeForecastSnapshot;
import net.Gabou.projectatmosphere.modules.region.RegionCurves;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.world.phys.Vec3;

public final class ForecastRegion {
    private final RegionInstanceKey id;
    private final List<BiomeInstanceKey> sourceBiomes;
    private final Section[] sections;
    private final RegionCurves curves;
    private final BiomeFallbackSnapshot fallbackSnapshot;

    public ForecastRegion(RegionInstanceKey id, List<BiomeInstanceKey> sourceBiomes, Section[] sections, RegionCurves curves, BiomeFallbackSnapshot fallbackSnapshot) {
        this.id = id;
        this.sourceBiomes = List.copyOf(sourceBiomes);
        this.sections = (Section[])sections.clone();
        this.curves = curves;
        this.fallbackSnapshot = fallbackSnapshot;
    }

    public RegionInstanceKey id() {
        return this.id;
    }

    public RegionCurves curves() {
        return this.curves;
    }

    public BiomeFallbackSnapshot fallbackSnapshot() {
        return this.fallbackSnapshot;
    }

    public List<BiomeInstanceKey> sourceBiomes() {
        return this.sourceBiomes;
    }

    public Section[] sections() {
        return (Section[])this.sections.clone();
    }

    public float sampleTemperature(Vec3 inRegionPos, long gameTime) {
        return this.curves.sampleTemperature(inRegionPos, gameTime, this.sections);
    }

    public float sampleHumidity(Vec3 inRegionPos, long gameTime) {
        return this.curves.sampleHumidity(inRegionPos, gameTime, this.sections);
    }

    public float samplePressure(long gameTime) {
        return this.curves.samplePressure(gameTime, this.sections);
    }

    public WindVector sampleWind(long gameTime) {
        return this.curves.sampleWind(gameTime, this.sections);
    }

    public float sampleStorm(long gameTime) {
        return this.curves.sampleStorm(gameTime, this.sections);
    }

    public void clearBiomeForecasts() {
        for (Section s : this.sections) {
            s.clearSnapshot();
        }
    }

    public String toString() {
        return "ForecastRegion{id=" + String.valueOf(this.id) + ", sourceBiomes=" + this.sourceBiomes.size() + ", sections=" + Arrays.toString(this.sections) + "}";
    }

    public static final class Section {
        private final float factor;
        private BiomeForecastSnapshot snapshot;

        public Section(float factor, @Nullable BiomeForecastSnapshot snapshot) {
            this.factor = factor;
            this.snapshot = snapshot;
        }

        public float factor() {
            return this.factor;
        }

        @Nullable
        public BiomeForecastSnapshot snapshot() {
            return this.snapshot;
        }

        public void clearSnapshot() {
            this.snapshot = null;
        }
    }
}

