/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.region;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.region.RegionIndex;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public final class GridRegionIndex
implements RegionIndex {
    private final int regionSize;
    private final Map<RegionInstanceKey, List<BiomeInstanceKey>> cache = new ConcurrentHashMap<RegionInstanceKey, List<BiomeInstanceKey>>();

    public GridRegionIndex() {
        this(2000);
    }

    public GridRegionIndex(int regionSize) {
        this.regionSize = regionSize;
    }

    @Override
    public RegionInstanceKey regionFor(BlockPos pos, ResourceKey<Level> dimension) {
        return RegionInstanceKey.from(pos, this.regionSize);
    }

    @Override
    public List<BiomeInstanceKey> biomesFor(RegionInstanceKey id) {
        return this.cache.computeIfAbsent(id, this::buildBiomesFor);
    }

    private List<BiomeInstanceKey> buildBiomesFor(RegionInstanceKey legacy) {
        ArrayList<BiomeInstanceKey> result = new ArrayList<BiomeInstanceKey>();
        for (BiomeInstanceKey key : ForecastGenerator.getBiomeSamples()) {
            if (!legacy.contains(key.samplePos())) continue;
            result.add(key);
        }
        return Collections.unmodifiableList(result);
    }
}

