/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.region;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.region.BiomeFallbackSnapshot;
import net.Gabou.projectatmosphere.modules.region.BiomeForecastGenerator;
import net.Gabou.projectatmosphere.modules.region.BiomeForecastSnapshot;
import net.Gabou.projectatmosphere.modules.region.DefaultRegionCurves;
import net.Gabou.projectatmosphere.modules.region.ForecastRegion;
import net.Gabou.projectatmosphere.modules.region.RegionCurves;
import net.Gabou.projectatmosphere.modules.region.RegionIndex;
import net.Gabou.projectatmosphere.modules.region.RegionPersistence;
import net.Gabou.projectatmosphere.modules.region.WeightedCurve;
import net.Gabou.projectatmosphere.modules.region.WeightedWindCurve;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class RegionForecastOrchestrator {
    private final RegionIndex regionIndex;
    private final RegionPersistence persistence;
    private final BiomeForecastGenerator biomeGenerator;
    private final Map<RegionInstanceKey, ForecastRegion> regions = new ConcurrentHashMap<RegionInstanceKey, ForecastRegion>();

    public RegionForecastOrchestrator(RegionIndex regionIndex, RegionPersistence persistence, BiomeForecastGenerator biomeGenerator) {
        this.regionIndex = regionIndex;
        this.persistence = persistence;
        this.biomeGenerator = biomeGenerator;
    }

    public ForecastRegion resolve(BlockPos pos, ResourceKey<Level> dimension) {
        RegionInstanceKey id = this.regionIndex.regionFor(pos, dimension);
        return this.ensureLoaded(id);
    }

    public ForecastRegion ensureLoaded(RegionInstanceKey id) {
        return this.regions.computeIfAbsent(id, this::loadOrGenerate);
    }

    private ForecastRegion loadOrGenerate(RegionInstanceKey id) {
        Optional<BiomeFallbackSnapshot> fb = this.persistence.loadFallback(id);
        if (fb.isPresent()) {
            return this.fromFallback(fb.get());
        }
        return this.generateFromBiomes(id);
    }

    private ForecastRegion fromFallback(BiomeFallbackSnapshot fb) {
        ForecastRegion.Section[] sections = fb.toSections();
        RegionCurves curves = this.aggregateSections(sections);
        ForecastRegion region = new ForecastRegion(fb.id(), fb.sourceBiomes(), sections, curves, fb);
        region.clearBiomeForecasts();
        return region;
    }

    private ForecastRegion generateFromBiomes(RegionInstanceKey id) {
        List<BiomeInstanceKey> biomes = this.regionIndex.biomesFor(id);
        ForecastRegion.Section[] sections = this.sliceIntoEight(biomes);
        RegionCurves curves = this.aggregateSections(sections);
        BiomeFallbackSnapshot fb = this.persistence.saveFallback(id, sections, biomes);
        ForecastRegion region = new ForecastRegion(id, biomes, sections, curves, fb);
        region.clearBiomeForecasts();
        return region;
    }

    public void tick(long gameTime) {
    }

    private RegionCurves aggregateSections(ForecastRegion.Section[] sections) {
        WeightedCurve temperature = WeightedCurve.empty();
        WeightedCurve humidity = WeightedCurve.empty();
        WeightedCurve pressure = WeightedCurve.empty();
        WeightedCurve storm = WeightedCurve.empty();
        WeightedWindCurve wind = WeightedWindCurve.empty();
        for (ForecastRegion.Section section : sections) {
            BiomeForecastSnapshot snapshot = section.snapshot();
            if (snapshot == null) continue;
            temperature.add(section.factor(), snapshot.temperatureCurve());
            humidity.add(section.factor(), snapshot.humidityCurve());
            pressure.add(section.factor(), snapshot.pressureCurve());
            wind.add(section.factor(), snapshot.windCurve());
        }
        float[][] tempWeek = temperature.normalize();
        float[][] humidityWeek = humidity.normalize();
        float[][] pressureWeek = pressure.normalize();
        WindVector[] windWeek = wind.normalize();
        float[] stormWeek = RegionForecastOrchestrator.flattenTwoColumn(storm.normalize());
        return new DefaultRegionCurves(tempWeek, humidityWeek, pressureWeek, windWeek, stormWeek);
    }

    private ForecastRegion.Section[] sliceIntoEight(List<BiomeInstanceKey> biomes) {
        ForecastRegion.Section[] out = new ForecastRegion.Section[8];
        for (int i = 0; i < out.length; ++i) {
            BiomeForecastSnapshot snap = this.biomeGenerator.generateSlice(biomes, i);
            float factor = Math.max(0.0f, this.biomeGenerator.factorForSlice(biomes, i));
            out[i] = new ForecastRegion.Section(factor, snap);
        }
        return out;
    }

    private static float[] flattenTwoColumn(float[][] curve) {
        if (curve == null || curve.length == 0) {
            return new float[0];
        }
        float[] result = new float[curve.length];
        for (int i = 0; i < curve.length; ++i) {
            float[] row = curve[i];
            result[i] = row == null || row.length == 0 ? 0.0f : row[0];
        }
        return result;
    }

    public Vec3 toRegionLocal(BlockPos pos) {
        RegionInstanceKey rik = RegionInstanceKey.from(pos);
        int minX = rik.regionX() * rik.regionSize();
        int minZ = rik.regionZ() * rik.regionSize();
        return new Vec3((double)(pos.m_123341_() - minX), (double)pos.m_123342_(), (double)(pos.m_123343_() - minZ));
    }
}

