/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.region;

import java.util.List;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.region.BiomeForecastGenerator;
import net.Gabou.projectatmosphere.modules.region.BiomeForecastSnapshot;
import net.Gabou.projectatmosphere.modules.region.FileRegionPersistence;
import net.Gabou.projectatmosphere.modules.region.GridRegionIndex;
import net.Gabou.projectatmosphere.modules.region.RegionForecastOrchestrator;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.server.level.ServerLevel;

public final class RegionOrchestratorBootstrap {
    private RegionOrchestratorBootstrap() {
    }

    public static RegionForecastOrchestrator bootstrap(ServerLevel level) {
        GridRegionIndex index = new GridRegionIndex();
        FileRegionPersistence persistence = new FileRegionPersistence(level);
        BiomeForecastGenerator generator = new BiomeForecastGenerator(){

            @Override
            public BiomeForecastSnapshot generateSlice(List<BiomeInstanceKey> biomes, int sliceIndex) {
                if (biomes == null || biomes.isEmpty()) {
                    return null;
                }
                BiomeInstanceKey key = biomes.get(sliceIndex % biomes.size());
                BiomeForecast forecast = ForecastGenerator.getForecastMap().get(key);
                if (forecast == null) {
                    return null;
                }
                return BiomeForecastSnapshot.from(forecast);
            }

            @Override
            public float factorForSlice(List<BiomeInstanceKey> biomes, int sliceIndex) {
                return 0.125f;
            }
        };
        return new RegionForecastOrchestrator(index, persistence, generator);
    }
}

