/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.region;

import java.util.ArrayList;
import java.util.List;

public final class WeightedCurve {
    private static final int DAYS = 7;
    private static final int COLS = 2;
    private final List<Entry> entries = new ArrayList<Entry>();

    public static WeightedCurve empty() {
        return new WeightedCurve();
    }

    public void add(float weight, float[][] curve) {
        if (curve == null || weight <= 0.0f) {
            return;
        }
        this.entries.add(new Entry(weight, curve));
    }

    public float[][] normalize() {
        if (this.entries.isEmpty()) {
            return WeightedCurve.flat(0.0f);
        }
        float[][] result = new float[7][2];
        float totalWeight = 0.0f;
        for (Entry entry : this.entries) {
            totalWeight += entry.weight;
            float[][] curve = entry.curve;
            for (int d = 0; d < 7 && d < curve.length; ++d) {
                float[] row = curve[d];
                if (row == null) continue;
                for (int c = 0; c < 2 && c < row.length; ++c) {
                    float[] fArray = result[d];
                    int n = c;
                    fArray[n] = fArray[n] + row[c] * entry.weight;
                }
            }
        }
        if (totalWeight <= 0.0f) {
            return WeightedCurve.flat(0.0f);
        }
        for (int d = 0; d < 7; ++d) {
            int c = 0;
            while (c < 2) {
                float[] fArray = result[d];
                int n = c++;
                fArray[n] = fArray[n] / totalWeight;
            }
        }
        return result;
    }

    private static float[][] flat(float value) {
        float[][] arr = new float[7][2];
        for (int d = 0; d < 7; ++d) {
            arr[d][0] = value;
            arr[d][1] = value;
        }
        return arr;
    }

    private record Entry(float weight, float[][] curve) {
    }
}

