/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.region;

import java.util.ArrayList;
import java.util.List;
import net.Gabou.projectatmosphere.modules.core.WindVector;

public final class WeightedWindCurve {
    private static final int DAYS = 7;
    private final List<Entry> entries = new ArrayList<Entry>();

    public static WeightedWindCurve empty() {
        return new WeightedWindCurve();
    }

    public void add(float weight, WindVector[] curve) {
        if (curve == null || weight <= 0.0f) {
            return;
        }
        this.entries.add(new Entry(weight, curve));
    }

    public WindVector[] normalize() {
        WindVector[] result = new WindVector[7];
        if (this.entries.isEmpty()) {
            for (int i = 0; i < 7; ++i) {
                result[i] = WindVector.fromBase(0.0f, 0.0f);
            }
            return result;
        }
        for (int day = 0; day < 7; ++day) {
            float sumX = 0.0f;
            float sumZ = 0.0f;
            float sumGust = 0.0f;
            float weightSum = 0.0f;
            for (Entry entry : this.entries) {
                WindVector[] curve = entry.curve();
                if (curve.length <= day || curve[day] == null) continue;
                WindVector wind = curve[day];
                float angle = wind.angleRadians();
                float speed = wind.baseSpeed();
                sumX += speed * (float)Math.cos(angle) * entry.weight();
                sumZ += speed * (float)Math.sin(angle) * entry.weight();
                sumGust += wind.gustSpeed() * entry.weight();
                weightSum += entry.weight();
            }
            if (weightSum <= 0.0f) {
                result[day] = WindVector.fromBase(0.0f, 0.0f);
                continue;
            }
            float avgX = sumX / weightSum;
            float avgZ = sumZ / weightSum;
            float avgSpeed = (float)Math.sqrt(avgX * avgX + avgZ * avgZ);
            float avgAngle = (float)Math.atan2(avgZ, avgX);
            float avgGust = sumGust / weightSum;
            result[day] = new WindVector(avgSpeed, avgAngle, avgGust);
        }
        return result;
    }

    private record Entry(float weight, WindVector[] curve) {
    }
}

