/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.temperature.command;

import java.util.Map;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.temperature.compat.SereneTempToCelcius;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.UnitFormatter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonHandler;
import sereneseasons.season.SeasonHooks;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

public class TemperatureCommandHelper {
    public static BiomeInstanceKey getCurrentBiome(Player player) {
        return new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(player.m_20183_(), player.m_9236_()), player.m_20183_());
    }

    public static ResourceLocation getCurrentBiomeResourceLocation(Player player) {
        return AtmosphereUtils.getBiomeLocation(player.m_20183_(), player.m_9236_());
    }

    public static BiomeInstanceKey resolveBiome(Player player, String biomeStr) {
        if (biomeStr.equalsIgnoreCase("current") || biomeStr.equalsIgnoreCase("currentbiome")) {
            return TemperatureCommandHelper.getCurrentBiome(player);
        }
        try {
            return new BiomeInstanceKey(ResourceLocation.parse((String)biomeStr), player.m_20183_());
        }
        catch (Exception e) {
            ProjectAtmosphere.LOGGER.error("Invalid biome name: {}", (Object)biomeStr);
            return null;
        }
    }

    public static long getCurrentTick(ServerLevel level) {
        return level.m_46468_() % 24000L;
    }

    public static float getTemperatureAt(BiomeInstanceKey biome, long tick) {
        return ForecastOrchestrator.getCurrentTemperature(biome, tick);
    }

    public static String getWeeklyForecast(ResourceLocation biome) {
        return TemperatureCommandHelper.weekForecastToString(biome, ForecastGenerator.getAverageForecast(biome).getTemperature());
    }

    public static float[] getDayProfile(BiomeInstanceKey biome) {
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(biome);
        if (state == null) {
            return new float[0];
        }
        return state.getDailyTemperatureProfile();
    }

    public static String getCurrentSubSeason(ServerLevel level) {
        SeasonSavedData data = SeasonHandler.getSeasonSavedData((Level)level);
        SeasonTime time = new SeasonTime(data.seasonCycleTicks);
        return time.getSubSeason().toString();
    }

    public static float getFinalBiomeTemperature(Level level, Holder<Biome> biomeHolder, BlockPos pos) {
        return ModConfig.seasons.isDimensionWhitelisted(level.m_46472_()) && !biomeHolder.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES) ? SeasonHooks.getBiomeTemperature((Level)level, biomeHolder, (BlockPos)pos) : ((Biome)biomeHolder.m_203334_()).m_47554_();
    }

    public static double convertToCelsius(float sereneTemp) {
        return SereneTempToCelcius.SereneTempToCelcius(sereneTemp);
    }

    public static float getRealTemperature(ServerLevel level, BiomeInstanceKey biome, BlockPos pos) {
        return ForecastOrchestrator.getCurrentTemperature(biome, level.m_46468_());
    }

    public static String formatForecastMap(Map<ResourceLocation, float[][]> forecastMap) {
        StringBuilder sb = new StringBuilder("[Temperature Forecast per Biome]");
        for (Map.Entry<ResourceLocation, float[][]> entry : forecastMap.entrySet()) {
            ResourceLocation key = entry.getKey();
            float[][] week = entry.getValue();
            sb.append(TemperatureCommandHelper.weekForecastToString(key, week));
        }
        return sb.toString();
    }

    private static String weekForecastToString(ResourceLocation biome, float[][] week) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(biome).append(":");
        for (int day = 0; day < week.length; ++day) {
            sb.append("\n  Day ").append(day + 1).append(": ");
            float[] profile = week[day];
            for (int i = 0; i < profile.length; ++i) {
                sb.append(UnitFormatter.formatTemperature(profile[i]));
                if (i >= profile.length - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public static boolean isInOverworld(Level level) {
        return level.m_46472_().equals((Object)Level.f_46428_);
    }
}

