/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.temperature.config;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeTempConfig {
    public static final Map<Season, Map<ResourceLocation, Range>> SEASON_RANGES = new EnumMap<Season, Map<ResourceLocation, Range>>(Season.class);
    public static final Map<Season, Map<ResourceLocation, DailyRange>> SEASON_CLAMPS = new EnumMap<Season, Map<ResourceLocation, DailyRange>>(Season.class);

    private static void putAllSeasons(String biomeKey, Range[] ranges) {
        Set<ResourceLocation> ids = BiomeTempConfig.resolveBiomeIds(biomeKey);
        Season[] seasons = Season.values();
        for (ResourceLocation id : ids) {
            for (int i = 0; i < seasons.length; ++i) {
                Season season = seasons[i];
                Range r = ranges[i];
                SEASON_RANGES.get((Object)season).put(id, r);
                SEASON_CLAMPS.get((Object)season).put(id, BiomeTempConfig.deriveDaily(r));
            }
        }
    }

    private static void mirrorBiome(String dstKey, String srcKey) {
        Set<ResourceLocation> dsts = BiomeTempConfig.resolveBiomeIds(dstKey);
        Set<ResourceLocation> srcs = BiomeTempConfig.resolveBiomeIds(srcKey);
        if (srcs.isEmpty()) {
            ProjectAtmosphere.LOGGER.warn("mirrorBiome: no source biome resolved for '{}'", (Object)srcKey);
            return;
        }
        ResourceLocation src = srcs.iterator().next();
        for (Season s : Season.values()) {
            Range r = SEASON_RANGES.get((Object)s).get(src);
            DailyRange d = SEASON_CLAMPS.get((Object)s).get(src);
            if (r == null || d == null) {
                ProjectAtmosphere.LOGGER.warn("mirrorBiome: source '{}' has no ranges for season {}", (Object)src, (Object)s);
                continue;
            }
            for (ResourceLocation dst : dsts) {
                SEASON_RANGES.get((Object)s).put(dst, r);
                SEASON_CLAMPS.get((Object)s).put(dst, d);
            }
        }
    }

    private static void putConstSeasons(String biomeKey, Range r, DailyRange d) {
        Set<ResourceLocation> ids = BiomeTempConfig.resolveBiomeIds(biomeKey);
        for (ResourceLocation id : ids) {
            for (Season s : Season.values()) {
                SEASON_RANGES.get((Object)s).put(id, r);
                SEASON_CLAMPS.get((Object)s).put(id, d);
            }
        }
    }

    private static Set<ResourceLocation> resolveBiomeIds(String biomeKey) {
        if (biomeKey.indexOf(58) >= 0) {
            ResourceLocation parsed = ResourceLocation.m_135820_((String)biomeKey);
            if (parsed != null) {
                return Set.of(parsed);
            }
            ProjectAtmosphere.LOGGER.warn("Invalid biome id '{}'", (Object)biomeKey);
            return Set.of();
        }
        ProjectAtmosphere.LOGGER.warn("Biome key '{}' is missing a namespace; assuming minecraft:{} when unique. Prefer explicit ids such as minecraft:desert or biomesoplenty:bayou to avoid ambiguity.", (Object)biomeKey, (Object)biomeKey);
        ResourceLocation def = ResourceLocation.withDefaultNamespace((String)biomeKey);
        if (ForgeRegistries.BIOMES.containsKey(def)) {
            return Set.of(def);
        }
        LinkedHashSet<ResourceLocation> matches = new LinkedHashSet<ResourceLocation>();
        for (ResourceLocation key : ForgeRegistries.BIOMES.getKeys()) {
            if (!key.m_135815_().equals(biomeKey)) continue;
            matches.add(key);
        }
        if (matches.isEmpty()) {
            if (ProjectAtmosphere.DEBUG_MODE) {
                ProjectAtmosphere.LOGGER.warn("No biome found with path '{}' in registry; defaulting to {}", (Object)biomeKey, (Object)def);
            }
            return Set.of(def);
        }
        if (matches.size() > 1 && ProjectAtmosphere.DEBUG_MODE) {
            ProjectAtmosphere.LOGGER.warn("Multiple biomes match path '{}': {}", (Object)biomeKey, matches);
        }
        return matches;
    }

    public static DailyRange deriveDaily(Range r) {
        float span = r.maxC - r.minC;
        float minMin = r.minC - 0.1f * span;
        float avgNight = r.minC + 0.25f * span;
        float avgDay = r.minC + 0.75f * span;
        float maxMax = r.maxC + 0.1f * span;
        return new DailyRange(minMin, avgNight, avgDay, maxMax);
    }

    public static Range getRange(ResourceLocation biome, Season season) {
        if (!SEASON_RANGES.getOrDefault((Object)season, Map.of()).containsKey(biome)) {
            ProjectAtmosphere.LOGGER.warn("\u274c No temperature range defined for biome {}", (Object)biome);
        }
        return SEASON_RANGES.getOrDefault((Object)season, Map.of()).getOrDefault(biome, new Range(0.0f, 0.0f));
    }

    public static DailyRange getClamp(ResourceLocation biome, Season season) {
        return SEASON_CLAMPS.getOrDefault((Object)season, Map.of()).getOrDefault(biome, new DailyRange(0.0f, 0.0f, 0.0f, 0.0f));
    }

    /*
     * Opcode count of 19453 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        for (Season s : Season.values()) {
            SEASON_RANGES.put(s, new HashMap());
            SEASON_CLAMPS.put(s, new HashMap());
        }
        BiomeTempConfig.putAllSeasons("plains", new Range[]{new Range(-20.0f, 5.0f), new Range(-10.0f, 18.0f), new Range(15.0f, 36.0f), new Range(-6.0f, 18.0f)});
        BiomeTempConfig.mirrorBiome("sunflower_plains", "plains");
        BiomeTempConfig.putAllSeasons("forest", new Range[]{new Range(-18.0f, 5.0f), new Range(-7.0f, 13.0f), new Range(7.0f, 28.0f), new Range(-2.0f, 19.0f)});
        BiomeTempConfig.mirrorBiome("flower_forest", "forest");
        BiomeTempConfig.mirrorBiome("birch_forest", "forest");
        BiomeTempConfig.mirrorBiome("old_growth_birch_forest", "forest");
        BiomeTempConfig.putAllSeasons("dark_forest", new Range[]{new Range(-22.0f, 3.0f), new Range(-12.0f, 11.0f), new Range(8.0f, 24.0f), new Range(-9.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("beach", new Range[]{new Range(-2.0f, 8.0f), new Range(2.0f, 14.0f), new Range(15.0f, 30.0f), new Range(5.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("cherry_grove", new Range[]{new Range(-12.0f, 2.0f), new Range(-1.0f, 14.0f), new Range(8.0f, 28.0f), new Range(4.0f, 21.0f)});
        BiomeTempConfig.putAllSeasons("swamp", new Range[]{new Range(-5.0f, 10.0f), new Range(10.0f, 22.0f), new Range(20.0f, 35.0f), new Range(10.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("meadow", new Range[]{new Range(-12.0f, 3.0f), new Range(2.0f, 14.0f), new Range(15.0f, 26.0f), new Range(2.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("taiga", new Range[]{new Range(-25.0f, -5.0f), new Range(-5.0f, 10.0f), new Range(10.0f, 22.0f), new Range(-5.0f, 10.0f)});
        BiomeTempConfig.mirrorBiome("old_growth_spruce_taiga", "taiga");
        BiomeTempConfig.mirrorBiome("old_growth_pine_taiga", "taiga");
        BiomeTempConfig.mirrorBiome("snowy_taiga", "taiga");
        BiomeTempConfig.putAllSeasons("snowy_plains", new Range[]{new Range(-35.0f, -10.0f), new Range(-15.0f, 5.0f), new Range(5.0f, 15.0f), new Range(-15.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("ice_spikes", new Range[]{new Range(-50.0f, -30.0f), new Range(-30.0f, -5.0f), new Range(-5.0f, 5.0f), new Range(-30.0f, 0.0f)});
        BiomeTempConfig.mirrorBiome("snowy_slopes", "snowy_plains");
        BiomeTempConfig.putAllSeasons("frozen_peaks", new Range[]{new Range(-45.0f, -25.0f), new Range(-25.0f, -10.0f), new Range(-10.0f, 0.0f), new Range(-25.0f, -5.0f)});
        BiomeTempConfig.putAllSeasons("jungle", new Range[]{new Range(20.0f, 25.0f), new Range(22.0f, 30.0f), new Range(25.0f, 35.0f), new Range(22.0f, 30.0f)});
        BiomeTempConfig.mirrorBiome("sparse_jungle", "jungle");
        BiomeTempConfig.mirrorBiome("bamboo_jungle", "jungle");
        BiomeTempConfig.putAllSeasons("desert", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 35.0f), new Range(30.0f, 45.0f), new Range(15.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("badlands", new Range[]{new Range(0.0f, 20.0f), new Range(10.0f, 30.0f), new Range(25.0f, 40.0f), new Range(10.0f, 30.0f)});
        BiomeTempConfig.mirrorBiome("wooded_badlands", "badlands");
        BiomeTempConfig.mirrorBiome("eroded_badlands", "badlands");
        BiomeTempConfig.putAllSeasons("savanna", new Range[]{new Range(10.0f, 25.0f), new Range(15.0f, 30.0f), new Range(20.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.mirrorBiome("windswept_savanna", "savanna");
        BiomeTempConfig.mirrorBiome("mangrove_swamp", "swamp");
        BiomeTempConfig.putAllSeasons("ocean", new Range[]{new Range(0.0f, 10.0f), new Range(5.0f, 15.0f), new Range(10.0f, 20.0f), new Range(5.0f, 15.0f)});
        BiomeTempConfig.mirrorBiome("lukewarm_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("warm_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("cold_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("frozen_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("deep_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("deep_lukewarm_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("deep_warm_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("deep_cold_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("deep_frozen_ocean", "ocean");
        BiomeTempConfig.putAllSeasons("river", new Range[]{new Range(-5.0f, 5.0f), new Range(5.0f, 18.0f), new Range(18.0f, 30.0f), new Range(5.0f, 18.0f)});
        BiomeTempConfig.mirrorBiome("frozen_river", "river");
        BiomeTempConfig.putAllSeasons("mushroom_fields", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 20.0f), new Range(15.0f, 25.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.mirrorBiome("mushroom_field_shore", "mushroom_fields");
        BiomeTempConfig.putAllSeasons("lush_caves", new Range[]{new Range(12.0f, 15.0f), new Range(14.0f, 18.0f), new Range(15.0f, 20.0f), new Range(14.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("dripstone_caves", new Range[]{new Range(8.0f, 12.0f), new Range(10.0f, 15.0f), new Range(10.0f, 15.0f), new Range(10.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("deep_dark", new Range[]{new Range(5.0f, 10.0f), new Range(7.0f, 10.0f), new Range(8.0f, 12.0f), new Range(7.0f, 10.0f)});
        BiomeTempConfig.mirrorBiome("savanna_plateau", "savanna");
        BiomeTempConfig.mirrorBiome("stony_shore", "beach");
        BiomeTempConfig.mirrorBiome("snowy_beach", "beach");
        BiomeTempConfig.mirrorBiome("windswept_gravelly_hills", "taiga");
        BiomeTempConfig.mirrorBiome("windswept_forest", "taiga");
        BiomeTempConfig.mirrorBiome("windswept_hills", "taiga");
        BiomeTempConfig.mirrorBiome("jagged_peaks", "frozen_peaks");
        BiomeTempConfig.mirrorBiome("stony_peaks", "frozen_peaks");
        BiomeTempConfig.mirrorBiome("grove", "snowy_slopes");
        BiomeTempConfig.putConstSeasons("nether_wastes", new Range(45.0f, 50.0f), new DailyRange(40.0f, 45.0f, 47.0f, 52.0f));
        BiomeTempConfig.putConstSeasons("basalt_deltas", new Range(50.0f, 55.0f), new DailyRange(45.0f, 50.0f, 53.0f, 60.0f));
        BiomeTempConfig.putConstSeasons("crimson_forest", new Range(40.0f, 45.0f), new DailyRange(35.0f, 40.0f, 43.0f, 48.0f));
        BiomeTempConfig.putConstSeasons("warped_forest", new Range(30.0f, 40.0f), new DailyRange(25.0f, 32.0f, 35.0f, 45.0f));
        BiomeTempConfig.putConstSeasons("soul_sand_valley", new Range(35.0f, 45.0f), new DailyRange(30.0f, 38.0f, 42.0f, 50.0f));
        BiomeTempConfig.putConstSeasons("the_end", new Range(5.0f, 10.0f), new DailyRange(0.0f, 7.0f, 8.0f, 12.0f));
        BiomeTempConfig.putConstSeasons("end_highlands", new Range(5.0f, 10.0f), new DailyRange(0.0f, 7.0f, 8.0f, 12.0f));
        BiomeTempConfig.putConstSeasons("end_midlands", new Range(5.0f, 10.0f), new DailyRange(0.0f, 7.0f, 8.0f, 12.0f));
        BiomeTempConfig.putConstSeasons("small_end_islands", new Range(0.0f, 5.0f), new DailyRange(-5.0f, 2.0f, 4.0f, 8.0f));
        BiomeTempConfig.putConstSeasons("end_barrens", new Range(0.0f, 5.0f), new DailyRange(-5.0f, 2.0f, 4.0f, 8.0f));
        BiomeTempConfig.putConstSeasons("the_void", new Range(-273.0f, -273.0f), new DailyRange(-273.0f, -273.0f, -273.0f, -273.0f));
        BiomeTempConfig.putAllSeasons("auroral_garden", new Range[]{new Range(-30.0f, 0.0f), new Range(-10.0f, 10.0f), new Range(5.0f, 20.0f), new Range(-5.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("bamboo_grove", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("bayou", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("bog", new Range[]{new Range(-5.0f, 10.0f), new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(5.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("cold_desert", new Range[]{new Range(-20.0f, 5.0f), new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("coniferous_forest", new Range[]{new Range(-5.0f, 10.0f), new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(5.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("crag", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("dead_forest", new Range[]{new Range(-10.0f, 5.0f), new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("dryland", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(30.0f, 45.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("dune_beach", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("field", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("fir_clearing", new Range[]{new Range(-5.0f, 10.0f), new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(5.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("floodplain", new Range[]{new Range(20.0f, 35.0f), new Range(30.0f, 45.0f), new Range(35.0f, 50.0f), new Range(30.0f, 45.0f)});
        BiomeTempConfig.putAllSeasons("forested_field", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("fungal_jungle", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(30.0f, 45.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("grassland", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("highland", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("highland_moor", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("hot_springs", new Range[]{new Range(0.0f, 10.0f), new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(5.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("jacaranda_glade", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("jade_cliffs", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("lavender_field", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("lush_desert", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(30.0f, 45.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("lush_savanna", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(30.0f, 45.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("maple_woods", new Range[]{new Range(-10.0f, 5.0f), new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("marsh", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_forest", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("muskeg", new Range[]{new Range(-20.0f, 5.0f), new Range(-5.0f, 15.0f), new Range(5.0f, 20.0f), new Range(-5.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("mystic_grove", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("old_growth_dead_forest", new Range[]{new Range(-10.0f, 5.0f), new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("old_growth_woodland", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("ominous_woods", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("orchard", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("origin_valley", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("pasture", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("prairie", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("pumpkin_patch", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("rainforest", new Range[]{new Range(20.0f, 35.0f), new Range(30.0f, 45.0f), new Range(35.0f, 50.0f), new Range(30.0f, 45.0f)});
        BiomeTempConfig.putAllSeasons("redwood_forest", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("rocky_rainforest", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(30.0f, 45.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("rocky_shrubland", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("scrubland", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("seasonal_forest", new Range[]{new Range(-10.0f, 5.0f), new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.mirrorBiome("shrubland", "scrubland");
        BiomeTempConfig.putAllSeasons("snowblossom_grove", new Range[]{new Range(-30.0f, 0.0f), new Range(-15.0f, 5.0f), new Range(0.0f, 15.0f), new Range(-15.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("snowy_coniferous_forest", new Range[]{new Range(-30.0f, -5.0f), new Range(-15.0f, 5.0f), new Range(0.0f, 15.0f), new Range(-15.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("snowy_fir_clearing", new Range[]{new Range(-30.0f, -5.0f), new Range(-15.0f, 5.0f), new Range(0.0f, 15.0f), new Range(-15.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("snowy_maple_woods", new Range[]{new Range(-30.0f, -5.0f), new Range(-15.0f, 5.0f), new Range(0.0f, 15.0f), new Range(-15.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("tropics", new Range[]{new Range(20.0f, 35.0f), new Range(30.0f, 45.0f), new Range(35.0f, 50.0f), new Range(30.0f, 45.0f)});
        BiomeTempConfig.putAllSeasons("tundra", new Range[]{new Range(-35.0f, -5.0f), new Range(-20.0f, 5.0f), new Range(0.0f, 15.0f), new Range(-20.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("volcanic_plains", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(30.0f, 45.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("volcano", new Range[]{new Range(25.0f, 40.0f), new Range(35.0f, 50.0f), new Range(40.0f, 60.0f), new Range(35.0f, 50.0f)});
        BiomeTempConfig.putAllSeasons("wasteland", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("wetland", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("woodland", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("aspen_parkland", new Range[]{new Range(-15.0f, 5.0f), new Range(0.0f, 18.0f), new Range(15.0f, 30.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("dunes", new Range[]{new Range(10.0f, 22.0f), new Range(18.0f, 32.0f), new Range(28.0f, 45.0f), new Range(18.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("flourishing_dunes", new Range[]{new Range(12.0f, 25.0f), new Range(20.0f, 35.0f), new Range(28.0f, 42.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("kousa_jungle", new Range[]{new Range(-10.0f, 2.0f), new Range(0.0f, 15.0f), new Range(15.0f, 25.0f), new Range(0.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("laurel_forest", new Range[]{new Range(-2.0f, 8.0f), new Range(5.0f, 18.0f), new Range(15.0f, 30.0f), new Range(5.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("petrified_dunes", new Range[]{new Range(8.0f, 22.0f), new Range(18.0f, 32.0f), new Range(28.0f, 45.0f), new Range(18.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("rainforest", new Range[]{new Range(20.0f, 28.0f), new Range(22.0f, 32.0f), new Range(25.0f, 36.0f), new Range(22.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("rainforest_basin", new Range[]{new Range(21.0f, 29.0f), new Range(23.0f, 33.0f), new Range(26.0f, 36.0f), new Range(23.0f, 33.0f)});
        BiomeTempConfig.putAllSeasons("rocky_dunes", new Range[]{new Range(10.0f, 22.0f), new Range(18.0f, 32.0f), new Range(28.0f, 43.0f), new Range(18.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("scrubland", new Range[]{new Range(5.0f, 18.0f), new Range(15.0f, 28.0f), new Range(25.0f, 38.0f), new Range(15.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("snowy_scrubland", new Range[]{new Range(-25.0f, -5.0f), new Range(-10.0f, 8.0f), new Range(5.0f, 18.0f), new Range(-5.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("sparse_rainforest", new Range[]{new Range(18.0f, 25.0f), new Range(20.0f, 30.0f), new Range(24.0f, 35.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("sparse_rainforest_basin", new Range[]{new Range(18.0f, 26.0f), new Range(21.0f, 31.0f), new Range(25.0f, 36.0f), new Range(21.0f, 31.0f)});
        BiomeTempConfig.putAllSeasons("spiny_thicket", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(30.0f, 45.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("alpine_heathlands", new Range[]{new Range(-12.0f, 2.0f), new Range(-2.0f, 12.0f), new Range(6.0f, 20.0f), new Range(-2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("alpine_plains", new Range[]{new Range(-12.0f, 2.0f), new Range(-2.0f, 12.0f), new Range(6.0f, 20.0f), new Range(-2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("alpine_tundra", new Range[]{new Range(-18.0f, -5.0f), new Range(-8.0f, 6.0f), new Range(2.0f, 14.0f), new Range(-8.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("arctic_beach", new Range[]{new Range(-18.0f, -2.0f), new Range(-8.0f, 6.0f), new Range(2.0f, 12.0f), new Range(-10.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("arctic_deep_ocean", new Range[]{new Range(-4.0f, 2.0f), new Range(0.0f, 6.0f), new Range(4.0f, 10.0f), new Range(0.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("arctic_desert", new Range[]{new Range(-35.0f, -10.0f), new Range(-20.0f, 0.0f), new Range(-5.0f, 10.0f), new Range(-20.0f, -2.0f)});
        BiomeTempConfig.putAllSeasons("arctic_desert_basin", new Range[]{new Range(-20.0f, -5.0f), new Range(-10.0f, 6.0f), new Range(2.0f, 14.0f), new Range(-8.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("arctic_glacier", new Range[]{new Range(-45.0f, -25.0f), new Range(-30.0f, -10.0f), new Range(-12.0f, 2.0f), new Range(-28.0f, -8.0f)});
        BiomeTempConfig.putAllSeasons("arctic_shallow_ocean", new Range[]{new Range(-3.0f, 2.0f), new Range(0.0f, 7.0f), new Range(5.0f, 12.0f), new Range(0.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("arctic_wetlands", new Range[]{new Range(-15.0f, -2.0f), new Range(-5.0f, 10.0f), new Range(8.0f, 18.0f), new Range(-2.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("arid_beach", new Range[]{new Range(12.0f, 22.0f), new Range(18.0f, 30.0f), new Range(24.0f, 38.0f), new Range(18.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("arid_desert", new Range[]{new Range(10.0f, 22.0f), new Range(20.0f, 34.0f), new Range(28.0f, 45.0f), new Range(18.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("arid_highlands", new Range[]{new Range(8.0f, 20.0f), new Range(16.0f, 30.0f), new Range(24.0f, 40.0f), new Range(14.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("barren_arctic_desert", new Range[]{new Range(-40.0f, -20.0f), new Range(-28.0f, -8.0f), new Range(-12.0f, 2.0f), new Range(-28.0f, -8.0f)});
        BiomeTempConfig.putAllSeasons("barren_caves", new Range[]{new Range(6.0f, 10.0f), new Range(8.0f, 12.0f), new Range(10.0f, 14.0f), new Range(8.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("barren_mediterranean_highlands", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 22.0f), new Range(18.0f, 32.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("barren_peaks", new Range[]{new Range(-8.0f, 2.0f), new Range(0.0f, 12.0f), new Range(6.0f, 20.0f), new Range(-2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("birch_forest", new Range[]{new Range(-6.0f, 8.0f), new Range(4.0f, 18.0f), new Range(14.0f, 28.0f), new Range(4.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("bog", new Range[]{new Range(-4.0f, 6.0f), new Range(4.0f, 16.0f), new Range(12.0f, 24.0f), new Range(4.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("boreal_alpine_tundra", new Range[]{new Range(-20.0f, -6.0f), new Range(-8.0f, 6.0f), new Range(4.0f, 16.0f), new Range(-6.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("boreal_river", new Range[]{new Range(-8.0f, 2.0f), new Range(2.0f, 12.0f), new Range(10.0f, 20.0f), new Range(0.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("cold_barren_highlands", new Range[]{new Range(-10.0f, 0.0f), new Range(-2.0f, 12.0f), new Range(6.0f, 20.0f), new Range(-2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("cold_deep_ocean", new Range[]{new Range(0.0f, 6.0f), new Range(4.0f, 10.0f), new Range(8.0f, 14.0f), new Range(4.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("cold_desert", new Range[]{new Range(-6.0f, 10.0f), new Range(6.0f, 20.0f), new Range(16.0f, 30.0f), new Range(6.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("cold_semi_desert", new Range[]{new Range(-4.0f, 12.0f), new Range(6.0f, 22.0f), new Range(16.0f, 32.0f), new Range(6.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("cold_shallow_ocean", new Range[]{new Range(1.0f, 7.0f), new Range(5.0f, 12.0f), new Range(9.0f, 15.0f), new Range(5.0f, 11.0f)});
        BiomeTempConfig.putAllSeasons("cold_steppe", new Range[]{new Range(-10.0f, 2.0f), new Range(2.0f, 16.0f), new Range(12.0f, 26.0f), new Range(0.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("cold_taiga", new Range[]{new Range(-25.0f, -5.0f), new Range(-5.0f, 10.0f), new Range(10.0f, 20.0f), new Range(-5.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("cold_taiga_clearings", new Range[]{new Range(-24.0f, -4.0f), new Range(-4.0f, 12.0f), new Range(10.0f, 22.0f), new Range(-4.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("cold_tundra_beach", new Range[]{new Range(-14.0f, -2.0f), new Range(-4.0f, 8.0f), new Range(4.0f, 14.0f), new Range(-6.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("desert_river", new Range[]{new Range(12.0f, 22.0f), new Range(18.0f, 32.0f), new Range(26.0f, 42.0f), new Range(18.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("desert_wetlands", new Range[]{new Range(14.0f, 24.0f), new Range(20.0f, 34.0f), new Range(26.0f, 40.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("dry_cold_steppe", new Range[]{new Range(-12.0f, 0.0f), new Range(0.0f, 14.0f), new Range(10.0f, 24.0f), new Range(-2.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("dry_tropical_highlands", new Range[]{new Range(10.0f, 20.0f), new Range(16.0f, 28.0f), new Range(20.0f, 34.0f), new Range(14.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("evergreen_taiga", new Range[]{new Range(-22.0f, -4.0f), new Range(-4.0f, 12.0f), new Range(10.0f, 22.0f), new Range(-4.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("fen", new Range[]{new Range(0.0f, 10.0f), new Range(6.0f, 20.0f), new Range(14.0f, 28.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("flooded_grasslands", new Range[]{new Range(6.0f, 16.0f), new Range(12.0f, 24.0f), new Range(18.0f, 30.0f), new Range(10.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("flooded_savanna", new Range[]{new Range(16.0f, 26.0f), new Range(22.0f, 34.0f), new Range(26.0f, 38.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("frozen_caves", new Range[]{new Range(-2.0f, 2.0f), new Range(0.0f, 4.0f), new Range(2.0f, 6.0f), new Range(0.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("glacial_basin", new Range[]{new Range(-42.0f, -22.0f), new Range(-28.0f, -8.0f), new Range(-10.0f, 4.0f), new Range(-26.0f, -6.0f)});
        BiomeTempConfig.putAllSeasons("glowing_caves", new Range[]{new Range(8.0f, 12.0f), new Range(10.0f, 14.0f), new Range(12.0f, 16.0f), new Range(10.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("grassland_savanna", new Range[]{new Range(14.0f, 24.0f), new Range(20.0f, 32.0f), new Range(26.0f, 38.0f), new Range(18.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("haunted_depths", new Range[]{new Range(7.0f, 11.0f), new Range(9.0f, 13.0f), new Range(11.0f, 15.0f), new Range(9.0f, 13.0f)});
        BiomeTempConfig.putAllSeasons("humid_savanna", new Range[]{new Range(18.0f, 26.0f), new Range(22.0f, 34.0f), new Range(26.0f, 38.0f), new Range(22.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("infested_tunnels", new Range[]{new Range(7.0f, 11.0f), new Range(9.0f, 13.0f), new Range(11.0f, 15.0f), new Range(9.0f, 13.0f)});
        BiomeTempConfig.putAllSeasons("larch_woodlands", new Range[]{new Range(-8.0f, 6.0f), new Range(2.0f, 16.0f), new Range(12.0f, 26.0f), new Range(2.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("mangrove_marsh", new Range[]{new Range(16.0f, 24.0f), new Range(20.0f, 30.0f), new Range(24.0f, 34.0f), new Range(20.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_beach", new Range[]{new Range(8.0f, 16.0f), new Range(14.0f, 24.0f), new Range(20.0f, 30.0f), new Range(14.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_forest", new Range[]{new Range(4.0f, 14.0f), new Range(10.0f, 22.0f), new Range(20.0f, 34.0f), new Range(10.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_highlands", new Range[]{new Range(2.0f, 12.0f), new Range(8.0f, 20.0f), new Range(16.0f, 30.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_marsh", new Range[]{new Range(8.0f, 18.0f), new Range(14.0f, 26.0f), new Range(20.0f, 32.0f), new Range(12.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_river", new Range[]{new Range(8.0f, 16.0f), new Range(14.0f, 24.0f), new Range(20.0f, 30.0f), new Range(14.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_shrubland", new Range[]{new Range(6.0f, 16.0f), new Range(12.0f, 24.0f), new Range(20.0f, 34.0f), new Range(10.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_steppe", new Range[]{new Range(4.0f, 16.0f), new Range(12.0f, 26.0f), new Range(20.0f, 36.0f), new Range(10.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_swamp", new Range[]{new Range(8.0f, 18.0f), new Range(14.0f, 26.0f), new Range(20.0f, 32.0f), new Range(12.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_wooded_highlands", new Range[]{new Range(2.0f, 12.0f), new Range(8.0f, 20.0f), new Range(16.0f, 30.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("mire", new Range[]{new Range(0.0f, 10.0f), new Range(8.0f, 20.0f), new Range(14.0f, 26.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("mixed_forest_steppe", new Range[]{new Range(-6.0f, 6.0f), new Range(4.0f, 18.0f), new Range(14.0f, 28.0f), new Range(4.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("monsoon_forest", new Range[]{new Range(18.0f, 26.0f), new Range(22.0f, 34.0f), new Range(24.0f, 36.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("mushroom_caves", new Range[]{new Range(10.0f, 12.0f), new Range(12.0f, 14.0f), new Range(14.0f, 16.0f), new Range(12.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("old_growth_temperate_forest", new Range[]{new Range(-4.0f, 8.0f), new Range(6.0f, 18.0f), new Range(14.0f, 28.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("old_growth_tropical_rainforest", new Range[]{new Range(20.0f, 26.0f), new Range(22.0f, 32.0f), new Range(24.0f, 34.0f), new Range(22.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("pine_woods", new Range[]{new Range(-10.0f, 4.0f), new Range(2.0f, 16.0f), new Range(12.0f, 26.0f), new Range(2.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("savanna_beach", new Range[]{new Range(16.0f, 24.0f), new Range(20.0f, 30.0f), new Range(24.0f, 34.0f), new Range(20.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("savanna_highlands", new Range[]{new Range(14.0f, 24.0f), new Range(20.0f, 32.0f), new Range(26.0f, 38.0f), new Range(18.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("savanna_river", new Range[]{new Range(16.0f, 24.0f), new Range(22.0f, 32.0f), new Range(26.0f, 36.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("scorched_caves", new Range[]{new Range(18.0f, 22.0f), new Range(20.0f, 24.0f), new Range(22.0f, 28.0f), new Range(20.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("semiarid_desert", new Range[]{new Range(8.0f, 22.0f), new Range(18.0f, 32.0f), new Range(26.0f, 42.0f), new Range(16.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("shrub_steppe", new Range[]{new Range(2.0f, 14.0f), new Range(10.0f, 24.0f), new Range(18.0f, 32.0f), new Range(8.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("snowy_barren_peaks", new Range[]{new Range(-22.0f, -6.0f), new Range(-10.0f, 4.0f), new Range(0.0f, 12.0f), new Range(-10.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("snowy_peaks", new Range[]{new Range(-20.0f, -5.0f), new Range(-8.0f, 6.0f), new Range(2.0f, 14.0f), new Range(-8.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("snowy_tundra", new Range[]{new Range(-28.0f, -8.0f), new Range(-12.0f, 4.0f), new Range(2.0f, 14.0f), new Range(-12.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("steppe_river", new Range[]{new Range(0.0f, 10.0f), new Range(10.0f, 22.0f), new Range(18.0f, 30.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("subtropical_deep_ocean", new Range[]{new Range(16.0f, 22.0f), new Range(20.0f, 26.0f), new Range(24.0f, 30.0f), new Range(20.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("subtropical_shallow_ocean", new Range[]{new Range(18.0f, 24.0f), new Range(22.0f, 28.0f), new Range(26.0f, 32.0f), new Range(22.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("taiga_beach", new Range[]{new Range(-10.0f, 2.0f), new Range(0.0f, 12.0f), new Range(8.0f, 20.0f), new Range(0.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("taiga_highlands", new Range[]{new Range(-16.0f, -2.0f), new Range(-4.0f, 10.0f), new Range(8.0f, 20.0f), new Range(-4.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("temperate_beach", new Range[]{new Range(4.0f, 12.0f), new Range(10.0f, 20.0f), new Range(16.0f, 26.0f), new Range(10.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_deep_ocean", new Range[]{new Range(10.0f, 14.0f), new Range(12.0f, 16.0f), new Range(14.0f, 18.0f), new Range(12.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("temperate_forest", new Range[]{new Range(-4.0f, 8.0f), new Range(6.0f, 18.0f), new Range(14.0f, 28.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_marsh", new Range[]{new Range(0.0f, 10.0f), new Range(8.0f, 20.0f), new Range(14.0f, 26.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_mixed_forest", new Range[]{new Range(-6.0f, 8.0f), new Range(6.0f, 18.0f), new Range(14.0f, 28.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_river", new Range[]{new Range(0.0f, 10.0f), new Range(8.0f, 20.0f), new Range(14.0f, 26.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_shallow_ocean", new Range[]{new Range(12.0f, 16.0f), new Range(14.0f, 18.0f), new Range(16.0f, 20.0f), new Range(14.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_swamp", new Range[]{new Range(4.0f, 12.0f), new Range(10.0f, 22.0f), new Range(16.0f, 28.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("tropical_beach", new Range[]{new Range(20.0f, 26.0f), new Range(24.0f, 30.0f), new Range(26.0f, 32.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("tropical_deep_ocean", new Range[]{new Range(18.0f, 24.0f), new Range(22.0f, 28.0f), new Range(26.0f, 30.0f), new Range(22.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("tropical_dry_forest", new Range[]{new Range(18.0f, 26.0f), new Range(22.0f, 34.0f), new Range(24.0f, 36.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("tropical_highlands", new Range[]{new Range(14.0f, 22.0f), new Range(18.0f, 28.0f), new Range(20.0f, 30.0f), new Range(16.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("tropical_rainforest", new Range[]{new Range(22.0f, 28.0f), new Range(24.0f, 32.0f), new Range(24.0f, 34.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("tropical_rainforest_river", new Range[]{new Range(22.0f, 28.0f), new Range(24.0f, 32.0f), new Range(24.0f, 34.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("tropical_shallow_ocean", new Range[]{new Range(22.0f, 26.0f), new Range(24.0f, 30.0f), new Range(26.0f, 32.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("tropical_wetlands", new Range[]{new Range(22.0f, 28.0f), new Range(24.0f, 32.0f), new Range(24.0f, 34.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("tundra_beach", new Range[]{new Range(-10.0f, -2.0f), new Range(-4.0f, 8.0f), new Range(4.0f, 14.0f), new Range(-6.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("warm_temperate_clearings", new Range[]{new Range(2.0f, 12.0f), new Range(10.0f, 22.0f), new Range(18.0f, 32.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("warm_temperate_river", new Range[]{new Range(4.0f, 12.0f), new Range(10.0f, 22.0f), new Range(18.0f, 30.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("warm_temperate_woodlands", new Range[]{new Range(2.0f, 12.0f), new Range(10.0f, 22.0f), new Range(18.0f, 32.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("wooded_highlands", new Range[]{new Range(-6.0f, 6.0f), new Range(4.0f, 18.0f), new Range(12.0f, 26.0f), new Range(4.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("wooded_mediterranean_steppe", new Range[]{new Range(6.0f, 16.0f), new Range(12.0f, 26.0f), new Range(20.0f, 36.0f), new Range(10.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("wooded_savanna", new Range[]{new Range(16.0f, 26.0f), new Range(22.0f, 34.0f), new Range(26.0f, 38.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("wooded_semiarid_desert", new Range[]{new Range(8.0f, 22.0f), new Range(18.0f, 32.0f), new Range(26.0f, 42.0f), new Range(16.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("xeric_shrubland", new Range[]{new Range(8.0f, 22.0f), new Range(18.0f, 32.0f), new Range(26.0f, 42.0f), new Range(16.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("arctic_river", new Range[]{new Range(-18.0f, -2.0f), new Range(-8.0f, 6.0f), new Range(4.0f, 14.0f), new Range(-6.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("arctic_tundra", new Range[]{new Range(-40.0f, -20.0f), new Range(-25.0f, -5.0f), new Range(-5.0f, 12.0f), new Range(-20.0f, -4.0f)});
        BiomeTempConfig.putAllSeasons("barren_tundra", new Range[]{new Range(-35.0f, -15.0f), new Range(-22.0f, -2.0f), new Range(-2.0f, 10.0f), new Range(-18.0f, -4.0f)});
        BiomeTempConfig.putAllSeasons("lush_tundra", new Range[]{new Range(-28.0f, -10.0f), new Range(-10.0f, 4.0f), new Range(2.0f, 14.0f), new Range(-8.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("snowy_boreal_alpine_tundra", new Range[]{new Range(-30.0f, -12.0f), new Range(-14.0f, 2.0f), new Range(4.0f, 16.0f), new Range(-10.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("tundra_river", new Range[]{new Range(-20.0f, -5.0f), new Range(-10.0f, 4.0f), new Range(4.0f, 14.0f), new Range(-8.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("wooded_tundra", new Range[]{new Range(-26.0f, -8.0f), new Range(-10.0f, 6.0f), new Range(6.0f, 18.0f), new Range(-6.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("alexscaves:candy_cavity", new Range[]{new Range(18.0f, 25.0f), new Range(20.0f, 30.0f), new Range(18.0f, 26.0f), new Range(17.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("ars_nouveau:archwood_forest", new Range[]{new Range(8.0f, 16.0f), new Range(18.0f, 26.0f), new Range(10.0f, 18.0f), new Range(0.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:aspen_parkland", new Range[]{new Range(5.0f, 15.0f), new Range(18.0f, 28.0f), new Range(8.0f, 18.0f), new Range(-5.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:dunes", new Range[]{new Range(15.0f, 35.0f), new Range(25.0f, 45.0f), new Range(18.0f, 32.0f), new Range(8.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:flourishing_dunes", new Range[]{new Range(16.0f, 33.0f), new Range(26.0f, 44.0f), new Range(20.0f, 34.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:kousa_jungle", new Range[]{new Range(20.0f, 30.0f), new Range(24.0f, 35.0f), new Range(22.0f, 32.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:laurel_forest", new Range[]{new Range(12.0f, 20.0f), new Range(18.0f, 28.0f), new Range(14.0f, 22.0f), new Range(8.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:petrified_dunes", new Range[]{new Range(12.0f, 32.0f), new Range(22.0f, 44.0f), new Range(16.0f, 34.0f), new Range(6.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:rainforest", new Range[]{new Range(23.0f, 32.0f), new Range(25.0f, 34.0f), new Range(24.0f, 33.0f), new Range(22.0f, 31.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:rainforest_basin", new Range[]{new Range(24.0f, 33.0f), new Range(25.0f, 35.0f), new Range(24.0f, 33.0f), new Range(23.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:rocky_dunes", new Range[]{new Range(14.0f, 30.0f), new Range(25.0f, 43.0f), new Range(18.0f, 32.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:scrubland", new Range[]{new Range(10.0f, 25.0f), new Range(18.0f, 33.0f), new Range(12.0f, 26.0f), new Range(5.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:snowy_scrubland", new Range[]{new Range(2.0f, 12.0f), new Range(10.0f, 20.0f), new Range(5.0f, 15.0f), new Range(-10.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:sparse_rainforest", new Range[]{new Range(20.0f, 30.0f), new Range(24.0f, 34.0f), new Range(22.0f, 32.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:sparse_rainforest_basin", new Range[]{new Range(21.0f, 31.0f), new Range(25.0f, 34.0f), new Range(23.0f, 32.0f), new Range(21.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("atmospheric:spiny_thicket", new Range[]{new Range(10.0f, 28.0f), new Range(20.0f, 38.0f), new Range(14.0f, 30.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("autumnity:maple_forest", new Range[]{new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(8.0f, 15.0f), new Range(-2.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("autumnity:pumpkin_fields", new Range[]{new Range(8.0f, 18.0f), new Range(20.0f, 28.0f), new Range(10.0f, 20.0f), new Range(0.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:aspen_glade", new Range[]{new Range(6.0f, 16.0f), new Range(16.0f, 28.0f), new Range(10.0f, 20.0f), new Range(-3.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:auroral_garden", new Range[]{new Range(0.0f, 10.0f), new Range(5.0f, 15.0f), new Range(2.0f, 10.0f), new Range(-15.0f, -2.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:bayou", new Range[]{new Range(15.0f, 26.0f), new Range(22.0f, 33.0f), new Range(18.0f, 28.0f), new Range(10.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:bog", new Range[]{new Range(5.0f, 14.0f), new Range(14.0f, 22.0f), new Range(6.0f, 16.0f), new Range(-5.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:cold_desert", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 35.0f), new Range(8.0f, 22.0f), new Range(-10.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:coniferous_forest", new Range[]{new Range(5.0f, 14.0f), new Range(16.0f, 24.0f), new Range(8.0f, 15.0f), new Range(-5.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:crag", new Range[]{new Range(0.0f, 10.0f), new Range(8.0f, 18.0f), new Range(2.0f, 12.0f), new Range(-10.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:dead_forest", new Range[]{new Range(5.0f, 15.0f), new Range(16.0f, 25.0f), new Range(8.0f, 16.0f), new Range(-2.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:dryland", new Range[]{new Range(12.0f, 28.0f), new Range(20.0f, 40.0f), new Range(15.0f, 30.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:dune_beach", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(18.0f, 32.0f), new Range(12.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:field", new Range[]{new Range(10.0f, 20.0f), new Range(18.0f, 28.0f), new Range(12.0f, 22.0f), new Range(0.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:fir_clearing", new Range[]{new Range(5.0f, 14.0f), new Range(15.0f, 24.0f), new Range(8.0f, 16.0f), new Range(-5.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:floodplain", new Range[]{new Range(14.0f, 24.0f), new Range(20.0f, 32.0f), new Range(16.0f, 26.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:forested_field", new Range[]{new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(12.0f, 20.0f), new Range(0.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:fungal_jungle", new Range[]{new Range(22.0f, 30.0f), new Range(25.0f, 34.0f), new Range(23.0f, 31.0f), new Range(21.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:glowing_grotto", new Range[]{new Range(16.0f, 20.0f), new Range(18.0f, 22.0f), new Range(17.0f, 21.0f), new Range(16.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:grassland", new Range[]{new Range(10.0f, 20.0f), new Range(20.0f, 30.0f), new Range(12.0f, 22.0f), new Range(0.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:gravel_beach", new Range[]{new Range(10.0f, 18.0f), new Range(20.0f, 28.0f), new Range(14.0f, 22.0f), new Range(8.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:highland", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 22.0f), new Range(6.0f, 16.0f), new Range(-5.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:hot_springs", new Range[]{new Range(10.0f, 20.0f), new Range(15.0f, 28.0f), new Range(12.0f, 22.0f), new Range(5.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:jacaranda_glade", new Range[]{new Range(8.0f, 18.0f), new Range(18.0f, 26.0f), new Range(10.0f, 20.0f), new Range(2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:jade_cliffs", new Range[]{new Range(5.0f, 15.0f), new Range(15.0f, 25.0f), new Range(8.0f, 18.0f), new Range(-3.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:lavender_field", new Range[]{new Range(12.0f, 22.0f), new Range(20.0f, 32.0f), new Range(15.0f, 25.0f), new Range(5.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:lush_desert", new Range[]{new Range(18.0f, 35.0f), new Range(25.0f, 45.0f), new Range(20.0f, 34.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:lush_savanna", new Range[]{new Range(20.0f, 32.0f), new Range(24.0f, 38.0f), new Range(22.0f, 34.0f), new Range(18.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:maple_woods", new Range[]{new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(8.0f, 16.0f), new Range(-2.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:marsh", new Range[]{new Range(12.0f, 22.0f), new Range(20.0f, 30.0f), new Range(15.0f, 25.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:mediterranean_forest", new Range[]{new Range(12.0f, 22.0f), new Range(22.0f, 34.0f), new Range(14.0f, 24.0f), new Range(6.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:moor", new Range[]{new Range(8.0f, 16.0f), new Range(14.0f, 24.0f), new Range(10.0f, 18.0f), new Range(0.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:muskeg", new Range[]{new Range(4.0f, 12.0f), new Range(10.0f, 20.0f), new Range(6.0f, 14.0f), new Range(-8.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:mystic_grove", new Range[]{new Range(12.0f, 20.0f), new Range(18.0f, 28.0f), new Range(14.0f, 22.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:old_growth_dead_forest", new Range[]{new Range(4.0f, 12.0f), new Range(14.0f, 22.0f), new Range(6.0f, 14.0f), new Range(-4.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:old_growth_woodland", new Range[]{new Range(8.0f, 18.0f), new Range(18.0f, 26.0f), new Range(10.0f, 20.0f), new Range(2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:ominous_woods", new Range[]{new Range(6.0f, 14.0f), new Range(12.0f, 22.0f), new Range(8.0f, 16.0f), new Range(0.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:orchard", new Range[]{new Range(10.0f, 18.0f), new Range(18.0f, 28.0f), new Range(12.0f, 20.0f), new Range(2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:overgrown_greens", new Range[]{new Range(14.0f, 24.0f), new Range(20.0f, 32.0f), new Range(16.0f, 26.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:pasture", new Range[]{new Range(10.0f, 20.0f), new Range(18.0f, 30.0f), new Range(12.0f, 22.0f), new Range(0.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:prairie", new Range[]{new Range(8.0f, 18.0f), new Range(18.0f, 28.0f), new Range(10.0f, 20.0f), new Range(-2.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:pumpkin_patch", new Range[]{new Range(10.0f, 18.0f), new Range(18.0f, 28.0f), new Range(12.0f, 20.0f), new Range(2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:rainforest", new Range[]{new Range(23.0f, 32.0f), new Range(25.0f, 34.0f), new Range(24.0f, 33.0f), new Range(22.0f, 31.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:redwood_forest", new Range[]{new Range(10.0f, 20.0f), new Range(18.0f, 26.0f), new Range(12.0f, 22.0f), new Range(4.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:rocky_rainforest", new Range[]{new Range(20.0f, 30.0f), new Range(24.0f, 34.0f), new Range(22.0f, 32.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:rocky_shrubland", new Range[]{new Range(8.0f, 22.0f), new Range(18.0f, 34.0f), new Range(10.0f, 24.0f), new Range(4.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:scrubland", new Range[]{new Range(10.0f, 25.0f), new Range(18.0f, 33.0f), new Range(12.0f, 26.0f), new Range(5.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:seasonal_forest", new Range[]{new Range(10.0f, 20.0f), new Range(18.0f, 28.0f), new Range(8.0f, 18.0f), new Range(-5.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:seasonal_forest", new Range[]{new Range(10.0f, 20.0f), new Range(18.0f, 28.0f), new Range(8.0f, 18.0f), new Range(-5.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:shrubland", new Range[]{new Range(8.0f, 22.0f), new Range(18.0f, 34.0f), new Range(10.0f, 24.0f), new Range(4.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:snowblossom_grove", new Range[]{new Range(0.0f, 10.0f), new Range(5.0f, 18.0f), new Range(2.0f, 12.0f), new Range(-15.0f, 0.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:snowy_coniferous_forest", new Range[]{new Range(0.0f, 10.0f), new Range(5.0f, 18.0f), new Range(2.0f, 10.0f), new Range(-20.0f, -2.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:snowy_fir_clearing", new Range[]{new Range(0.0f, 10.0f), new Range(6.0f, 16.0f), new Range(2.0f, 10.0f), new Range(-18.0f, -2.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:snowy_maple_woods", new Range[]{new Range(2.0f, 12.0f), new Range(10.0f, 20.0f), new Range(4.0f, 14.0f), new Range(-10.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:spider_nest", new Range[]{new Range(14.0f, 22.0f), new Range(20.0f, 30.0f), new Range(16.0f, 24.0f), new Range(10.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:tropics", new Range[]{new Range(25.0f, 33.0f), new Range(26.0f, 35.0f), new Range(25.0f, 34.0f), new Range(24.0f, 33.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:tundra", new Range[]{new Range(-15.0f, -2.0f), new Range(-5.0f, 8.0f), new Range(-10.0f, 0.0f), new Range(-25.0f, -8.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:volcanic_plains", new Range[]{new Range(20.0f, 35.0f), new Range(25.0f, 45.0f), new Range(22.0f, 36.0f), new Range(15.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:volcano", new Range[]{new Range(25.0f, 45.0f), new Range(30.0f, 55.0f), new Range(28.0f, 48.0f), new Range(20.0f, 38.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:wasteland", new Range[]{new Range(10.0f, 30.0f), new Range(20.0f, 45.0f), new Range(15.0f, 32.0f), new Range(5.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:wasteland_steppe", new Range[]{new Range(8.0f, 25.0f), new Range(18.0f, 40.0f), new Range(12.0f, 28.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:wetland", new Range[]{new Range(12.0f, 24.0f), new Range(20.0f, 32.0f), new Range(15.0f, 26.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomesoplenty:woodland", new Range[]{new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(12.0f, 20.0f), new Range(4.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("galosphere:crystal_canyons", new Range[]{new Range(4.0f, 14.0f), new Range(10.0f, 22.0f), new Range(6.0f, 16.0f), new Range(-6.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("integrateddynamics:meneglin", new Range[]{new Range(8.0f, 18.0f), new Range(16.0f, 26.0f), new Range(10.0f, 20.0f), new Range(2.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("neapolitan:strawberry_fields", new Range[]{new Range(12.0f, 22.0f), new Range(20.0f, 30.0f), new Range(15.0f, 25.0f), new Range(6.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:allium_shrubland", new Range[]{new Range(8.0f, 18.0f), new Range(12.0f, 22.0f), new Range(18.0f, 27.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:amaranth_grassland", new Range[]{new Range(10.0f, 20.0f), new Range(15.0f, 25.0f), new Range(22.0f, 32.0f), new Range(12.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:araucaria_savanna", new Range[]{new Range(14.0f, 26.0f), new Range(18.0f, 30.0f), new Range(25.0f, 36.0f), new Range(16.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:aspen_boreal", new Range[]{new Range(-5.0f, 6.0f), new Range(2.0f, 14.0f), new Range(10.0f, 20.0f), new Range(-1.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:atacama_outback", new Range[]{new Range(18.0f, 32.0f), new Range(25.0f, 42.0f), new Range(35.0f, 54.0f), new Range(22.0f, 38.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:baobab_savanna", new Range[]{new Range(15.0f, 26.0f), new Range(20.0f, 30.0f), new Range(28.0f, 38.0f), new Range(18.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:basalt_barrera", new Range[]{new Range(2.0f, 10.0f), new Range(5.0f, 14.0f), new Range(8.0f, 18.0f), new Range(4.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:bayou", new Range[]{new Range(16.0f, 25.0f), new Range(20.0f, 32.0f), new Range(26.0f, 38.0f), new Range(18.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:black_forest", new Range[]{new Range(2.0f, 10.0f), new Range(8.0f, 16.0f), new Range(15.0f, 24.0f), new Range(4.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:canadian_shield", new Range[]{new Range(-10.0f, 2.0f), new Range(-2.0f, 10.0f), new Range(5.0f, 18.0f), new Range(-5.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:cika_woods", new Range[]{new Range(5.0f, 14.0f), new Range(10.0f, 20.0f), new Range(18.0f, 26.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:coconino_meadow", new Range[]{new Range(8.0f, 18.0f), new Range(14.0f, 24.0f), new Range(20.0f, 30.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:coniferous_forest", new Range[]{new Range(-8.0f, 3.0f), new Range(2.0f, 14.0f), new Range(10.0f, 20.0f), new Range(-2.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:crag_gardens", new Range[]{new Range(6.0f, 14.0f), new Range(10.0f, 20.0f), new Range(20.0f, 30.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:crimson_tundra", new Range[]{new Range(-12.0f, -2.0f), new Range(-6.0f, 6.0f), new Range(2.0f, 12.0f), new Range(-8.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:cypress_swamplands", new Range[]{new Range(16.0f, 25.0f), new Range(20.0f, 32.0f), new Range(26.0f, 36.0f), new Range(18.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:cypress_wetlands", new Range[]{new Range(18.0f, 26.0f), new Range(22.0f, 32.0f), new Range(28.0f, 38.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:dacite_ridges", new Range[]{new Range(-2.0f, 8.0f), new Range(5.0f, 15.0f), new Range(10.0f, 20.0f), new Range(2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:dacite_shore", new Range[]{new Range(10.0f, 20.0f), new Range(15.0f, 25.0f), new Range(22.0f, 30.0f), new Range(12.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:dead_sea", new Range[]{new Range(18.0f, 26.0f), new Range(22.0f, 34.0f), new Range(28.0f, 40.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:ebony_woods", new Range[]{new Range(10.0f, 18.0f), new Range(14.0f, 24.0f), new Range(20.0f, 28.0f), new Range(12.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:enchanted_tangle", new Range[]{new Range(8.0f, 16.0f), new Range(12.0f, 22.0f), new Range(18.0f, 26.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:eroded_borealis", new Range[]{new Range(-18.0f, -4.0f), new Range(-10.0f, 0.0f), new Range(-5.0f, 5.0f), new Range(-12.0f, -2.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:firecracker_chaparral", new Range[]{new Range(12.0f, 22.0f), new Range(20.0f, 30.0f), new Range(25.0f, 36.0f), new Range(15.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:forgotten_forest", new Range[]{new Range(8.0f, 16.0f), new Range(14.0f, 22.0f), new Range(18.0f, 26.0f), new Range(10.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:fragment_jungle", new Range[]{new Range(18.0f, 26.0f), new Range(22.0f, 34.0f), new Range(28.0f, 40.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:frosted_coniferous_forest", new Range[]{new Range(-12.0f, -2.0f), new Range(-5.0f, 6.0f), new Range(2.0f, 12.0f), new Range(-8.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:frosted_taiga", new Range[]{new Range(-14.0f, -5.0f), new Range(-8.0f, 2.0f), new Range(2.0f, 10.0f), new Range(-10.0f, 0.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:howling_peaks", new Range[]{new Range(-10.0f, -2.0f), new Range(-5.0f, 5.0f), new Range(5.0f, 14.0f), new Range(-6.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:ironwood_gour", new Range[]{new Range(15.0f, 25.0f), new Range(20.0f, 32.0f), new Range(30.0f, 42.0f), new Range(18.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:jacaranda_jungle", new Range[]{new Range(18.0f, 25.0f), new Range(22.0f, 32.0f), new Range(28.0f, 38.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:lush_stacks", new Range[]{new Range(16.0f, 24.0f), new Range(20.0f, 30.0f), new Range(26.0f, 38.0f), new Range(18.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:maple_taiga", new Range[]{new Range(-8.0f, 2.0f), new Range(2.0f, 12.0f), new Range(10.0f, 20.0f), new Range(0.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:mojave_desert", new Range[]{new Range(20.0f, 34.0f), new Range(28.0f, 42.0f), new Range(36.0f, 54.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:orchard", new Range[]{new Range(6.0f, 16.0f), new Range(12.0f, 22.0f), new Range(20.0f, 30.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:overgrowth_woodlands", new Range[]{new Range(4.0f, 14.0f), new Range(10.0f, 20.0f), new Range(18.0f, 26.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:pale_bog", new Range[]{new Range(2.0f, 12.0f), new Range(8.0f, 18.0f), new Range(15.0f, 25.0f), new Range(5.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:prairie", new Range[]{new Range(6.0f, 18.0f), new Range(12.0f, 24.0f), new Range(22.0f, 32.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:pumpkin_valley", new Range[]{new Range(5.0f, 15.0f), new Range(12.0f, 22.0f), new Range(20.0f, 28.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:rainbow_beach", new Range[]{new Range(12.0f, 22.0f), new Range(18.0f, 28.0f), new Range(24.0f, 34.0f), new Range(14.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:red_rock_peaks", new Range[]{new Range(5.0f, 15.0f), new Range(12.0f, 25.0f), new Range(25.0f, 38.0f), new Range(10.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:red_rock_valley", new Range[]{new Range(8.0f, 20.0f), new Range(15.0f, 28.0f), new Range(28.0f, 40.0f), new Range(12.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:redwood_thicket", new Range[]{new Range(4.0f, 12.0f), new Range(10.0f, 20.0f), new Range(18.0f, 26.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:rose_fields", new Range[]{new Range(10.0f, 20.0f), new Range(14.0f, 24.0f), new Range(22.0f, 30.0f), new Range(12.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:rugged_badlands", new Range[]{new Range(15.0f, 26.0f), new Range(22.0f, 34.0f), new Range(30.0f, 46.0f), new Range(18.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:sakura_grove", new Range[]{new Range(6.0f, 16.0f), new Range(12.0f, 22.0f), new Range(20.0f, 28.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:shattered_glacier", new Range[]{new Range(-18.0f, -6.0f), new Range(-10.0f, 0.0f), new Range(-5.0f, 5.0f), new Range(-12.0f, -2.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:sierra_badlands", new Range[]{new Range(10.0f, 20.0f), new Range(18.0f, 30.0f), new Range(28.0f, 40.0f), new Range(15.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:skyrise_vale", new Range[]{new Range(6.0f, 16.0f), new Range(10.0f, 22.0f), new Range(20.0f, 28.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:temperate_grove", new Range[]{new Range(4.0f, 14.0f), new Range(10.0f, 20.0f), new Range(18.0f, 26.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:tropical_rainforest", new Range[]{new Range(20.0f, 28.0f), new Range(24.0f, 34.0f), new Range(30.0f, 40.0f), new Range(22.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:weeping_witch_forest", new Range[]{new Range(4.0f, 12.0f), new Range(10.0f, 20.0f), new Range(18.0f, 26.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:white_mangrove_marshes", new Range[]{new Range(18.0f, 26.0f), new Range(22.0f, 32.0f), new Range(28.0f, 38.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:windswept_desert", new Range[]{new Range(20.0f, 34.0f), new Range(28.0f, 44.0f), new Range(36.0f, 54.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("biomeswevegone:zelkova_forest", new Range[]{new Range(6.0f, 16.0f), new Range(12.0f, 22.0f), new Range(20.0f, 28.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:alpha_grove", new Range[]{new Range(-4.0f, 6.0f), new Range(6.0f, 15.0f), new Range(18.0f, 27.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:arid_mountains", new Range[]{new Range(5.0f, 15.0f), new Range(15.0f, 25.0f), new Range(30.0f, 42.0f), new Range(18.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:ashen_woodland", new Range[]{new Range(-2.0f, 8.0f), new Range(8.0f, 16.0f), new Range(14.0f, 25.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:autumnal_maple_forest", new Range[]{new Range(-6.0f, 6.0f), new Range(6.0f, 16.0f), new Range(18.0f, 26.0f), new Range(4.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:bamboo_forest", new Range[]{new Range(8.0f, 18.0f), new Range(18.0f, 25.0f), new Range(25.0f, 34.0f), new Range(18.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:baobab_savanna", new Range[]{new Range(10.0f, 22.0f), new Range(18.0f, 30.0f), new Range(30.0f, 42.0f), new Range(20.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:barley_fields", new Range[]{new Range(-2.0f, 8.0f), new Range(6.0f, 16.0f), new Range(18.0f, 27.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:bayou", new Range[]{new Range(8.0f, 16.0f), new Range(16.0f, 26.0f), new Range(26.0f, 34.0f), new Range(18.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:blackwood_taiga", new Range[]{new Range(-10.0f, 0.0f), new Range(0.0f, 8.0f), new Range(10.0f, 20.0f), new Range(-2.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:boreal_taiga", new Range[]{new Range(-18.0f, -6.0f), new Range(-4.0f, 8.0f), new Range(10.0f, 18.0f), new Range(-2.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:chalk_cliffs", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:clover_plains", new Range[]{new Range(-3.0f, 8.0f), new Range(6.0f, 15.0f), new Range(18.0f, 27.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:cold_boreal_taiga", new Range[]{new Range(-20.0f, -10.0f), new Range(-8.0f, 4.0f), new Range(8.0f, 16.0f), new Range(-6.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:cold_deciduous_forest", new Range[]{new Range(-18.0f, -8.0f), new Range(-6.0f, 6.0f), new Range(8.0f, 16.0f), new Range(-4.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:cold_river", new Range[]{new Range(-12.0f, -4.0f), new Range(-4.0f, 8.0f), new Range(8.0f, 16.0f), new Range(-2.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:deciduous_forest", new Range[]{new Range(-4.0f, 8.0f), new Range(8.0f, 16.0f), new Range(18.0f, 28.0f), new Range(8.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:dry_bushland", new Range[]{new Range(8.0f, 18.0f), new Range(16.0f, 26.0f), new Range(26.0f, 38.0f), new Range(18.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:eucalyptus_forest", new Range[]{new Range(8.0f, 18.0f), new Range(16.0f, 26.0f), new Range(26.0f, 36.0f), new Range(18.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:fen", new Range[]{new Range(0.0f, 10.0f), new Range(8.0f, 18.0f), new Range(16.0f, 26.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:flower_fields", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 20.0f), new Range(18.0f, 28.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:frozen_pine_taiga", new Range[]{new Range(-25.0f, -12.0f), new Range(-10.0f, 2.0f), new Range(6.0f, 14.0f), new Range(-8.0f, 0.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:frozen_tundra", new Range[]{new Range(-30.0f, -18.0f), new Range(-16.0f, -4.0f), new Range(-2.0f, 6.0f), new Range(-14.0f, -4.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:fungal_fen", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:glistering_meadow", new Range[]{new Range(0.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 28.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:golden_forest", new Range[]{new Range(-2.0f, 8.0f), new Range(8.0f, 16.0f), new Range(18.0f, 28.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:golden_fields", new Range[]{new Range(-1.0f, 9.0f), new Range(9.0f, 17.0f), new Range(17.0f, 27.0f), new Range(7.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:grassy_beach", new Range[]{new Range(4.0f, 12.0f), new Range(12.0f, 20.0f), new Range(20.0f, 30.0f), new Range(10.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:grassy_plains", new Range[]{new Range(-4.0f, 8.0f), new Range(8.0f, 18.0f), new Range(18.0f, 28.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:grove", new Range[]{new Range(-6.0f, 6.0f), new Range(6.0f, 14.0f), new Range(14.0f, 22.0f), new Range(4.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:heath", new Range[]{new Range(0.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 28.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:highlands", new Range[]{new Range(-10.0f, 2.0f), new Range(2.0f, 10.0f), new Range(12.0f, 20.0f), new Range(0.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:holly_woods", new Range[]{new Range(-4.0f, 8.0f), new Range(8.0f, 16.0f), new Range(16.0f, 26.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:hot_springs", new Range[]{new Range(6.0f, 16.0f), new Range(14.0f, 24.0f), new Range(18.0f, 30.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:hyacinth_fields", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 20.0f), new Range(18.0f, 28.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:ice_spikes", new Range[]{new Range(-30.0f, -18.0f), new Range(-18.0f, -6.0f), new Range(-10.0f, 0.0f), new Range(-20.0f, -8.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:icy_tundra", new Range[]{new Range(-26.0f, -14.0f), new Range(-14.0f, -4.0f), new Range(-6.0f, 4.0f), new Range(-16.0f, -6.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:ironwood_gour", new Range[]{new Range(6.0f, 16.0f), new Range(14.0f, 24.0f), new Range(26.0f, 36.0f), new Range(14.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:jacaranda_forest", new Range[]{new Range(6.0f, 14.0f), new Range(14.0f, 22.0f), new Range(22.0f, 32.0f), new Range(12.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:kapok_jungle", new Range[]{new Range(20.0f, 26.0f), new Range(26.0f, 34.0f), new Range(30.0f, 38.0f), new Range(22.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:lavender_meadow", new Range[]{new Range(4.0f, 12.0f), new Range(12.0f, 20.0f), new Range(18.0f, 26.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:lush_meadow", new Range[]{new Range(4.0f, 14.0f), new Range(14.0f, 22.0f), new Range(18.0f, 28.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:lush_stacks", new Range[]{new Range(8.0f, 18.0f), new Range(16.0f, 26.0f), new Range(24.0f, 32.0f), new Range(14.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:maple_taiga", new Range[]{new Range(-8.0f, 2.0f), new Range(2.0f, 10.0f), new Range(10.0f, 20.0f), new Range(0.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:marsh", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:mojave_desert", new Range[]{new Range(18.0f, 28.0f), new Range(26.0f, 36.0f), new Range(38.0f, 50.0f), new Range(24.0f, 34.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:neon_oasis", new Range[]{new Range(20.0f, 26.0f), new Range(26.0f, 34.0f), new Range(32.0f, 42.0f), new Range(22.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:orchard", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 20.0f), new Range(20.0f, 30.0f), new Range(10.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:overgrown_woodlands", new Range[]{new Range(4.0f, 12.0f), new Range(12.0f, 20.0f), new Range(20.0f, 28.0f), new Range(10.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:pale_bog", new Range[]{new Range(-2.0f, 6.0f), new Range(6.0f, 14.0f), new Range(14.0f, 22.0f), new Range(4.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:pink_grove", new Range[]{new Range(6.0f, 14.0f), new Range(14.0f, 22.0f), new Range(18.0f, 28.0f), new Range(8.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:prairie", new Range[]{new Range(-4.0f, 8.0f), new Range(8.0f, 18.0f), new Range(18.0f, 28.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:pumpkin_valley", new Range[]{new Range(-2.0f, 8.0f), new Range(8.0f, 16.0f), new Range(16.0f, 24.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:rainbow_beach", new Range[]{new Range(10.0f, 20.0f), new Range(20.0f, 28.0f), new Range(26.0f, 34.0f), new Range(18.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:red_rock_peaks", new Range[]{new Range(4.0f, 12.0f), new Range(12.0f, 20.0f), new Range(20.0f, 30.0f), new Range(10.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:redwood_thicket", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:rose_fields", new Range[]{new Range(0.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:rugged_badlands", new Range[]{new Range(8.0f, 18.0f), new Range(16.0f, 26.0f), new Range(30.0f, 42.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:sakura_grove", new Range[]{new Range(4.0f, 14.0f), new Range(14.0f, 22.0f), new Range(20.0f, 30.0f), new Range(10.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:sandy_dunes", new Range[]{new Range(16.0f, 26.0f), new Range(26.0f, 34.0f), new Range(36.0f, 46.0f), new Range(24.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:shattered_glacier", new Range[]{new Range(-28.0f, -16.0f), new Range(-16.0f, -6.0f), new Range(-8.0f, 2.0f), new Range(-18.0f, -8.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:sierra_badlands", new Range[]{new Range(6.0f, 16.0f), new Range(16.0f, 24.0f), new Range(28.0f, 38.0f), new Range(18.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:skyris_vale", new Range[]{new Range(2.0f, 12.0f), new Range(10.0f, 18.0f), new Range(16.0f, 26.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:snowy_taiga", new Range[]{new Range(-20.0f, -8.0f), new Range(-8.0f, 2.0f), new Range(2.0f, 10.0f), new Range(-6.0f, 0.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:steppe", new Range[]{new Range(-8.0f, 4.0f), new Range(4.0f, 12.0f), new Range(12.0f, 24.0f), new Range(2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:stone_prairie", new Range[]{new Range(-2.0f, 8.0f), new Range(8.0f, 16.0f), new Range(16.0f, 24.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:temperate_grove", new Range[]{new Range(-4.0f, 8.0f), new Range(8.0f, 18.0f), new Range(18.0f, 28.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:tropical_rainforest", new Range[]{new Range(20.0f, 26.0f), new Range(26.0f, 34.0f), new Range(30.0f, 38.0f), new Range(24.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:weeping_witch_forest", new Range[]{new Range(0.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:white_mangrove_marsh", new Range[]{new Range(8.0f, 18.0f), new Range(16.0f, 26.0f), new Range(26.0f, 34.0f), new Range(18.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:windswept_desert", new Range[]{new Range(18.0f, 26.0f), new Range(26.0f, 34.0f), new Range(36.0f, 46.0f), new Range(24.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:windswept_peaks", new Range[]{new Range(-10.0f, 0.0f), new Range(0.0f, 8.0f), new Range(8.0f, 16.0f), new Range(-2.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("regions_unexplored:zelkova_forest", new Range[]{new Range(-2.0f, 8.0f), new Range(8.0f, 16.0f), new Range(16.0f, 26.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:alpine_clearings", new Range[]{new Range(-10.0f, 2.0f), new Range(2.0f, 10.0f), new Range(10.0f, 18.0f), new Range(0.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:alpine_highlands", new Range[]{new Range(-12.0f, 0.0f), new Range(0.0f, 8.0f), new Range(8.0f, 16.0f), new Range(-2.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:amber_covert", new Range[]{new Range(-6.0f, 4.0f), new Range(4.0f, 12.0f), new Range(12.0f, 20.0f), new Range(2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:arid_highlands", new Range[]{new Range(8.0f, 18.0f), new Range(18.0f, 28.0f), new Range(28.0f, 38.0f), new Range(15.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:arid_savanna", new Range[]{new Range(12.0f, 22.0f), new Range(22.0f, 32.0f), new Range(32.0f, 40.0f), new Range(18.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:aspen_forest", new Range[]{new Range(-4.0f, 6.0f), new Range(6.0f, 14.0f), new Range(14.0f, 22.0f), new Range(4.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:bamboo_wetlands", new Range[]{new Range(18.0f, 26.0f), new Range(26.0f, 32.0f), new Range(32.0f, 38.0f), new Range(20.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:blooming_dunes", new Range[]{new Range(16.0f, 26.0f), new Range(26.0f, 34.0f), new Range(34.0f, 44.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:blooming_highlands", new Range[]{new Range(4.0f, 12.0f), new Range(12.0f, 20.0f), new Range(20.0f, 28.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:blooming_sugi_forest", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:boreal_taiga", new Range[]{new Range(-18.0f, -4.0f), new Range(-4.0f, 6.0f), new Range(6.0f, 16.0f), new Range(-2.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:carnation_fields", new Range[]{new Range(6.0f, 14.0f), new Range(14.0f, 22.0f), new Range(22.0f, 30.0f), new Range(10.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:chaparral", new Range[]{new Range(6.0f, 16.0f), new Range(16.0f, 24.0f), new Range(24.0f, 32.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:coniferous_covert", new Range[]{new Range(-6.0f, 4.0f), new Range(4.0f, 12.0f), new Range(12.0f, 20.0f), new Range(2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:cypress_fields", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:drylands", new Range[]{new Range(18.0f, 28.0f), new Range(28.0f, 36.0f), new Range(36.0f, 46.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:dusty_slopes", new Range[]{new Range(14.0f, 24.0f), new Range(24.0f, 32.0f), new Range(32.0f, 40.0f), new Range(16.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:fir_forest", new Range[]{new Range(-4.0f, 6.0f), new Range(6.0f, 14.0f), new Range(14.0f, 22.0f), new Range(4.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:floral_ridges", new Range[]{new Range(4.0f, 12.0f), new Range(12.0f, 20.0f), new Range(20.0f, 28.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:flowering_shrubland", new Range[]{new Range(4.0f, 12.0f), new Range(12.0f, 20.0f), new Range(20.0f, 28.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:golden_wilds", new Range[]{new Range(0.0f, 8.0f), new Range(8.0f, 16.0f), new Range(16.0f, 24.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:heather_fields", new Range[]{new Range(0.0f, 8.0f), new Range(8.0f, 16.0f), new Range(16.0f, 24.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:lavender_fields", new Range[]{new Range(8.0f, 16.0f), new Range(16.0f, 24.0f), new Range(24.0f, 32.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:lively_dunes", new Range[]{new Range(16.0f, 26.0f), new Range(26.0f, 34.0f), new Range(34.0f, 44.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:maple_woodlands", new Range[]{new Range(-2.0f, 8.0f), new Range(8.0f, 16.0f), new Range(16.0f, 24.0f), new Range(4.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:marigold_meadows", new Range[]{new Range(4.0f, 12.0f), new Range(12.0f, 20.0f), new Range(20.0f, 28.0f), new Range(8.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:marsh", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:oak_savanna", new Range[]{new Range(10.0f, 20.0f), new Range(20.0f, 28.0f), new Range(28.0f, 34.0f), new Range(14.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:prairie", new Range[]{new Range(-2.0f, 8.0f), new Range(8.0f, 18.0f), new Range(18.0f, 26.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:red_peaks", new Range[]{new Range(-8.0f, 2.0f), new Range(2.0f, 10.0f), new Range(10.0f, 18.0f), new Range(0.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("natures_spirit:redwood_forest", new Range[]{new Range(2.0f, 10.0f), new Range(10.0f, 18.0f), new Range(18.0f, 24.0f), new Range(6.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("terralith:alpha_islands", new Range[]{new Range(2.0f, 7.0f), new Range(9.0f, 15.0f), new Range(17.0f, 24.0f), new Range(10.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("terralith:alpine_grove", new Range[]{new Range(-10.0f, -3.0f), new Range(1.0f, 8.0f), new Range(10.0f, 17.0f), new Range(3.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("terralith:alpine_highlands", new Range[]{new Range(-15.0f, -5.0f), new Range(-2.0f, 6.0f), new Range(6.0f, 14.0f), new Range(0.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("terralith:amethyst_canyon", new Range[]{new Range(5.0f, 11.0f), new Range(12.0f, 18.0f), new Range(20.0f, 28.0f), new Range(14.0f, 19.0f)});
        BiomeTempConfig.putAllSeasons("terralith:amethyst_rainforest", new Range[]{new Range(15.0f, 20.0f), new Range(22.0f, 27.0f), new Range(26.0f, 32.0f), new Range(20.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("terralith:ancient_sands", new Range[]{new Range(10.0f, 20.0f), new Range(20.0f, 28.0f), new Range(30.0f, 42.0f), new Range(22.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("terralith:arid_highlands", new Range[]{new Range(5.0f, 15.0f), new Range(15.0f, 22.0f), new Range(28.0f, 35.0f), new Range(20.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("terralith:ashen_savanna", new Range[]{new Range(18.0f, 22.0f), new Range(22.0f, 28.0f), new Range(30.0f, 36.0f), new Range(25.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("terralith:basalt_cliffs", new Range[]{new Range(2.0f, 6.0f), new Range(8.0f, 14.0f), new Range(15.0f, 22.0f), new Range(10.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("terralith:birch_taiga", new Range[]{new Range(-8.0f, 0.0f), new Range(4.0f, 10.0f), new Range(14.0f, 22.0f), new Range(7.0f, 13.0f)});
        BiomeTempConfig.putAllSeasons("terralith:blooming_plateau", new Range[]{new Range(0.0f, 5.0f), new Range(10.0f, 17.0f), new Range(22.0f, 30.0f), new Range(12.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("terralith:brushland", new Range[]{new Range(5.0f, 10.0f), new Range(15.0f, 22.0f), new Range(30.0f, 38.0f), new Range(18.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("terralith:bryce_canyon", new Range[]{new Range(0.0f, 5.0f), new Range(10.0f, 17.0f), new Range(28.0f, 35.0f), new Range(15.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("terralith:caldera", new Range[]{new Range(2.0f, 8.0f), new Range(10.0f, 18.0f), new Range(18.0f, 26.0f), new Range(12.0f, 17.0f)});
        BiomeTempConfig.putAllSeasons("terralith:cloud_forest", new Range[]{new Range(10.0f, 15.0f), new Range(18.0f, 24.0f), new Range(26.0f, 30.0f), new Range(17.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("terralith:cold_shrubland", new Range[]{new Range(-8.0f, -2.0f), new Range(2.0f, 10.0f), new Range(14.0f, 20.0f), new Range(6.0f, 11.0f)});
        BiomeTempConfig.putAllSeasons("terralith:desert_canyon", new Range[]{new Range(12.0f, 18.0f), new Range(20.0f, 28.0f), new Range(35.0f, 45.0f), new Range(22.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("terralith:emerald_peaks", new Range[]{new Range(-12.0f, -4.0f), new Range(0.0f, 6.0f), new Range(8.0f, 15.0f), new Range(-2.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("terralith:forested_highlands", new Range[]{new Range(-5.0f, 2.0f), new Range(5.0f, 12.0f), new Range(15.0f, 22.0f), new Range(8.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("terralith:frozen_cliffs", new Range[]{new Range(-20.0f, -10.0f), new Range(-8.0f, 0.0f), new Range(0.0f, 5.0f), new Range(-5.0f, 0.0f)});
        BiomeTempConfig.putAllSeasons("terralith:glacial_chasm", new Range[]{new Range(-25.0f, -15.0f), new Range(-10.0f, -5.0f), new Range(-2.0f, 4.0f), new Range(-8.0f, -3.0f)});
        BiomeTempConfig.putAllSeasons("terralith:gravel_desert", new Range[]{new Range(5.0f, 12.0f), new Range(15.0f, 22.0f), new Range(30.0f, 38.0f), new Range(20.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("terralith:haze_mountain", new Range[]{new Range(0.0f, 4.0f), new Range(10.0f, 16.0f), new Range(20.0f, 28.0f), new Range(12.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("terralith:highlands", new Range[]{new Range(0.0f, 5.0f), new Range(8.0f, 15.0f), new Range(20.0f, 26.0f), new Range(12.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("terralith:hot_shrubland", new Range[]{new Range(8.0f, 12.0f), new Range(15.0f, 22.0f), new Range(28.0f, 36.0f), new Range(20.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("terralith:jungle_mountains", new Range[]{new Range(22.0f, 25.0f), new Range(25.0f, 30.0f), new Range(30.0f, 36.0f), new Range(24.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("terralith:lavender_forest", new Range[]{new Range(5.0f, 10.0f), new Range(12.0f, 18.0f), new Range(22.0f, 28.0f), new Range(14.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("terralith:mirage_isles", new Range[]{new Range(12.0f, 18.0f), new Range(20.0f, 26.0f), new Range(30.0f, 36.0f), new Range(20.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("terralith:moonlight_valley", new Range[]{new Range(4.0f, 9.0f), new Range(12.0f, 18.0f), new Range(22.0f, 28.0f), new Range(14.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("terralith:mountain_steppe", new Range[]{new Range(-5.0f, 2.0f), new Range(5.0f, 12.0f), new Range(18.0f, 24.0f), new Range(10.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("terralith:rocky_mountains", new Range[]{new Range(-8.0f, 0.0f), new Range(5.0f, 12.0f), new Range(20.0f, 28.0f), new Range(10.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("terralith:snowy_badlands", new Range[]{new Range(-5.0f, 0.0f), new Range(2.0f, 8.0f), new Range(10.0f, 16.0f), new Range(4.0f, 9.0f)});
        BiomeTempConfig.putAllSeasons("terralith:steppe", new Range[]{new Range(-3.0f, 5.0f), new Range(10.0f, 18.0f), new Range(25.0f, 32.0f), new Range(15.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("terralith:temperate_highlands", new Range[]{new Range(2.0f, 8.0f), new Range(12.0f, 18.0f), new Range(22.0f, 30.0f), new Range(14.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("terralith:tropical_jungle", new Range[]{new Range(24.0f, 28.0f), new Range(27.0f, 32.0f), new Range(32.0f, 38.0f), new Range(26.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("terralith:volcanic_peaks", new Range[]{new Range(10.0f, 16.0f), new Range(15.0f, 22.0f), new Range(25.0f, 32.0f), new Range(18.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("terralith:volcanic_plains", new Range[]{new Range(12.0f, 18.0f), new Range(18.0f, 24.0f), new Range(28.0f, 36.0f), new Range(20.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("terralith:weeping_witch_forest", new Range[]{new Range(4.0f, 9.0f), new Range(10.0f, 16.0f), new Range(20.0f, 26.0f), new Range(12.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("terralith:windy_snowfields", new Range[]{new Range(-20.0f, -10.0f), new Range(-8.0f, 0.0f), new Range(0.0f, 5.0f), new Range(-6.0f, -1.0f)});
        BiomeTempConfig.putAllSeasons("terralith:windswept_spires", new Range[]{new Range(-5.0f, 0.0f), new Range(5.0f, 10.0f), new Range(16.0f, 22.0f), new Range(8.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("terralith:winter_taiga", new Range[]{new Range(-15.0f, -5.0f), new Range(-2.0f, 5.0f), new Range(10.0f, 16.0f), new Range(2.0f, 7.0f)});
        BiomeTempConfig.putAllSeasons("terralith:withered_badlands", new Range[]{new Range(5.0f, 10.0f), new Range(15.0f, 22.0f), new Range(28.0f, 36.0f), new Range(18.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("terralith:wooded_badlands", new Range[]{new Range(5.0f, 10.0f), new Range(12.0f, 18.0f), new Range(25.0f, 32.0f), new Range(16.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("terralith:yellowstone", new Range[]{new Range(0.0f, 5.0f), new Range(10.0f, 16.0f), new Range(20.0f, 26.0f), new Range(12.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("terralith:yosemite_cliffs", new Range[]{new Range(-8.0f, -2.0f), new Range(5.0f, 12.0f), new Range(18.0f, 26.0f), new Range(10.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("terralith:yosemite_lowlands", new Range[]{new Range(0.0f, 6.0f), new Range(10.0f, 17.0f), new Range(22.0f, 30.0f), new Range(14.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("terralith:zen_garden", new Range[]{new Range(5.0f, 10.0f), new Range(12.0f, 18.0f), new Range(22.0f, 28.0f), new Range(14.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("terralith:ancient_dunes", new Range[]{new Range(8.0f, 14.0f), new Range(16.0f, 24.0f), new Range(34.0f, 42.0f), new Range(20.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("terralith:crimson_gardens", new Range[]{new Range(10.0f, 15.0f), new Range(15.0f, 22.0f), new Range(24.0f, 30.0f), new Range(16.0f, 21.0f)});
        BiomeTempConfig.putAllSeasons("terralith:skylands", new Range[]{new Range(-5.0f, 2.0f), new Range(4.0f, 10.0f), new Range(14.0f, 22.0f), new Range(6.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("terralith:skylands_forest", new Range[]{new Range(0.0f, 5.0f), new Range(8.0f, 14.0f), new Range(18.0f, 25.0f), new Range(10.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("terralith:skylands_plateau", new Range[]{new Range(-2.0f, 4.0f), new Range(7.0f, 12.0f), new Range(16.0f, 22.0f), new Range(9.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("terralith:skylands_valley", new Range[]{new Range(2.0f, 6.0f), new Range(10.0f, 16.0f), new Range(20.0f, 26.0f), new Range(12.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("terralith:windswept_archipelago", new Range[]{new Range(6.0f, 10.0f), new Range(12.0f, 18.0f), new Range(24.0f, 30.0f), new Range(16.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("terralith:oasis", new Range[]{new Range(10.0f, 16.0f), new Range(20.0f, 26.0f), new Range(30.0f, 38.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("terralith:savanna_slopes", new Range[]{new Range(14.0f, 20.0f), new Range(22.0f, 28.0f), new Range(30.0f, 36.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("terralith:red_oasis", new Range[]{new Range(10.0f, 16.0f), new Range(20.0f, 26.0f), new Range(32.0f, 40.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("terralith:glowcave", new Range[]{new Range(8.0f, 12.0f), new Range(14.0f, 20.0f), new Range(22.0f, 28.0f), new Range(16.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("terralith:overgrown_cliffs", new Range[]{new Range(2.0f, 8.0f), new Range(10.0f, 16.0f), new Range(20.0f, 26.0f), new Range(12.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("terralith:lavender_pines", new Range[]{new Range(0.0f, 5.0f), new Range(10.0f, 16.0f), new Range(20.0f, 28.0f), new Range(12.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("terralith:rainbow_rainforest", new Range[]{new Range(20.0f, 24.0f), new Range(24.0f, 28.0f), new Range(30.0f, 36.0f), new Range(26.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("terralith:crystal_canyon", new Range[]{new Range(5.0f, 10.0f), new Range(12.0f, 18.0f), new Range(26.0f, 32.0f), new Range(18.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("terralith:desert_spires", new Range[]{new Range(10.0f, 16.0f), new Range(20.0f, 28.0f), new Range(35.0f, 44.0f), new Range(22.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("terralith:ebony_woods", new Range[]{new Range(6.0f, 10.0f), new Range(12.0f, 18.0f), new Range(20.0f, 26.0f), new Range(14.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("terralith:ancient_forest", new Range[]{new Range(0.0f, 5.0f), new Range(10.0f, 16.0f), new Range(20.0f, 26.0f), new Range(12.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("terralith:orchid_swamp", new Range[]{new Range(6.0f, 12.0f), new Range(14.0f, 20.0f), new Range(24.0f, 30.0f), new Range(16.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("terralith:scarlet_forest", new Range[]{new Range(8.0f, 14.0f), new Range(16.0f, 22.0f), new Range(26.0f, 32.0f), new Range(18.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("terralith:snowy_taiga_valley", new Range[]{new Range(-10.0f, -3.0f), new Range(0.0f, 6.0f), new Range(10.0f, 18.0f), new Range(2.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("terralith:twilight_peak", new Range[]{new Range(-4.0f, 2.0f), new Range(5.0f, 12.0f), new Range(16.0f, 22.0f), new Range(8.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("terralith:warm_beach_cliff", new Range[]{new Range(12.0f, 18.0f), new Range(18.0f, 24.0f), new Range(26.0f, 32.0f), new Range(20.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("terralith:wetland_valley", new Range[]{new Range(8.0f, 14.0f), new Range(14.0f, 20.0f), new Range(22.0f, 28.0f), new Range(16.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("terralith:windswept_savanna", new Range[]{new Range(12.0f, 18.0f), new Range(20.0f, 26.0f), new Range(30.0f, 36.0f), new Range(22.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("tfc:ocean", new Range[]{new Range(-2.0f, 8.0f), new Range(4.0f, 14.0f), new Range(12.0f, 24.0f), new Range(6.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("tfc:deep_ocean", new Range[]{new Range(-4.0f, 6.0f), new Range(2.0f, 12.0f), new Range(10.0f, 20.0f), new Range(4.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("tfc:plains", new Range[]{new Range(-6.0f, 8.0f), new Range(4.0f, 18.0f), new Range(14.0f, 30.0f), new Range(6.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("tfc:high_plains", new Range[]{new Range(-10.0f, 4.0f), new Range(-2.0f, 16.0f), new Range(10.0f, 26.0f), new Range(2.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("tfc:swamp", new Range[]{new Range(0.0f, 12.0f), new Range(8.0f, 22.0f), new Range(16.0f, 32.0f), new Range(8.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("tfc:mountains", new Range[]{new Range(-16.0f, -2.0f), new Range(-8.0f, 8.0f), new Range(2.0f, 18.0f), new Range(-6.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("tfc:rolling_hills", new Range[]{new Range(-4.0f, 10.0f), new Range(6.0f, 20.0f), new Range(14.0f, 28.0f), new Range(6.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("tfc:high_hills", new Range[]{new Range(-12.0f, 2.0f), new Range(-2.0f, 14.0f), new Range(8.0f, 24.0f), new Range(-4.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("tfc:mountain_range", new Range[]{new Range(-18.0f, -4.0f), new Range(-10.0f, 6.0f), new Range(0.0f, 16.0f), new Range(-8.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("tfc:salt_swamp", new Range[]{new Range(4.0f, 16.0f), new Range(10.0f, 24.0f), new Range(18.0f, 34.0f), new Range(10.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("tfc:peat_bog", new Range[]{new Range(-6.0f, 8.0f), new Range(2.0f, 18.0f), new Range(10.0f, 26.0f), new Range(2.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("tfc:river", new Range[]{new Range(-2.0f, 10.0f), new Range(6.0f, 18.0f), new Range(12.0f, 26.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("tfc:beach", new Range[]{new Range(2.0f, 14.0f), new Range(8.0f, 22.0f), new Range(16.0f, 30.0f), new Range(8.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("tfc:gravel_beach", new Range[]{new Range(0.0f, 12.0f), new Range(6.0f, 20.0f), new Range(14.0f, 28.0f), new Range(6.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("tfc:lake", new Range[]{new Range(-2.0f, 10.0f), new Range(6.0f, 18.0f), new Range(12.0f, 26.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("tfc:shore", new Range[]{new Range(2.0f, 12.0f), new Range(8.0f, 20.0f), new Range(14.0f, 28.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("tfc:high_hills_edge", new Range[]{new Range(-8.0f, 6.0f), new Range(0.0f, 16.0f), new Range(10.0f, 24.0f), new Range(-2.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("tfc:mountain_edge", new Range[]{new Range(-10.0f, 2.0f), new Range(-2.0f, 12.0f), new Range(6.0f, 20.0f), new Range(-4.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("tfc:mountain_range_edge", new Range[]{new Range(-14.0f, 0.0f), new Range(-6.0f, 10.0f), new Range(4.0f, 18.0f), new Range(-6.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("tfc:foothills", new Range[]{new Range(-6.0f, 8.0f), new Range(2.0f, 18.0f), new Range(12.0f, 26.0f), new Range(4.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("tfc:lakeshore", new Range[]{new Range(0.0f, 12.0f), new Range(8.0f, 20.0f), new Range(14.0f, 28.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("tfc:riverbank", new Range[]{new Range(-2.0f, 10.0f), new Range(6.0f, 18.0f), new Range(12.0f, 26.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("tfc:estuary", new Range[]{new Range(2.0f, 14.0f), new Range(10.0f, 22.0f), new Range(16.0f, 30.0f), new Range(10.0f, 22.0f)});
    }

    public static enum Season {
        WINTER,
        SPRING,
        SUMMER,
        AUTUMN;

    }

    public record Range(float minC, float maxC) {
    }

    public record DailyRange(float minMin, float avgNight, float avgDay, float maxMax) {
    }
}

