/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.temperature.spike;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.Gabou.projectatmosphere.modules.temperature.spike.SpikeManager;
import net.Gabou.projectatmosphere.modules.temperature.spike.SpikeState;
import net.Gabou.projectatmosphere.util.RegionInstanceKey;
import net.Gabou.projectatmosphere.util.StorageUtils;
import net.minecraft.server.level.ServerLevel;

public class SpikeStateStorage {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String FILE_NAME = "spike_data.json";

    public static void saveAll(ServerLevel world) {
        JsonObject root = new JsonObject();
        for (Map.Entry<RegionInstanceKey, SpikeState> entry : SpikeManager.getAllStates().entrySet()) {
            JsonObject data = new JsonObject();
            SpikeState state = entry.getValue();
            data.addProperty("rx", (Number)entry.getKey().regionX());
            data.addProperty("rz", (Number)entry.getKey().regionZ());
            data.addProperty("size", (Number)entry.getKey().regionSize());
            data.addProperty("daysSinceLastSpike", (Number)state.daysSinceLastSpike);
            data.addProperty("remainingSpikeDays", (Number)state.remainingSpikeDays);
            data.addProperty("currentSpikeDay", (Number)state.currentSpikeDay);
            data.addProperty("spikeMagnitude", (Number)Float.valueOf(state.spikeMagnitude));
            root.add(entry.getKey().regionX() + "," + entry.getKey().regionZ() + "@" + entry.getKey().regionSize(), (JsonElement)data);
        }
        try {
            Path path = StorageUtils.getPerWorldSavePath(world, FILE_NAME);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
                GSON.toJson((JsonElement)root, (Appendable)w);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadAll(ServerLevel world) {
        Path SAVE_PATH = StorageUtils.getPerWorldSavePath(world, FILE_NAME);
        if (!Files.exists(SAVE_PATH, new LinkOption[0])) {
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(SAVE_PATH);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
            HashMap<RegionInstanceKey, SpikeState> loaded = new HashMap<RegionInstanceKey, SpikeState>();
            for (Map.Entry entry : root.entrySet()) {
                JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                int rx = obj.get("rx").getAsInt();
                int rz = obj.get("rz").getAsInt();
                int size = obj.get("size").getAsInt();
                RegionInstanceKey key = new RegionInstanceKey(rx, rz, size);
                SpikeState state = new SpikeState();
                state.daysSinceLastSpike = obj.get("daysSinceLastSpike").getAsInt();
                state.remainingSpikeDays = obj.get("remainingSpikeDays").getAsInt();
                state.currentSpikeDay = obj.get("currentSpikeDay").getAsInt();
                state.spikeMagnitude = obj.get("spikeMagnitude").getAsFloat();
                loaded.put(key, state);
            }
            SpikeManager.setAllStates(loaded);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void clearAll(ServerLevel world) {
        SpikeManager.clearSpikeCache(world);
        StorageUtils.clearCache(world, FILE_NAME);
    }
}

