/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.temperature.spike.commands;

import net.Gabou.projectatmosphere.modules.temperature.spike.SpikeData;

public class ApplyOngoingSpikeCommand {
    private final SpikeData data;

    public ApplyOngoingSpikeCommand(SpikeData data) {
        this.data = data;
    }

    public void execute() {
        int day;
        float mag = this.data.state().spikeMagnitude;
        for (int i = 0; i < this.data.state().remainingSpikeDays && (day = this.data.state().currentSpikeDay + i) < 7; ++i) {
            float[] fArray = this.data.week()[day];
            fArray[0] = fArray[0] + mag;
            float[] fArray2 = this.data.week()[day];
            fArray2[1] = fArray2[1] + mag;
            this.smoothNeighbors(this.data.week(), day, mag / 2.0f);
        }
        this.data.state().remainingSpikeDays = 0;
    }

    private void smoothNeighbors(float[][] week, int centerDay, float offset) {
        if (centerDay > 0) {
            float[] fArray = week[centerDay - 1];
            fArray[0] = fArray[0] + offset / 2.0f;
            float[] fArray2 = week[centerDay - 1];
            fArray2[1] = fArray2[1] + offset / 2.0f;
        }
        if (centerDay < 6) {
            float[] fArray = week[centerDay + 1];
            fArray[0] = fArray[0] + offset / 2.0f;
            float[] fArray3 = week[centerDay + 1];
            fArray3[1] = fArray3[1] + offset / 2.0f;
        }
    }
}

