/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.temperature.spike.commands;

import java.util.Random;
import net.Gabou.projectatmosphere.modules.temperature.spike.SpikeData;

public class StartNewSpikeCommand {
    private final SpikeData data;
    private static final Random random = new Random();

    public StartNewSpikeCommand(SpikeData data) {
        this.data = data;
    }

    public void execute() {
        boolean isHeat = random.nextBoolean();
        int startDay = random.nextInt(4);
        int duration = 3 + random.nextInt(2);
        float magnitude = this.generateWeightedSpikeMagnitude();
        if (!isHeat) {
            magnitude = -magnitude;
        }
        this.data.state().spikeMagnitude = magnitude;
        this.data.state().remainingSpikeDays = duration;
        this.data.state().currentSpikeDay = startDay;
        this.data.state().daysSinceLastSpike = 0;
    }

    private float generateWeightedSpikeMagnitude() {
        float max = 6.0f;
        return (float)((double)max - Math.pow(random.nextDouble(), 2.0) * (double)max);
    }
}

