/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import dev.nonamecrackers2.simpleclouds.common.world.SpawnRegion;
import net.Gabou.projectatmosphere.api.WindVectorApi;
import net.Gabou.projectatmosphere.api.common.cloud.region.ITornadoRegion;
import net.Gabou.projectatmosphere.api.common.cloud.region.TornadoDescriptor;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.DelayedTaskScheduler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TornadoCommand {
    private static final ResourceLocation PROJECTATMOSPHERE$TORNADO_CONTROLLER = new ResourceLocation("projectatmosphere", "command_spawn");
    private static final String PROJECTATMOSPHERE$CUMULONIMBUS_ID = "simpleclouds:cumulonimbus";
    private static final int PROJECTATMOSPHERE$SEARCH_RADIUS = 10;
    private static final float PROJECTATMOSPHERE$DEFAULT_RADIUS = 10.0f;
    private static final int PROJECTATMOSPHERE$SPAWN_DELAY_TICKS = 500;
    private static final int PROJECTATMOSPHERE$AWAIT_INTERVAL = 100;
    private static final int PROJECTATMOSPHERE$AWAIT_POLLS = 40;

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        LiteralArgumentBuilder baseCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnTornado").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerLevel level = player.m_284548_();
            if (!level.m_46472_().equals((Object)Level.f_46428_)) {
                return 0;
            }
            Vec3 playerPos = player.m_20182_();
            Vec3 tornadoPos = new Vec3(playerPos.f_82479_, (double)level.m_5736_(), playerPos.f_82481_);
            BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(player.m_20183_(), (Level)level), player.m_20183_());
            WindVectorApi.WindSample sample = WindVectorApi.getOrFallback(key);
            WindVector wind = WindVector.fromBase(sample.speedMps(), (float)Math.toRadians(sample.directionDeg()));
            CloudRegion existing = TornadoCommand.projectatmosphere$findCumulonimbus(level, tornadoPos);
            if (existing != null) {
                if (TornadoCommand.projectatmosphere$attachDescriptor(level, existing, tornadoPos)) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83c\udf2a\ufe0f Tornado engaged using SimpleClouds cumulonimbus."), true);
                    return 1;
                }
                TornadoCommand.projectatmosphere$awaitCloud((CommandSourceStack)ctx.getSource(), level, tornadoPos, 40);
                return 1;
            }
            CloudRegion spawnedRegion = SimpleCloudsCompat.spawnCloudInBiome("cumulonimbus", key, level, null, wind);
            if (spawnedRegion != null) {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                DelayedTaskScheduler.schedule(500, () -> {
                    if (TornadoCommand.projectatmosphere$attachDescriptor(level, spawnedRegion, tornadoPos)) {
                        source.m_288197_(() -> Component.m_237113_((String)"\ud83c\udf2a\ufe0f Tornado engaged once the seeded cumulonimbus matured."), true);
                    } else {
                        TornadoCommand.projectatmosphere$awaitCloud(source, level, tornadoPos, 40);
                    }
                });
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u2601\ufe0f Seeded a cumulonimbus; waiting for SimpleClouds tornado engagement."), true);
                return 1;
            }
            TornadoCommand.projectatmosphere$awaitCloud((CommandSourceStack)ctx.getSource(), level, tornadoPos, 40);
            return 1;
        });
        event.getDispatcher().register(baseCommand);
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawntornadoes").requires(source -> source.m_6761_(2))).executes(baseCommand.getCommand()));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cleartornadoes").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            TornadoManager.clearTornadoes();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83c\udf2a\ufe0f All tornadoes cleared."), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"removetornado").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerLevel level = player.m_284548_();
            if (!level.m_46472_().equals((Object)Level.f_46428_)) {
                return 0;
            }
            Vec3 playerPos = player.m_20182_();
            TornadoInstance tornado = TornadoManager.getActiveTornadoes().stream().filter(t -> t.position.m_82557_(playerPos) < 100.0).findFirst().orElse(null);
            if (tornado != null) {
                TornadoManager.removeTornado(tornado);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83c\udf2a\ufe0f Tornado removed."), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No tornado found near you."));
            }
            return 1;
        }));
    }

    private static void projectatmosphere$awaitCloud(CommandSourceStack source, ServerLevel level, Vec3 tornadoPos, int remainingPolls) {
        if (remainingPolls <= 0) {
            source.m_81352_((Component)Component.m_237113_((String)"\u26a0\ufe0f No SimpleClouds cumulonimbus became available for this tornado."));
            return;
        }
        DelayedTaskScheduler.schedule(100, () -> {
            CloudRegion region = TornadoCommand.projectatmosphere$findCumulonimbus(level, tornadoPos);
            if (region != null && TornadoCommand.projectatmosphere$attachDescriptor(level, region, tornadoPos)) {
                source.m_288197_(() -> Component.m_237113_((String)"\ud83c\udf2a\ufe0f Tornado engaged once a SimpleClouds cumulonimbus entered range."), true);
                return;
            }
            if (remainingPolls - 1 > 0) {
                TornadoCommand.projectatmosphere$awaitCloud(source, level, tornadoPos, remainingPolls - 1);
            } else {
                source.m_81352_((Component)Component.m_237113_((String)"\u26a0\ufe0f Timed out waiting for a suitable SimpleClouds cumulonimbus."));
            }
        });
    }

    private static CloudRegion projectatmosphere$findCumulonimbus(ServerLevel level, Vec3 pos) {
        SpawnRegion region = new SpawnRegion((int)Math.floor(pos.f_82479_), (int)Math.floor(pos.f_82481_), 10);
        for (CloudRegion cloud : CloudManager.get((Level)level).getClouds()) {
            if (!PROJECTATMOSPHERE$CUMULONIMBUS_ID.equals(cloud.getCloudTypeId().toString()) || !cloud.intersects(region)) continue;
            return cloud;
        }
        return null;
    }

    private static boolean projectatmosphere$attachDescriptor(ServerLevel level, CloudRegion region, Vec3 tornadoPos) {
        if (!(region instanceof ITornadoRegion)) {
            return false;
        }
        ITornadoRegion tornadoRegion = (ITornadoRegion)region;
        float offsetX = (float)(tornadoPos.f_82479_ - (double)region.getWorldX());
        float offsetZ = (float)(tornadoPos.f_82481_ - (double)region.getWorldZ());
        float cappedRadius = Math.max(2.0f, Math.min(10.0f, region.getWorldRadius()));
        float bottom = (float)Math.min(tornadoPos.f_82480_, (double)level.m_5736_());
        float height = Math.max(80.0f, cappedRadius * 12.0f);
        tornadoRegion.getTornadoes().removeIf(descriptor -> PROJECTATMOSPHERE$TORNADO_CONTROLLER.equals((Object)descriptor.getControllerId()));
        TornadoDescriptor descriptor2 = new TornadoDescriptor(PROJECTATMOSPHERE$TORNADO_CONTROLLER, offsetX, offsetZ, 0.0f, 0.0f, cappedRadius, bottom, height);
        tornadoRegion.addTornado(descriptor2);
        return true;
    }
}

