/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.wind;

import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.wind.WindForecast;
import net.Gabou.projectatmosphere.modules.wind.WindRuntimeState;

public final class HighWindModel {
    private HighWindModel() {
    }

    public static WindVector sample(WindForecast forecast, WindRuntimeState runtime, long worldTime) {
        WindVector target = forecast.sampleHigh(worldTime);
        float speed = HighWindModel.blend(runtime.getCurrentHighSpeed(), target.baseSpeed());
        float dirDeg = HighWindModel.blendAngle(runtime.getCurrentHighDirectionDeg(), (float)Math.toDegrees(target.angleRadians()));
        runtime.setCurrentHighSpeed(speed);
        runtime.setCurrentHighDirectionDeg(dirDeg);
        return new WindVector(speed, (float)Math.toRadians(dirDeg), target.gustSpeed());
    }

    private static float blend(float current, float target) {
        return current + (target - current) * 0.1f;
    }

    private static float blendAngle(float currentDeg, float targetDeg) {
        float delta = HighWindModel.wrapDegrees(targetDeg - currentDeg);
        return currentDeg + delta * 0.1f;
    }

    private static float wrapDegrees(float deg) {
        float wrapped = deg % 360.0f;
        if (wrapped <= -180.0f) {
            wrapped += 360.0f;
        }
        if (wrapped > 180.0f) {
            wrapped -= 360.0f;
        }
        return wrapped;
    }
}

