/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.wind;

import java.util.Random;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.wind.WindForecast;
import net.Gabou.projectatmosphere.modules.wind.WindRuntimeState;
import net.minecraft.util.Mth;

public final class LowWindModel {
    private LowWindModel() {
    }

    public static WindVector sample(WindForecast forecast, WindRuntimeState runtime, long worldTime, float stormChance) {
        WindVector target = forecast.sampleLow(worldTime);
        Random rng = new Random(worldTime + (long)Float.floatToIntBits(target.baseSpeed()));
        if (!runtime.isGustActive()) {
            float chance = forecast.gustProbability();
            chance += stormChance * forecast.stormGustProbability();
            if (rng.nextFloat() < chance) {
                LowWindModel.startGust(runtime, target, worldTime, rng, false);
            } else if (rng.nextFloat() < forecast.spikeProbability()) {
                LowWindModel.startGust(runtime, target, worldTime, rng, true);
            }
        } else if (worldTime >= runtime.getGustEndTick()) {
            runtime.setGustActive(false);
            runtime.setCurrentGustBonus(0.0f);
        }
        if (runtime.isGustActive()) {
            float decay = runtime.getCurrentGustBonus() * 0.05f;
            runtime.setCurrentGustBonus(Math.max(0.0f, runtime.getCurrentGustBonus() - decay));
            if (runtime.getCurrentGustBonus() <= 0.01f) {
                runtime.setGustActive(false);
            }
        }
        float gustedSpeed = target.baseSpeed() + runtime.getCurrentGustBonus();
        float smoothedSpeed = LowWindModel.blend(runtime.getCurrentLowSpeed(), gustedSpeed);
        float dirDeg = LowWindModel.blendAngle(runtime.getCurrentLowDirectionDeg(), (float)Math.toDegrees(target.angleRadians()));
        runtime.setCurrentLowSpeed(smoothedSpeed);
        runtime.setCurrentLowDirectionDeg(dirDeg);
        return new WindVector(smoothedSpeed, (float)Math.toRadians(dirDeg), smoothedSpeed + 0.5f * (target.gustSpeed() - target.baseSpeed()));
    }

    private static void startGust(WindRuntimeState runtime, WindVector target, long worldTime, Random rng, boolean spike) {
        float gustHeadroom = Math.max(0.0f, target.gustSpeed() - target.baseSpeed());
        float multiplier = spike ? 1.2f : 0.6f + rng.nextFloat() * 0.6f;
        float gustAmount = gustHeadroom * multiplier;
        runtime.setCurrentGustBonus(gustAmount);
        runtime.setGustActive(true);
        long duration = spike ? 40L + (long)rng.nextInt(40) : 80L + (long)rng.nextInt(120);
        runtime.setGustEndTick(worldTime + duration);
    }

    private static float blend(float current, float target) {
        return current + (target - current) * 0.2f;
    }

    private static float blendAngle(float currentDeg, float targetDeg) {
        float delta = LowWindModel.wrapDegrees(targetDeg - currentDeg);
        return currentDeg + delta * 0.2f;
    }

    private static float wrapDegrees(float deg) {
        float wrapped = Mth.m_14177_((float)deg);
        if (wrapped < -180.0f) {
            wrapped += 360.0f;
        }
        if (wrapped > 180.0f) {
            wrapped -= 360.0f;
        }
        return wrapped;
    }
}

