/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.wind;

import java.util.List;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.minecraft.world.phys.Vec3;

public final class TornadoWindModel {
    private TornadoWindModel() {
    }

    public static TornadoForces compute(Vec3 position) {
        double radius;
        List<TornadoInstance> active = TornadoManager.getActiveTornadoes();
        TornadoInstance nearest = null;
        double nearestDistSq = Double.MAX_VALUE;
        for (TornadoInstance tornado : active) {
            double distSq = tornado.position.m_82531_(position.f_82479_, tornado.position.f_82480_, position.f_82481_);
            if (!(distSq < nearestDistSq)) continue;
            nearest = tornado;
            nearestDistSq = distSq;
        }
        if (nearest == null) {
            return null;
        }
        Vec3 center = nearest.position;
        double dx = center.f_82479_ - position.f_82479_;
        double dz = center.f_82481_ - position.f_82481_;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        if (horizontalDist > (radius = Math.max(4.0, nearest.getSuctionRadius())) * 3.0) {
            return null;
        }
        double proximity = Math.max(0.0, 1.0 - Math.min(horizontalDist, radius) / radius);
        Vec3 pull = new Vec3(dx, 0.0, dz).m_82541_().m_82490_(proximity * 0.08 * (double)nearest.getLevel().getMaxWindSpeed());
        Vec3 swirlDir = horizontalDist > 0.001 ? new Vec3(-(dz / horizontalDist), 0.0, dx / horizontalDist) : Vec3.f_82478_;
        Vec3 rotation = swirlDir.m_82490_(proximity * proximity * 0.12 * (double)nearest.getLevel().getMaxWindSpeed());
        double liftScale = Math.max(0.0, 1.0 - Math.abs(position.f_82480_ - center.f_82480_) / 40.0);
        Vec3 lift = new Vec3(0.0, proximity * 0.04 * (double)nearest.getLevel().getMaxWindSpeed() * liftScale, 0.0);
        return new TornadoForces(pull, rotation, lift, nearest);
    }

    public record TornadoForces(Vec3 pullVector, Vec3 rotationVector, Vec3 liftVector, TornadoInstance source) {
    }
}

