/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.wind;

import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.wind.TornadoWindModel;
import net.Gabou.projectatmosphere.modules.wind.WindConfig;
import net.Gabou.projectatmosphere.modules.wind.WindEngine;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class WindForces {
    private WindForces() {
    }

    public static void applyToPlayer(ServerLevel level, ServerPlayer player, float deltaTime) {
        TornadoWindModel.TornadoForces tornado;
        BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(level, player.m_20183_());
        WindVector low = WindEngine.getCurrentLowWindVector(key, level.m_46467_());
        double windMagnitude = Math.max(low.baseSpeed(), low.gustSpeed());
        if (windMagnitude > (double)WindConfig.pushThresholdMps()) {
            Vec3 push = WindForces.dirToVec(low.angleRadians()).m_82490_(windMagnitude * (double)WindConfig.playerPushScale() * (double)deltaTime / 20.0);
            player.m_5997_(push.f_82479_, 0.0, push.f_82481_);
            player.f_19864_ = true;
        }
        if ((tornado = WindEngine.getCurrentTornadoForce(player.m_20182_())) != null) {
            WindForces.applyTornadoForce((LivingEntity)player, tornado, deltaTime);
        }
    }

    private static void applyTornadoForce(LivingEntity entity, TornadoWindModel.TornadoForces forces, float deltaTime) {
        double scale = deltaTime / 20.0f;
        Vec3 combined = forces.pullVector().m_82549_(forces.rotationVector()).m_82490_(scale);
        Vec3 lift = forces.liftVector().m_82490_(scale);
        entity.m_5997_(combined.f_82479_, lift.f_82480_, combined.f_82481_);
        entity.f_19864_ = true;
    }

    private static Vec3 dirToVec(float rad) {
        return new Vec3(-Math.sin(rad), 0.0, Math.cos(rad));
    }
}

