/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.wind;

import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.minecraft.util.Mth;

public final class WindForecast {
    private final WindSlice[] slices;
    private final float gustProbability;
    private final float stormGustProbability;
    private final float spikeProbability;

    public WindForecast(WindSlice[] slices, float gustProbability, float stormGustProbability, float spikeProbability) {
        this.slices = slices;
        this.gustProbability = gustProbability;
        this.stormGustProbability = stormGustProbability;
        this.spikeProbability = spikeProbability;
    }

    public WindSlice sliceForDay(long worldTime) {
        int day = (int)(worldTime / 24000L % (long)this.slices.length);
        return this.slices[Math.max(0, Math.min(day, this.slices.length - 1))];
    }

    public float gustProbability() {
        return this.gustProbability;
    }

    public float stormGustProbability() {
        return this.stormGustProbability;
    }

    public float spikeProbability() {
        return this.spikeProbability;
    }

    public WindVector sampleHigh(long worldTime) {
        WindSlice slice = this.sliceForDay(worldTime);
        float base = WindForecast.dailyCurve(slice.highBase(), worldTime);
        float gust = WindForecast.dailyCurve(slice.highGust(), worldTime);
        float dirRad = (float)Math.toRadians(slice.directionDeg());
        return new WindVector(base, dirRad, gust);
    }

    public WindVector sampleLow(long worldTime) {
        WindSlice slice = this.sliceForDay(worldTime);
        float base = WindForecast.dailyCurve(slice.lowBase(), worldTime);
        float gust = WindForecast.dailyCurve(slice.lowGust(), worldTime);
        float dirRad = (float)Math.toRadians(slice.directionDeg());
        return new WindVector(base, dirRad, gust);
    }

    private static float dailyCurve(float base, long worldTime) {
        float timeOfDay = (float)(worldTime % 24000L) / 24000.0f;
        float wave = (float)Math.sin(timeOfDay * ((float)Math.PI * 2));
        float dailyScale = 0.8f + 0.2f * wave;
        return Math.max(0.0f, base * dailyScale);
    }

    public static WindForecast fromBiomeForecast(BiomeForecast biomeForecast) {
        WindVector[] week = biomeForecast.getWind();
        if (week == null || week.length == 0) {
            return new WindForecast(new WindSlice[]{new WindSlice(0.0f, 0.0f, 0.0f, 0.0f, 0.0f)}, 0.0f, 0.0f, 0.0f);
        }
        WindSlice[] slices = new WindSlice[week.length];
        float baseProb = 0.15f;
        for (int i = 0; i < week.length; ++i) {
            WindVector vector = week[i] == null ? WindVector.fromBase(0.0f, 0.0f) : week[i];
            float baseSpeed = vector.baseSpeed();
            float gustSpeed = Math.max(vector.gustSpeed(), baseSpeed);
            float dirDeg = (float)Math.toDegrees(vector.angleRadians());
            float highBase = baseSpeed;
            float highGust = gustSpeed;
            float lowBase = baseSpeed * 0.65f;
            float lowGust = lowBase + (gustSpeed - baseSpeed) * 0.55f;
            slices[i] = new WindSlice(highBase, highGust, lowBase, lowGust, dirDeg);
            baseProb = Math.max(baseProb, Math.min(0.6f, (gustSpeed - baseSpeed) * 0.02f));
        }
        float spikeChance = Mth.m_14036_((float)(baseProb * 0.5f), (float)0.05f, (float)0.35f);
        float stormProb = Mth.m_14036_((float)(baseProb * 1.5f), (float)baseProb, (float)0.8f);
        return new WindForecast(slices, baseProb, stormProb, spikeChance);
    }

    public static final class WindSlice {
        private final float highBase;
        private final float highGust;
        private final float lowBase;
        private final float lowGust;
        private final float directionDeg;

        public WindSlice(float highBase, float highGust, float lowBase, float lowGust, float directionDeg) {
            this.highBase = highBase;
            this.highGust = highGust;
            this.lowBase = lowBase;
            this.lowGust = lowGust;
            this.directionDeg = directionDeg;
        }

        public float highBase() {
            return this.highBase;
        }

        public float highGust() {
            return this.highGust;
        }

        public float lowBase() {
            return this.lowBase;
        }

        public float lowGust() {
            return this.lowGust;
        }

        public float directionDeg() {
            return this.directionDeg;
        }
    }
}

