/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.wind;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.AtmosphericPhysics;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class WindGenerator {
    private static final Map<BiomeInstanceKey, Set<BiomeInstanceKey>> neighborCache = new ConcurrentHashMap<BiomeInstanceKey, Set<BiomeInstanceKey>>();
    private static final int MIN_DISTANCE = 200;
    private static final int MIN_DISTANCE_SQR = 40000;
    private static final int CELL_SIZE = 200;
    private static volatile Map<Long, BiomeInstanceKey[]> spatialIndex = Collections.emptyMap();
    private static volatile Set<BiomeInstanceKey> allSamples = Collections.emptySet();
    private static final float SPEED_SCALING = 1.0f;

    public static void buildNeighborIndex(Set<BiomeInstanceKey> samples) {
        if (samples == null || samples.isEmpty()) {
            spatialIndex = Collections.emptyMap();
            allSamples = Collections.emptySet();
            neighborCache.clear();
            return;
        }
        allSamples = samples;
        neighborCache.clear();
        HashMap<Long, List> buckets = new HashMap<Long, List>(samples.size() * 2);
        for (BiomeInstanceKey key : samples) {
            BlockPos pos = key.samplePos();
            int cellX = Math.floorDiv(pos.m_123341_(), 200);
            int cellZ = Math.floorDiv(pos.m_123343_(), 200);
            long cellKey = WindGenerator.toCellKey(cellX, cellZ);
            buckets.computeIfAbsent(cellKey, k -> new ArrayList()).add(key);
        }
        HashMap<Long, BiomeInstanceKey[]> index = new HashMap<Long, BiomeInstanceKey[]>(buckets.size() * 2);
        for (Map.Entry entry : buckets.entrySet()) {
            List list = (List)entry.getValue();
            index.put((Long)entry.getKey(), list.toArray(new BiomeInstanceKey[0]));
        }
        spatialIndex = index;
    }

    private static long toCellKey(int cellX, int cellZ) {
        return (long)cellX << 32 ^ (long)cellZ & 0xFFFFFFFFL;
    }

    private static Set<BiomeInstanceKey> getNeighbors(BiomeInstanceKey self, Set<BiomeInstanceKey> all) {
        HashSet<BiomeInstanceKey> existing;
        HashSet<BiomeInstanceKey> result;
        block6: {
            int centerZ;
            int centerX;
            block5: {
                Set<BiomeInstanceKey> cached = neighborCache.get(self);
                if (cached != null) {
                    return cached;
                }
                BlockPos center = self.samplePos();
                centerX = center.m_123341_();
                centerZ = center.m_123343_();
                int cellX = Math.floorDiv(centerX, 200);
                int cellZ = Math.floorDiv(centerZ, 200);
                result = new HashSet<BiomeInstanceKey>();
                Map<Long, BiomeInstanceKey[]> index = spatialIndex;
                if (index == null || index.isEmpty()) break block5;
                for (int dz = -1; dz <= 1; ++dz) {
                    int cz = cellZ + dz;
                    for (int dx = -1; dx <= 1; ++dx) {
                        int cx = cellX + dx;
                        BiomeInstanceKey[] bucket = index.get(WindGenerator.toCellKey(cx, cz));
                        if (bucket == null) continue;
                        for (BiomeInstanceKey other : bucket) {
                            int dzPos;
                            BlockPos o;
                            int dxPos;
                            int distSq;
                            if (other == self || (distSq = (dxPos = (o = other.samplePos()).m_123341_() - centerX) * dxPos + (dzPos = o.m_123343_() - centerZ) * dzPos) > 40000) continue;
                            result.add(other);
                        }
                    }
                }
                break block6;
            }
            if (all == null || all.isEmpty()) break block6;
            for (BiomeInstanceKey other : all) {
                int dzPos;
                BlockPos o;
                int dxPos;
                int distSq;
                if (other == self || (distSq = (dxPos = (o = other.samplePos()).m_123341_() - centerX) * dxPos + (dzPos = o.m_123343_() - centerZ) * dzPos) > 40000) continue;
                result.add(other);
            }
        }
        return (existing = (HashSet<BiomeInstanceKey>)neighborCache.putIfAbsent(self, result)) != null ? existing : result;
    }

    public static WindVector[] generateWindWeek(BiomeInstanceKey selfKey) {
        BlockPos center = selfKey.samplePos();
        int centerX = center.m_123341_();
        int centerZ = center.m_123343_();
        ResourceLocation biome = selfKey.biomeType();
        WindVector[] result = new WindVector[7];
        BiomeForecast biomeForecast = ForecastGenerator.getClosestValidForecast(selfKey, ForecastType.PRESSURE);
        if (biomeForecast == null) {
            for (int d = 0; d < 7; ++d) {
                float randomAngle = (float)(Math.random() * Math.PI * 2.0);
                result[d] = WindVector.fromBase(1.2f, randomAngle);
            }
            return result;
        }
        float[][] selfPressure = biomeForecast.getPressure();
        float[][] selfTemp = biomeForecast.getTemperature();
        float[][] selfHumidity = biomeForecast.getHumidity();
        Set<BiomeInstanceKey> neighbors = WindGenerator.getNeighbors(selfKey, ForecastGenerator.getBiomeSamples());
        float altitude = center.m_123342_();
        float biomeFactor = WindGenerator.getBiomeWindModifier(biome);
        double[] airDensity = AtmosphericPhysics.computeAirDensity(selfTemp, selfHumidity);
        for (int d = 0; d < 7; ++d) {
            float Pself = (selfPressure[d][0] + selfPressure[d][1]) * 0.5f;
            float Pavg = 0.0f;
            int count = 0;
            float sumVx = 0.0f;
            float sumVz = 0.0f;
            for (BiomeInstanceKey key : neighbors) {
                float dz;
                float[][] p;
                BiomeForecast forecast = ForecastGenerator.getClosestValidForecast(key, ForecastType.PRESSURE);
                if (forecast == null || (p = forecast.getPressure()) == null) continue;
                float Pn = (p[d][0] + p[d][1]) * 0.5f;
                Pavg += Pn;
                ++count;
                BlockPos neighborPos = key.samplePos();
                float dx = neighborPos.m_123341_() - centerX;
                float distSq = dx * dx + (dz = (float)(neighborPos.m_123343_() - centerZ)) * dz;
                if (distSq < 1.0E-4f) continue;
                float dist = Mth.m_14116_((float)distSq);
                float dP = Pself - Pn;
                float vx = dP * dx / dist;
                float vz = dP * dz / dist;
                sumVx += vx;
                sumVz += vz;
            }
            if (count == 0) {
                float randomAngle = (float)(Math.random() * Math.PI * 2.0);
                result[d] = WindVector.fromBase(1.2f, randomAngle);
                continue;
            }
            float dP = Math.abs((Pavg /= (float)count) - Pself);
            float densityFactor = (float)(airDensity[d] / (double)1.225f);
            float normalizedAltitude = Math.min(altitude / 256.0f, 1.0f);
            float altitudeFactor = 0.5f + 0.5f * normalizedAltitude;
            float speed = (float)Math.sqrt(2.0f * dP / densityFactor) * biomeFactor * altitudeFactor * 1.0f;
            speed = Mth.m_14036_((float)speed, (float)1.2f, (float)60.0f);
            int hash = selfKey.hashCode();
            float baseSpeed = speed;
            float gustFactor = Mth.m_14031_((float)((float)(d + hash % 50) * 0.6f)) * 0.5f + 1.6f;
            float gustSpeed = baseSpeed * gustFactor;
            gustSpeed = Mth.m_14036_((float)gustSpeed, (float)1.5f, (float)75.0f);
            float lenSq = sumVx * sumVx + sumVz * sumVz;
            float angle = lenSq > 1.0E-6f ? (float)Math.atan2(sumVz, sumVx) : 0.0f;
            result[d] = new WindVector(baseSpeed, angle, gustSpeed);
        }
        return result;
    }

    private static float getBiomeWindModifier(ResourceLocation biome) {
        String path = biome.m_135815_();
        if (path.contains("forest") || path.contains("taiga") || path.contains("jungle")) {
            return 0.7f;
        }
        if (path.contains("plains") || path.contains("savanna")) {
            return 1.1f;
        }
        if (path.contains("ocean") || path.contains("beach")) {
            return 1.25f;
        }
        if (path.contains("mountain") || path.contains("peak") || path.contains("windswept")) {
            return 1.4f;
        }
        return 1.0f;
    }
}

