/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.Gabou.projectatmosphere.client.BiomeClientTemperatureCache;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class BiomeDayTemperaturePacket {
    private final Map<ResourceLocation, float[]> temperatureDayMap;

    public BiomeDayTemperaturePacket(Map<ResourceLocation, float[]> temperatureDayMap) {
        this.temperatureDayMap = temperatureDayMap;
    }

    public BiomeDayTemperaturePacket(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        this.temperatureDayMap = new HashMap<ResourceLocation, float[]>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation biome = buf.m_130281_();
            int len = buf.m_130242_();
            float[] temps = new float[len];
            for (int j = 0; j < len; ++j) {
                temps[j] = buf.readFloat();
            }
            this.temperatureDayMap.put(biome, temps);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.temperatureDayMap.size());
        this.temperatureDayMap.forEach((biome, temps) -> {
            buf.m_130085_(biome);
            buf.m_130130_(((float[])temps).length);
            for (float f : temps) {
                buf.writeFloat(f);
            }
        });
    }

    public static BiomeDayTemperaturePacket decode(FriendlyByteBuf buf) {
        return new BiomeDayTemperaturePacket(buf);
    }

    public static void handle(BiomeDayTemperaturePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BiomeClientTemperatureCache.clear();
            BiomeClientTemperatureCache.updateDayForecasts(msg.temperatureDayMap);
        });
        ctx.get().setPacketHandled(true);
    }
}

