/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.particles;

import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class WindParticlePusher {
    private static final double NEAR_PLAYER_RADIUS = 24.0;
    private static final double LINE_OF_SIGHT_CHECK = 4.0;
    private static final double PUSH_SCALE = 0.0025;

    private WindParticlePusher() {
    }

    public static Vec3 computeWindPush(Level level, Vec3 position) {
        Player player = level.m_45924_(position.f_82479_, position.f_82480_, position.f_82481_, 24.0, false);
        if (player == null) {
            return Vec3.f_82478_;
        }
        BlockPos samplePos = BlockPos.m_274446_((Position)position);
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(samplePos, level), samplePos);
        WindVector wind = ForecastOrchestrator.getCurrentWind(key, level.m_46467_());
        float effectiveSpeed = Math.max(wind.baseSpeed(), wind.gustSpeed());
        if (effectiveSpeed < 0.25f) {
            return Vec3.f_82478_;
        }
        Vec3 direction = new Vec3(Math.cos(wind.angleRadians()), 0.0, Math.sin(wind.angleRadians()));
        if (direction.m_82556_() < 1.0E-6) {
            return Vec3.f_82478_;
        }
        if (WindParticlePusher.isUpwindBlocked(level, position, direction)) {
            return Vec3.f_82478_;
        }
        return direction.m_82541_().m_82490_((double)effectiveSpeed * 0.0025);
    }

    private static boolean isUpwindBlocked(Level level, Vec3 position, Vec3 direction) {
        Vec3 upwind = position.m_82546_(direction.m_82541_().m_82490_(4.0));
        ClipContext context = new ClipContext(upwind, position, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        return level.m_45547_(context).m_6662_() != HitResult.Type.MISS;
    }
}

