/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.seasons;

import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import net.Gabou.projectatmosphere.event.EclipticTracker;
import net.Gabou.projectatmosphere.seasons.SeasonSnapshot;
import net.Gabou.projectatmosphere.seasons.SeasonStage;
import net.Gabou.projectatmosphere.seasons.SeasonTimeDelegate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;

public class EclipticSeasonsSeasonDelegate
implements SeasonTimeDelegate {
    private static final int TERMS_PER_SEASON = 6;
    private static final int TOTAL_TERMS = 24;

    public EclipticSeasonsSeasonDelegate() {
        MinecraftForge.EVENT_BUS.addListener(EclipticTracker::onSolarTermChange);
    }

    @Override
    public SeasonSnapshot snapshot(Level level) {
        if (level == null) {
            return SeasonSnapshot.neutral();
        }
        SolarDataManager data = SolarHolders.getSaveData((Level)level);
        if (data == null) {
            return SeasonSnapshot.neutral();
        }
        SolarTerm term = data.getSolarTerm();
        int termIndex = data.getSolarTermIndex();
        int daysPerTerm = data.getSolarTermLastingDays();
        int seasonIndex = termIndex / 6;
        SeasonStage stage = switch (seasonIndex) {
            case 0 -> SeasonStage.SPRING;
            case 1 -> SeasonStage.SUMMER;
            case 2 -> SeasonStage.AUTUMN;
            case 3 -> SeasonStage.WINTER;
            default -> SeasonStage.SPRING;
        };
        int dayInSeason = data.getSolarTermDaysInPeriod() + termIndex % 6 * daysPerTerm;
        int totalSeasonDays = 6 * daysPerTerm;
        float progress = (float)dayInSeason / (float)totalSeasonDays;
        return new SeasonSnapshot(new ResourceLocation("eclipticseasons", "season"), stage, progress, 0.0f);
    }

    @Override
    public long seasonCycleTicks(Level level) {
        if (level == null) {
            return 2880000L;
        }
        SolarDataManager data = SolarHolders.getSaveData((Level)level);
        if (data == null) {
            return 2880000L;
        }
        long daysPerSeason = (long)data.getSolarTermLastingDays() * 6L;
        return daysPerSeason * 24000L;
    }

    @Override
    public long seasonDuration(Level level) {
        if (level == null) {
            return 720000L;
        }
        SolarDataManager data = SolarHolders.getSaveData((Level)level);
        if (data == null) {
            return 720000L;
        }
        return (long)data.getSolarTermLastingDays() * 6L * 24000L;
    }

    @Override
    public long dayDuration(Level level) {
        return 24000L;
    }
}

