/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.seasons;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.Gabou.projectatmosphere.seasons.SeasonProvider;
import net.Gabou.projectatmosphere.seasons.SeasonSnapshot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SeasonProviderRegistry {
    private static final Logger LOGGER = LogManager.getLogger((String)"ProjectAtmosphere/Seasons");
    private static final AtomicReference<SeasonProvider> ACTIVE = new AtomicReference<NeutralSeasonProvider>(new NeutralSeasonProvider());

    private SeasonProviderRegistry() {
    }

    public static void setProvider(SeasonProvider provider) {
        if (provider == null) {
            return;
        }
        SeasonProvider previous = ACTIVE.getAndSet(provider);
        ResourceLocation prevId = previous == null ? null : new ResourceLocation(previous.id());
        LOGGER.info("Season provider set to '{}' (previous: {}).", (Object)provider.id(), (Object)prevId);
    }

    public static SeasonProvider getProvider() {
        return Objects.requireNonNullElseGet(ACTIVE.get(), NeutralSeasonProvider::new);
    }

    public static SeasonSnapshot snapshot(Level level) {
        try {
            return SeasonProviderRegistry.getProvider().snapshot(level);
        }
        catch (Exception e) {
            LOGGER.warn("Season provider '{}' failed; falling back to neutral.", (Object)SeasonProviderRegistry.getProvider().id(), (Object)e);
            return SeasonSnapshot.neutral();
        }
    }

    private static final class NeutralSeasonProvider
    implements SeasonProvider {
        private static final ResourceLocation ID = new ResourceLocation("projectatmosphere", "neutral");

        private NeutralSeasonProvider() {
        }

        @Override
        public String id() {
            return ID.toString();
        }

        @Override
        public SeasonSnapshot snapshot(Level level) {
            return SeasonSnapshot.neutral();
        }
    }
}

