/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.seasons;

import java.util.concurrent.atomic.AtomicReference;
import net.Gabou.projectatmosphere.seasons.SeasonSnapshot;
import net.Gabou.projectatmosphere.seasons.SeasonStage;
import net.Gabou.projectatmosphere.seasons.SeasonTimeDelegate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SeasonTimeHelper {
    private static final Logger LOGGER = LogManager.getLogger((String)"ProjectAtmosphere/SeasonTime");
    private static final AtomicReference<SeasonTimeDelegate> DELEGATE = new AtomicReference<NeutralDelegate>(new NeutralDelegate());

    private SeasonTimeHelper() {
    }

    public static void setDelegate(SeasonTimeDelegate delegate) {
        if (delegate == null) {
            return;
        }
        DELEGATE.set(delegate);
        LOGGER.info("Season time delegate set to '{}'.", (Object)delegate.getClass().getName());
    }

    public static SeasonSnapshot snapshot(Level level) {
        try {
            return DELEGATE.get().snapshot(level);
        }
        catch (Exception e) {
            LOGGER.warn("Season delegate failed; using neutral snapshot.", (Throwable)e);
            return SeasonSnapshot.neutral();
        }
    }

    public static SeasonStage stage(Level level) {
        return SeasonTimeHelper.snapshot(level).stage();
    }

    public static long seasonCycleTicks(Level level) {
        try {
            return DELEGATE.get().seasonCycleTicks(level);
        }
        catch (Exception e) {
            return 96000L;
        }
    }

    public static long seasonDuration(Level level) {
        try {
            return DELEGATE.get().seasonDuration(level);
        }
        catch (Exception e) {
            return 24000L;
        }
    }

    public static long dayDuration(Level level) {
        try {
            return DELEGATE.get().dayDuration(level);
        }
        catch (Exception e) {
            return 24000L;
        }
    }

    private static final class NeutralDelegate
    implements SeasonTimeDelegate {
        static final long DAY_DURATION = 24000L;
        static final long SEASON_DURATION = 24000L;
        static final long SEASON_CYCLE = 96000L;
        private static final ResourceLocation ID = new ResourceLocation("projectatmosphere", "neutral");

        private NeutralDelegate() {
        }

        @Override
        public SeasonSnapshot snapshot(Level level) {
            return SeasonSnapshot.neutral();
        }

        @Override
        public long seasonCycleTicks(Level level) {
            return 96000L;
        }

        @Override
        public long seasonDuration(Level level) {
            return 24000L;
        }

        @Override
        public long dayDuration(Level level) {
            return 24000L;
        }
    }
}

