/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.seasons;

import net.Gabou.projectatmosphere.event.SeasonTracker;
import net.Gabou.projectatmosphere.seasons.SeasonSnapshot;
import net.Gabou.projectatmosphere.seasons.SeasonStage;
import net.Gabou.projectatmosphere.seasons.SeasonTimeDelegate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class SereneSeasonsSeasonDelegate
implements SeasonTimeDelegate {
    public SereneSeasonsSeasonDelegate() {
        SeasonTracker.register();
    }

    @Override
    public SeasonSnapshot snapshot(Level level) {
        if (level == null) {
            return SeasonSnapshot.neutral();
        }
        ISeasonState state = SeasonHelper.getSeasonState((Level)level);
        SeasonStage stage = switch (state.getSeason()) {
            default -> throw new IncompatibleClassChangeError();
            case Season.SPRING -> SeasonStage.SPRING;
            case Season.SUMMER -> SeasonStage.SUMMER;
            case Season.AUTUMN -> SeasonStage.AUTUMN;
            case Season.WINTER -> SeasonStage.WINTER;
        };
        float progress = (float)state.getDay() / (float)state.getSeasonDuration();
        return new SeasonSnapshot(new ResourceLocation("sereneseasons", "season"), stage, progress, 0.0f);
    }

    @Override
    public long seasonCycleTicks(Level level) {
        return level == null ? 96000L : (long)SeasonHelper.getSeasonState((Level)level).getSeasonCycleTicks();
    }

    @Override
    public long seasonDuration(Level level) {
        return level == null ? 24000L : (long)SeasonHelper.getSeasonState((Level)level).getSeasonDuration();
    }

    @Override
    public long dayDuration(Level level) {
        return level == null ? 24000L : (long)SeasonHelper.getSeasonState((Level)level).getDayDuration();
    }
}

