/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import com.google.gson.JsonObject;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.state.BlockState;

public class AtmosphereUtils {
    public static JsonObject serializeBlockPos(BlockPos pos) {
        JsonObject obj = new JsonObject();
        obj.addProperty("x", (Number)pos.m_123341_());
        obj.addProperty("y", (Number)pos.m_123342_());
        obj.addProperty("z", (Number)pos.m_123343_());
        return obj;
    }

    public static BlockPos deserializeBlockPos(JsonObject obj) {
        int x = obj.get("x").getAsInt();
        int y = obj.get("y").getAsInt();
        int z = obj.get("z").getAsInt();
        return new BlockPos(x, y, z);
    }

    public static BiomeInstanceKey getBiomeKey(ServerLevel level, BlockPos pos) {
        ResourceLocation biomeId = level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)((Biome)level.m_204166_(pos).m_203334_()));
        return new BiomeInstanceKey(biomeId, pos);
    }

    public static ResourceLocation getBiomeLocation(BlockPos pos, Level world) {
        return ((ResourceKey)world.m_204166_(pos).m_203543_().get()).m_135782_();
    }

    public static boolean isGlass(BlockState state) {
        return state.m_60734_() instanceof GlassBlock || state.m_60734_() instanceof StainedGlassBlock || state.m_60734_() instanceof StainedGlassPaneBlock || state.m_60734_() instanceof TintedGlassBlock;
    }

    public static float toMinecraftSimple(float celsius, boolean isTropical) {
        if (isTropical) {
            return 1.8f;
        }
        return celsius <= 0.0f ? 0.0f : 0.5f;
    }
}

