/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;

public record RegionInstanceKey(int regionX, int regionZ, int regionSize) {
    public static final int DEFAULT_REGION_SIZE = 2000;

    public RegionInstanceKey(int regionX, int regionZ) {
        this(regionX, regionZ, 2000);
    }

    public static RegionInstanceKey from(BlockPos pos) {
        return RegionInstanceKey.from(pos, 2000);
    }

    public static RegionInstanceKey from(BlockPos pos, int regionSize) {
        if (pos == null) {
            throw new IllegalArgumentException("Cannot build RegionInstanceKey from null position");
        }
        int rx = Math.floorDiv(pos.m_123341_(), regionSize);
        int rz = Math.floorDiv(pos.m_123343_(), regionSize);
        return new RegionInstanceKey(rx, rz, regionSize);
    }

    public BlockPos center() {
        int minX = this.regionX * this.regionSize;
        int minZ = this.regionZ * this.regionSize;
        return new BlockPos(minX + this.regionSize / 2, 0, minZ + this.regionSize / 2);
    }

    public boolean contains(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        int minX = this.regionX * this.regionSize;
        int minZ = this.regionZ * this.regionSize;
        int maxX = minX + this.regionSize;
        int maxZ = minZ + this.regionSize;
        return pos.m_123341_() >= minX && pos.m_123341_() < maxX && pos.m_123343_() >= minZ && pos.m_123343_() < maxZ;
    }

    public RegionInstanceKey neighbor(int dx, int dz) {
        return new RegionInstanceKey(this.regionX + dx, this.regionZ + dz, this.regionSize);
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("regionX", (Number)this.regionX);
        obj.addProperty("regionZ", (Number)this.regionZ);
        obj.addProperty("regionSize", (Number)this.regionSize);
        return obj;
    }

    public static RegionInstanceKey fromJson(JsonObject obj) {
        int size = obj.has("regionSize") ? obj.get("regionSize").getAsInt() : 2000;
        int rx = obj.get("regionX").getAsInt();
        int rz = obj.get("regionZ").getAsInt();
        return new RegionInstanceKey(rx, rz, size);
    }

    @Override
    @NotNull
    public String toString() {
        return "region[" + this.regionX + "," + this.regionZ + "]@" + this.regionSize;
    }
}

