/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;

public class TornadoMesh {
    private static int vao = -1;
    private static int vbo = -1;

    public static void init() {
        if (vao != -1) {
            return;
        }
        FloatBuffer vertexData = BufferUtils.createFloatBuffer((int)3);
        vertexData.put(0.0f).put(0.0f).put(0.0f).flip();
        vbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo);
        GL15.glBufferData((int)34962, (FloatBuffer)vertexData, (int)35044);
        vao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)vao);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)12, (long)0L);
        GL30.glBindVertexArray((int)0);
    }

    public static void drawInstanced(int count) {
        GL30.glBindVertexArray((int)vao);
        GL31.glDrawArraysInstanced((int)0, (int)0, (int)1, (int)count);
        GL30.glBindVertexArray((int)0);
    }

    public static int uploadTornadoSSBO(Vec3 pos, float radius, int count) {
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(24 * count));
        for (int i = 0; i < count; ++i) {
            buf.putInt(i);
            buf.putFloat((float)pos.f_82479_);
            buf.putFloat((float)pos.f_82480_);
            buf.putFloat((float)pos.f_82481_);
            buf.putFloat(radius);
            buf.putFloat(1.0f);
        }
        buf.flip();
        int ssbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)37074, (int)ssbo);
        GL15.glBufferData((int)37074, (ByteBuffer)buf, (int)35044);
        return ssbo;
    }

    public static void drawTestTriangle() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        buffer.m_5483_(0.0, 1.0, 0.0).m_6122_(255, 0, 0, 255).m_5752_();
        buffer.m_5483_(-1.0, -1.0, 0.0).m_6122_(0, 255, 0, 255).m_5752_();
        buffer.m_5483_(1.0, -1.0, 0.0).m_6122_(0, 0, 255, 255).m_5752_();
        tesselator.m_85914_();
    }

    public static void drawCone() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85814_);
        int segments = 20;
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)((double)i * Math.PI * 2.0 / (double)segments);
            float x = (float)Math.cos(angle);
            float z = (float)Math.sin(angle);
            buffer.m_5483_((double)x, 0.0, (double)z).m_5752_();
            buffer.m_5483_(0.0, 1.5, 0.0).m_5752_();
        }
        tesselator.m_85914_();
    }
}

