/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import com.mojang.brigadier.CommandDispatcher;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.command.DebugAtmoCommand;
import net.Gabou.projectatmosphere.command.SpawnCloudCommand;
import net.Gabou.projectatmosphere.event.EventHandler;
import net.Gabou.projectatmosphere.gameplay.WindPhysics;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.humidity.HumidityCommand;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneManager;
import net.Gabou.projectatmosphere.modules.pressure.PressureCommand;
import net.Gabou.projectatmosphere.modules.snowstorm.SnowstormManager;
import net.Gabou.projectatmosphere.modules.temperature.command.TemperatureCommands;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.modules.wind.WindCommand;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;

public class AtmosphereManager {
    private static final Map<UUID, CompletableFuture<Void>> playerReadyMap = new ConcurrentHashMap<UUID, CompletableFuture<Void>>();
    public static boolean isInitialGenerationDone = false;
    private static final List<BlockPos> allCenterOfMap = new ArrayList<BlockPos>();

    public static void onPlayerLogout(ServerLevel world, ServerPlayer player) {
        playerReadyMap.remove(player.m_20148_());
    }

    public static List<BlockPos> getAllCenterOfMap() {
        return allCenterOfMap;
    }

    public static void onServerStarting(ServerLevel world) {
        playerReadyMap.clear();
        isInitialGenerationDone = ForecastOrchestrator.onServerStart(world);
    }

    public static void onServerStopping(ServerLevel world) {
        ForecastOrchestrator.onServerStop(world);
        playerReadyMap.clear();
        isInitialGenerationDone = false;
    }

    public static void updateForecastAround(ServerLevel world, BlockPos center) {
        ProjectAtmosphere.LOGGER.info("Updating forecast Around");
        AsyncAtmosphereService.runWeather(() -> ForecastOrchestrator.updateForecast(world, center));
    }

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        TemperatureCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        HumidityCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PressureCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        WindCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SpawnCloudCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        DebugAtmoCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void onPlayerLogin(ServerLevel world, ServerPlayer player) {
        UUID uuid = player.m_20148_();
        CompletableFuture future = new CompletableFuture();
        playerReadyMap.put(uuid, future);
        world.m_7654_().execute(() -> {
            ForecastOrchestrator.onPlayerLogin(player, world);
            future.complete(null);
        });
    }

    public static CompletableFuture<Void> getPlayerReadyFuture(ServerPlayer player) {
        return playerReadyMap.computeIfAbsent(player.m_20148_(), uuid -> new CompletableFuture());
    }

    public static boolean isPlayerReady(UUID uuid) {
        CompletableFuture<Void> future = playerReadyMap.get(uuid);
        return future != null && future.isDone();
    }

    public static void onSwapProfiles(ServerLevel world) {
        ProjectAtmosphere.LOGGER.info("Swapping profiles and updating weather");
        AsyncAtmosphereService.runWeather(() -> ForecastOrchestrator.onSwapDay(world));
    }

    public static void onRegenerate(ServerLevel world) {
        ProjectAtmosphere.LOGGER.info("Regenerating weather data for all players");
        ForecastOrchestrator.clearActiveBiomeKeys();
        AsyncAtmosphereService.runWeather(() -> {
            ForecastGenerator.clearBiomeSamples();
            EventHandler.onRegenerate();
            CloudManager.get((Level)world).getCloudGenerator().removeAllClouds();
            TornadoManager.clearTornadoes();
            for (ServerPlayer player : world.m_6907_()) {
                BlockPos pos = player.m_20183_();
                allCenterOfMap.add(pos);
                ForecastOrchestrator.regenerateAround(world, pos);
            }
        });
    }

    public static void onSeasonChange(ServerLevel world) {
        AtmosphereManager.onRegenerate(world);
    }

    public static void tick(ServerLevel level) {
        ForecastOrchestrator.tick(level);
        WindPhysics.onServerTick(level);
        TornadoManager.tick((Level)level);
        HurricaneManager.tick(level);
        SnowstormManager.tick(level);
    }
}

