/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.wind;

import java.util.Random;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.wind.FloatRange;
import net.Gabou.projectatmosphere.modules.wind.WindConfig;
import net.Gabou.projectatmosphere.modules.wind.WindForecast;
import net.Gabou.projectatmosphere.modules.wind.WindForecastPart;
import net.Gabou.projectatmosphere.modules.wind.WindRuntimeState;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.server.level.ServerLevel;

public final class WindGustManager {
    private WindGustManager() {
    }

    public static float stormGustMultiplier(BiomeInstanceKey key, ServerLevel lvl) {
        float chance = ForecastOrchestrator.getCurrentStormChance(key, lvl.m_46467_());
        return chance > 0.5f ? WindConfig.stormGustMult() : 1.0f;
    }

    public static float maybeStartGust(WindRuntimeState s, WindForecast f, WindForecastPart p, float stormMult, long nowTick) {
        FloatRange range;
        Float prob = f.getGustProb().get((Object)p);
        if (prob == null) {
            return 0.0f;
        }
        double chance = prob.floatValue() * stormMult;
        Random random = new Random();
        if (random.nextDouble() < chance && (range = f.getGustRanges().get((Object)p)) != null) {
            float speed = range.random(new Random());
            s.setCurrentGustSpeed(speed);
            s.setGustEndTick(nowTick + (long)(WindConfig.gustMeanSec() * 20.0f));
            return speed;
        }
        return 0.0f;
    }

    public static void updateGustDecay(WindRuntimeState s, long nowTick, float decayPerSec) {
        if (s.getCurrentGustSpeed() <= 0.0f) {
            return;
        }
        if (nowTick >= s.getGustEndTick()) {
            s.setCurrentGustSpeed(0.0f);
            return;
        }
        float dec = decayPerSec / 20.0f;
        s.setCurrentGustSpeed(Math.max(0.0f, s.getCurrentGustSpeed() - dec));
    }

    public static void tick(WindRuntimeState s, WindForecast f, WindForecastPart p, BiomeInstanceKey key, ServerLevel lvl, long nowTick) {
        float mult = WindGustManager.stormGustMultiplier(key, lvl);
        if (s.getCurrentGustSpeed() <= 0.0f) {
            WindGustManager.maybeStartGust(s, f, p, mult, nowTick);
        } else {
            WindGustManager.updateGustDecay(s, nowTick, WindConfig.gustDecayMps());
        }
    }
}

