/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.event;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudGenerator;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.ServerCloudGenerator;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import dev.nonamecrackers2.simpleclouds.common.world.ServerCloudManager;
import net.Gabou.projectatmosphere.blocks.BlockManager;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.manager.AtmosphereManager;
import net.Gabou.projectatmosphere.manager.SimpleCloudSpawner;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class EventHandler {
    private static final int MIN_TICKS_BETWEEN_DUST_SPAWN = 5000;
    private static final int MIN_TICKS_BETWEEN_TEMPESTA = 2000;
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        Level level;
        if (event.getLevel().isClientSide || !((level = event.getLevel()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!AtmosphereManager.isInitialGenerationDone) {
            return;
        }
        if (serverLevel.players().isEmpty()) {
            return;
        }
        if (!serverLevel.dimension().equals(Level.OVERWORLD)) {
            return;
        }
        long t = serverLevel.getDayTime() % 24000L;
        if (t == 21000L) {
            AtmosphereManager.onSwapProfiles(serverLevel);
        }
        ServerCloudManager cloudManager = (ServerCloudManager)CloudManager.get((Level)serverLevel);
        ServerCloudGenerator generator = cloudManager.getCloudGenerator();
        AtmosphereManager.tick(serverLevel);
        if (generator.getTicksTillNextGen() <= 0) {
            SimpleCloudSpawner.trySpawnClouds(serverLevel, (CloudGenerator)generator);
        }
        if (!((Boolean)AtmoCommonConfig.ENABLE_STORM_DEBRIS.get()).booleanValue()) {
            return;
        }
        if (tickCounter % 2000 == 0) {
            int cloudY = cloudManager.getCloudHeight();
            for (CloudRegion region : generator.getClouds()) {
                int severity = CloudLibrary.getSeverityFromRessourceLocation(region.getCloudTypeId());
                if (severity <= 5) continue;
                BlockPos pos = new BlockPos((int)region.getWorldX(), cloudY, (int)region.getWorldZ());
                BlockManager.simulateTempesta(serverLevel, pos, (int)region.getRadius());
            }
        }
        ++tickCounter;
    }

    public static void onRegenerate() {
        tickCounter = 0;
    }
}

